<?php
header('Content-Type: application/json');

// Carrega configurações de banco
require_once __DIR__ . '/../config/database.php';

try {
    $pdo = getDBConnection();
    
    if (isset($_GET['id'])) {
        $stmt = $pdo->prepare("SELECT id, nome, email, nivel, ativo FROM usuarios WHERE id = ?");
        $stmt->execute([$_GET['id']]);
        $user = $stmt->fetch();
        
        if ($user) {
            echo json_encode($user);
        } else {
            echo json_encode(['error' => 'Usuário não encontrado']);
        }
    } else {
        echo json_encode(['error' => 'ID não fornecido']);
    }
    
} catch (PDOException $e) {
    echo json_encode(['error' => 'Erro no banco de dados: ' . $e->getMessage()]);
}