<?php
header('Content-Type: application/json');

// Carrega configurações de banco
require_once __DIR__ . '/../config/database.php';

try {
    $pdo = getDBConnection();
    
    if (isset($_GET['user_id'])) {
        $user_id = $_GET['user_id'];
        
        // Buscar todas as permissões
        $stmt = $pdo->query("SELECT id, nome, descricao FROM permissoes ORDER BY nome");
        $all_permissions = $stmt->fetchAll();
        
        // Buscar permissões do usuário
        $stmt = $pdo->prepare("SELECT permissao_id FROM usuario_permissoes WHERE usuario_id = ?");
        $stmt->execute([$user_id]);
        $user_permissions = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        echo json_encode([
            'all_permissions' => $all_permissions,
            'user_permissions' => $user_permissions
        ]);
    } else {
        echo json_encode(['error' => 'user_id não fornecido']);
    }
    
} catch (PDOException $e) {
    echo json_encode(['error' => 'Erro no banco de dados: ' . $e->getMessage()]);
}