<?php
/**
 * Configurações de Banco de Dados - SIMAE
 * 
 * Este arquivo centraliza todas as configurações de conexão com o banco de dados.
 * Altere apenas este arquivo para mudar as credenciais em todo o sistema.
 */

// Configurações do banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'simae_admin');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Opções PDO padrão
define('DB_OPTIONS', [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES " . DB_CHARSET
]);

/**
 * Função helper para criar conexão PDO
 * 
 * @return PDO
 * @throws PDOException
 */
function getDBConnection() {
    try {
        $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
        $pdo = new PDO($dsn, DB_USER, DB_PASS, DB_OPTIONS);
        return $pdo;
    } catch (PDOException $e) {
        // Em produção, não mostre detalhes do erro
        error_log('Erro de conexão com banco de dados: ' . $e->getMessage());
        throw new PDOException('Erro ao conectar com o banco de dados');
    }
}

/**
 * Função helper para obter DSN
 * 
 * @return string
 */
function getDBDSN() {
    return 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
}
