<?php
session_start();

// Carrega configurações de banco de dados
require_once __DIR__ . '/config/database.php';

// Verificar se está logado
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header('Location: login.php');
    exit;
}

$user_nome = $_SESSION['user_nome'] ?? 'Usuário';
$user_email = $_SESSION['user_email'] ?? '';

// Buscar configurações do sistema
try {
    $pdo = getDBConnection();
    $stmt = $pdo->query("SELECT * FROM configuracoes WHERE id = 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Se não encontrar configuração, usar valores padrão
    if (!$config) {
        $config = [
            'titulo_site' => 'SIMAE Admin',
            'logo_url' => '',
            'cor_primaria' => '#3b82f6'
        ];
    }
} catch (Exception $e) {
    $config = [
        'titulo_site' => 'SIMAE Admin',
        'logo_url' => '',
        'cor_primaria' => '#3b82f6'
    ];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SIMAE - Dashboard Administrativo</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0fdf4',
                            100: '#dcfce7',
                            200: '#bbf7d0',
                            300: '#86efac',
                            400: '#4ade80',
                            500: '#22c55e',
                            600: '#16a34a',
                            700: '#15803d',
                            800: '#166534',
                            900: '#14532d',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-50 h-screen flex">
    <!-- Sidebar -->
    <div class="w-64 bg-white shadow-lg flex flex-col">
        <!-- Logo -->
        <div class="p-6 border-b">
            <div class="flex items-center">
                <?php if (!empty($config['logo_url'])): ?>
                    <img src="<?php echo htmlspecialchars($config['logo_url']); ?>" alt="Logo" class="h-8 w-auto mr-3">
                <?php else: ?>
                    <i class="fas fa-shield-alt text-primary-600 text-2xl mr-3"></i>
                <?php endif; ?>
                <span class="text-xl font-bold text-gray-800">
                    <?php echo htmlspecialchars($config['site_title'] ?? 'SIMAE'); ?>
                </span>
            </div>
        </div>
        
        <!-- Navigation -->
        <nav class="flex-1 p-4 overflow-y-auto">
            <ul class="space-y-1">
                <li>
                    <a href="dashboard.php" class="flex items-center p-2 text-gray-700 rounded-lg bg-primary-50 text-primary-700 text-sm">
                        <i class="fas fa-dashboard mr-2"></i>Dashboard
                    </a>
                </li>
                <li>
                    <a href="?page=users" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-users mr-2"></i>Usuários
                    </a>
                </li>
                <li>
                    <a href="?page=permissions" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-user-shield mr-2"></i>Permissões
                    </a>
                </li>
                <li>
                    <a href="?page=condensado_leitura_iniciais" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-book-reader mr-2"></i>Leitura e Escrita (1º-5º)
                    </a>
                </li>
                <li>
                    <a href="?page=condensado_matematica_iniciais" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-calculator mr-2"></i>Matemática (1º-5º)
                    </a>
                </li>
                <li>
                    <a href="?page=condensado_supervisor" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-clipboard-check mr-2"></i>Supervisor (Infantil)
                    </a>
                </li>
                <li>
                    <a href="?page=condensado_leitura_finais" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-book-reader mr-2"></i>Leitura e Escrita (6º-9º)
                    </a>
                </li>
                <li>
                    <a href="?page=condensado_redacao_finais" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-pen-fancy mr-2"></i>Redação (6º-9º)
                    </a>
                </li>
                <li>
                    <a href="?page=condensado_matematica_finais" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-calculator mr-2"></i>Matemática (6º-9º)
                    </a>
                </li>
                <li>
                    <a href="?page=escolas_turmas" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-school mr-2"></i>Escolas e Turmas
                    </a>
                </li>
                <li>
                    <a href="?page=relatorios" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-chart-bar mr-2"></i>Relatórios
                    </a>
                </li>
                <li>
                    <a href="?page=settings" class="flex items-center p-2 text-gray-700 rounded-lg hover:bg-gray-100 text-sm">
                        <i class="fas fa-cog mr-2"></i>Configurações
                    </a>
                </li>
            </ul>
        </nav>
        
        <!-- User info -->
        <div class="p-4 border-t">
            <div class="flex items-center">
                <div class="w-8 h-8 bg-primary-600 rounded-full flex items-center justify-center text-white text-sm font-semibold">
                    <?php echo strtoupper(substr($user_nome, 0, 1)); ?>
                </div>
                <div class="ml-3 flex-1">
                    <p class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user_nome); ?></p>
                    <p class="text-xs text-gray-500"><?php echo htmlspecialchars($user_email); ?></p>
                </div>
                <a href="logout.php" class="text-gray-400 hover:text-red-600">
                    <i class="fas fa-sign-out-alt"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 flex flex-col overflow-hidden">
        <!-- Header -->
        <header class="bg-white shadow-sm border-b p-6">
            <h1 class="text-2xl font-bold text-gray-900">
                <?php 
                $page = $_GET['page'] ?? 'dashboard';
                switch($page) {
                    case 'users': echo 'Gerenciamento de Usuários'; break;
                    case 'permissions': echo 'Permissões e Acessos'; break;
                    case 'settings': echo 'Configurações do Sistema'; break;    
                    case 'condensado_leitura_iniciais': echo 'CONDENSADOS GERAL DE LEITURA E ESCRITA 1º AO 5º ANO'; break;
                    case 'condensado_matematica_iniciais': echo 'CONDENSADO GERAL MATEMÁTICA ANOS INICIAIS 1º AO 5º ANO'; break;
                    case 'condensado_supervisor': echo 'SUPERVISOR: MONITORAMENTO DA APRENDIZAGEM - CONDENSADO'; break;
                    case 'condensado_leitura_finais': echo 'CONDENSADO GERAL DE LEITURA E ESCRITA 6º AO 9º ANO'; break;
                    case 'condensado_redacao_finais': echo 'CONDENSADO GERAL DE REDAÇÃO 6º AO 9º ANO'; break;
                    case 'condensado_matematica_finais': echo 'CONDENSADO GERAL DE MATEMÁTICA 6º AO 9º ANO'; break;
                    case 'escolas_turmas': echo 'Escolas, Séries e Turmas'; break;
                    case 'relatorios': echo 'SISTEMA DE RELATÓRIOS'; break;
                    case 'relatorio_visualizar': echo 'VISUALIZAR RELATÓRIO'; break;
                    case 'relatorio_pdf': echo 'GERAR PDF'; break;
                    case 'relatorio_excel': echo 'EXPORTAR EXCEL'; break;
                    default: echo 'Dashboard'; break;
                }
                ?>
            </h1>
        </header>

        <!-- Page Content -->
        <main class="flex-1 overflow-y-auto p-6">
            <?php
            $page = $_GET['page'] ?? 'dashboard';
            
            switch($page) {
                case 'users':
                    include 'pages/users.php';
                    break;
                case 'permissions':
                    include 'pages/permissions.php';
                    break;
                case 'settings':
                    include 'pages/settings.php';
                    break;
                case 'condensado_leitura':
                    include 'pages/condensado_geral_leitura_escrita_1a5.php';
                    break;
                case 'condensado_matematica':
                    include 'pages/condensado_geral_matematica_1a5.php';
                    break;
                case 'condensado_matematica_iniciais':
                    include 'pages/condensado_matematica_iniciais.php';
                    break;
                case 'condensado_leitura_iniciais':
                    include 'pages/condensado_leitura_iniciais.php';
                    break;
                case 'condensado_supervisor':
                    include 'pages/condensado_supervisor.php';
                    break;
                case 'condensado_leitura_finais':
                    include 'pages/condensado_leitura_finais.php';
                    break;
                case 'condensado_redacao_finais':
                    include 'pages/condensado_redacao_finais.php';
                    break;
                case 'condensado_matematica_finais':
                    include 'pages/condensado_matematica_finais.php';
                    break;
                case 'escolas_turmas':
                    include 'pages/escolas_turmas.php';
                    break;
                case 'relatorios':
                    include 'pages/relatorios.php';
                    break;
                case 'relatorio_visualizar':
                    include 'pages/relatorio_visualizar.php';
                    break;
                case 'relatorio_pdf':
                    include 'pages/relatorio_pdf.php';
                    break;
                case 'relatorio_excel':
                    include 'pages/relatorio_excel.php';
                    break;
                default:
                    include 'pages/home.php';
                    break;
            }
            ?>
        </main>
    </div>
</body>
</html>