<?php
require_once 'Database.php';

class Auth {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }
    
    public function login($email, $senha) {
        try {
            // Buscar usuário na tabela usuarios (estrutura do database.sql)
            $stmt = $this->db->prepare("SELECT * FROM usuarios WHERE email = ? AND ativo = 1");
            $stmt->execute([$email]);
            $user = $stmt->fetch();

            if (!$user) {
                error_log("Usuário não encontrado: " . $email);
                return false;
            }

            // Verificar a senha
            if (password_verify($senha, $user['senha'])) {
                // Configurar a sessão
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_nome'] = $user['nome'];
                $_SESSION['user_nivel'] = $user['nivel'];
                $_SESSION['logado'] = true;
                
                // Atualizar último login
                $stmt = $this->db->prepare("UPDATE usuarios SET ultimo_login = NOW() WHERE id = ?");
                $stmt->execute([$user['id']]);
                
                error_log("Login bem-sucedido para: " . $email);
                return true;
            }
            
            error_log("Senha incorreta para usuário: " . $email);
            return false;
        } catch (PDOException $e) {
            error_log("Erro no login: " . $e->getMessage());
            return false;
        }
    }
    
    public function hasPermission($permission) {
        return isset($_SESSION['permissions']) && in_array($permission, $_SESSION['permissions']);
    }
    
    public function isLoggedIn() {
        return isset($_SESSION['logado']) && $_SESSION['logado'] === true;
    }
    
    public function logout() {
        session_destroy();
    }
    
    public function getMenus() {
        try {
            $stmt = $this->db->prepare("
                SELECT m.* 
                FROM menus m
                LEFT JOIN permissions p ON m.permission_id = p.id
                WHERE m.status = 'ativo'
                AND (m.permission_id IS NULL OR p.codigo IN (" . 
                implode(',', array_fill(0, count($_SESSION['permissions']), '?')) . "))
                ORDER BY m.ordem
            ");
            
            $stmt->execute($_SESSION['permissions']);
            return $stmt->fetchAll();
        } catch (PDOException $e) {
            error_log("Erro ao buscar menus: " . $e->getMessage());
            return [];
        }
    }
    
    public function getSystemSettings() {
        try {
            $stmt = $this->db->query("SELECT * FROM configuracoes WHERE id = 1");
            $config = $stmt->fetch();
            
            if ($config) {
                return $config;
            } else {
                return [
                    'titulo_site' => 'SIMAE',
                    'descricao_site' => 'Sistema de Administração',
                    'logo_url' => '',
                    'favicon_url' => '',
                    'cor_primaria' => '#16a34a',
                    'cor_secundaria' => '#15803d',
                    'cor_texto' => '#374151',
                    'cor_fundo' => '#f9fafb'
                ];
            }
        } catch (PDOException $e) {
            error_log("Erro ao buscar configurações: " . $e->getMessage());
            return [
                'titulo_site' => 'SIMAE',
                'descricao_site' => 'Sistema de Administração',
                'logo_url' => '',
                'favicon_url' => '',
                'cor_primaria' => '#16a34a',
                'cor_secundaria' => '#15803d',
                'cor_texto' => '#374151',
                'cor_fundo' => '#f9fafb'
            ];
        }
    }
}