<?php
/**
 * Include padrão para páginas do sistema SIMAE
 * 
 * Use este arquivo no início das páginas para garantir:
 * - Sessão iniciada
 * - Configuração de banco carregada
 * - Conexão PDO disponível
 */

// Inicia sessão se ainda não estiver iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Carrega configurações de banco de dados
require_once __DIR__ . '/../config/database.php';

// Cria conexão PDO global para a página
try {
    $pdo = getDBConnection();
} catch (Exception $e) {
    die('Erro ao conectar com o banco de dados. Verifique as configurações.');
}
