<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Tabela condensados de matemática (6º ao 9º ano)
$pdo->exec("CREATE TABLE IF NOT EXISTS condensado_matematica_finais (
    id INT AUTO_INCREMENT PRIMARY KEY,
    escola_id INT NOT NULL,
    serie_id INT NOT NULL,
    turma_id INT NOT NULL,
    ano_letivo INT NOT NULL,
    bimestre INT DEFAULT 1,
    
    total_alunos INT DEFAULT 0,
    alunos_necessidades_especiais INT DEFAULT 0,
    
    le_registra_numeros INT DEFAULT 0,
    interpreta_quantidades INT DEFAULT 0,
    compara_estabelece_relacoes INT DEFAULT 0,
    
    calculo_adicao INT DEFAULT 0,
    calculo_subtracao INT DEFAULT 0,
    calculo_multiplicacao INT DEFAULT 0,
    calculo_divisao INT DEFAULT 0,
    calculo_potenciacao INT DEFAULT 0,
    calculo_radiciacao INT DEFAULT 0,
    
    resolve_problemas_simples INT DEFAULT 0,
    resolve_problemas_complexos INT DEFAULT 0,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_turma_ano (escola_id, serie_id, turma_id, ano_letivo, bimestre)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

$escolas = $pdo->query('SELECT * FROM escolas ORDER BY nome')->fetchAll();

$msg_ok = '';
$msg_err = '';

// Capturar filtros
$escola_id = isset($_GET['escola']) ? (int)$_GET['escola'] : 0;
$serie_id = isset($_GET['serie']) ? (int)$_GET['serie'] : 0;
$turma_id = isset($_GET['turma']) ? (int)$_GET['turma'] : 0;
$bimestre = isset($_GET['bimestre']) ? (int)$_GET['bimestre'] : 1;
$ano_letivo = isset($_GET['ano_letivo']) ? (int)$_GET['ano_letivo'] : (int)date('Y');

// Buscar séries dinamicamente (apenas 6º ao 9º Ano)
$series_db = array();
if ($escola_id) {
    $st = $pdo->prepare("SELECT id, nome_serie FROM escola_series WHERE escola_id = ? AND (
        nome_serie LIKE '%6º ANO%' OR nome_serie LIKE '%6° ANO%' OR nome_serie LIKE '%6ª SÉRIE%' OR nome_serie LIKE '%6° SÉRIE%' OR
        nome_serie LIKE '%7º ANO%' OR nome_serie LIKE '%7° ANO%' OR nome_serie LIKE '%7ª SÉRIE%' OR nome_serie LIKE '%7° SÉRIE%' OR
        nome_serie LIKE '%8º ANO%' OR nome_serie LIKE '%8° ANO%' OR nome_serie LIKE '%8ª SÉRIE%' OR nome_serie LIKE '%8° SÉRIE%' OR
        nome_serie LIKE '%9º ANO%' OR nome_serie LIKE '%9° ANO%' OR nome_serie LIKE '%9ª SÉRIE%' OR nome_serie LIKE '%9° SÉRIE%'
    ) ORDER BY nome_serie");
    $st->execute(array($escola_id));
    $series_db = $st->fetchAll();
}

// Buscar turmas dinamicamente
$turmas_db = array();
if ($escola_id && $serie_id) {
    $st = $pdo->prepare('SELECT id, nome_turma FROM turmas WHERE escola_id = ? AND serie_id = ? ORDER BY nome_turma');
    $st->execute(array($escola_id, $serie_id));
    $turmas_db = $st->fetchAll();
}

// Carregar dados existentes
$dados_existentes = null;
if ($escola_id && $serie_id && $turma_id) {
    $st = $pdo->prepare('SELECT * FROM condensado_matematica_finais WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
    $st->execute(array($escola_id, $serie_id, $turma_id, $ano_letivo, $bimestre));
    $dados_existentes = $st->fetch();
}

// Salvar / Atualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save_condensado_matematica_finais') {
    $escola_id_post = (int)($_POST['escola_id'] ?? 0);
    $serie_id_post = (int)($_POST['serie_id'] ?? 0);
    $turma_id_post = (int)($_POST['turma_id'] ?? 0);
    $ano_letivo_post = (int)($_POST['ano_letivo'] ?? date('Y'));
    $bimestre_post = (int)($_POST['bimestre'] ?? 1);

    $total_alunos = (int)($_POST['total_alunos'] ?? 0);
    $alunos_necessidades_especiais = (int)($_POST['alunos_necessidades_especiais'] ?? 0);

    $le_registra_numeros = (int)($_POST['le_registra_numeros'] ?? 0);
    $interpreta_quantidades = (int)($_POST['interpreta_quantidades'] ?? 0);
    $compara_estabelece_relacoes = (int)($_POST['compara_estabelece_relacoes'] ?? 0);

    $calculo_adicao = (int)($_POST['calculo_adicao'] ?? 0);
    $calculo_subtracao = (int)($_POST['calculo_subtracao'] ?? 0);
    $calculo_multiplicacao = (int)($_POST['calculo_multiplicacao'] ?? 0);
    $calculo_divisao = (int)($_POST['calculo_divisao'] ?? 0);
    $calculo_potenciacao = (int)($_POST['calculo_potenciacao'] ?? 0);
    $calculo_radiciacao = (int)($_POST['calculo_radiciacao'] ?? 0);

    $resolve_problemas_simples = (int)($_POST['resolve_problemas_simples'] ?? 0);
    $resolve_problemas_complexos = (int)($_POST['resolve_problemas_complexos'] ?? 0);

    if ($escola_id_post && $serie_id_post && $turma_id_post) {
        // Verificar se já existe
        $st = $pdo->prepare('SELECT id FROM condensado_matematica_finais WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
        $st->execute(array($escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $existente = $st->fetch();

        if ($existente) {
            // Update
            $upd = $pdo->prepare('UPDATE condensado_matematica_finais SET 
                total_alunos=?, alunos_necessidades_especiais=?,
                le_registra_numeros=?, interpreta_quantidades=?, compara_estabelece_relacoes=?,
                calculo_adicao=?, calculo_subtracao=?, calculo_multiplicacao=?, calculo_divisao=?, calculo_potenciacao=?, calculo_radiciacao=?,
                resolve_problemas_simples=?, resolve_problemas_complexos=?
                WHERE id = ?');
            $upd->execute(array(
                $total_alunos, $alunos_necessidades_especiais,
                $le_registra_numeros, $interpreta_quantidades, $compara_estabelece_relacoes,
                $calculo_adicao, $calculo_subtracao, $calculo_multiplicacao, $calculo_divisao, $calculo_potenciacao, $calculo_radiciacao,
                $resolve_problemas_simples, $resolve_problemas_complexos,
                $existente['id']
            ));
            $msg_ok = 'Condensado atualizado com sucesso!';
        } else {
            // Insert
            $ins = $pdo->prepare('INSERT INTO condensado_matematica_finais (
                escola_id, serie_id, turma_id, ano_letivo, bimestre, total_alunos, alunos_necessidades_especiais,
                le_registra_numeros, interpreta_quantidades, compara_estabelece_relacoes,
                calculo_adicao, calculo_subtracao, calculo_multiplicacao, calculo_divisao, calculo_potenciacao, calculo_radiciacao,
                resolve_problemas_simples, resolve_problemas_complexos
            ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
            $ins->execute(array(
                $escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post, $total_alunos, $alunos_necessidades_especiais,
                $le_registra_numeros, $interpreta_quantidades, $compara_estabelece_relacoes,
                $calculo_adicao, $calculo_subtracao, $calculo_multiplicacao, $calculo_divisao, $calculo_potenciacao, $calculo_radiciacao,
                $resolve_problemas_simples, $resolve_problemas_complexos
            ));
            $msg_ok = 'Condensado salvo com sucesso!';
        }

        // Reload
        $st = $pdo->prepare('SELECT * FROM condensado_matematica_finais WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
        $st->execute(array($escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $dados_existentes = $st->fetch();

        $escola_id = $escola_id_post;
        $serie_id = $serie_id_post;
        $turma_id = $turma_id_post;
        $ano_letivo = $ano_letivo_post;
    } else {
        $msg_err = 'Selecione Escola, Série e Turma antes de salvar.';
    }
}

// Buscar nomes para exibição
$escola_nome = '';
$serie_nome = '';
$turma_nome = '';
if ($escola_id) {
    $st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
    $st->execute(array($escola_id));
    $esc = $st->fetch();
    if ($esc) $escola_nome = $esc['nome'];
}
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute(array($serie_id));
    $s = $st->fetch();
    if ($s) $serie_nome = $s['nome_serie'];
}
if ($turma_id) {
    $st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
    $st->execute(array($turma_id));
    $t = $st->fetch();
    if ($t) $turma_nome = $t['nome_turma'];
}
?>

<div class="max-w-full">
    <div class="bg-white rounded-lg shadow-md">
        <div class="bg-gradient-to-r from-green-600 to-green-800 text-white px-6 py-4 ">
            <h2 class="text-2xl font-bold flex items-center">
                <i class="fas fa-calculator mr-3"></i>
                Condensado Geral de Matemática - 6º ao 9º Ano
            </h2>
            <p class="text-blue-100 mt-1">Selecione a Escola, Série e Turma, depois insira os dados agregados da turma.</p>
        </div>

        <div class="p-6">
            <?php if ($msg_ok): ?><div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?php echo $msg_ok; ?></div><?php endif; ?>
            <?php if ($msg_err): ?><div class="mb-4 p-3 bg-red-100 text-red-700 rounded"><?php echo $msg_err; ?></div><?php endif; ?>

            <!-- Filtros -->
            <div class="bg-gradient-to-r from-green-50 to-emerald-50 border-2 border-green-200 rounded-lg p-6 mb-6">
                <h3 class="text-lg font-bold text-green-800 mb-4">
                    <i class="fas fa-filter mr-2"></i>Seleção de Turma
                </h3>
                <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                    <input type="hidden" name="page" value="condensado_matematica_finais">
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-school mr-1 text-green-600"></i>Escola
                        </label>
                        <select name="escola" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($escolas as $esc): ?>
                            <option value="<?php echo $esc['id']; ?>" <?php echo $escola_id == $esc['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($esc['nome']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-layer-group mr-1 text-green-600"></i>Série (6º-9º Ano)
                        </label>
                        <select name="serie" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($series_db as $s): ?>
                            <option value="<?php echo $s['id']; ?>" <?php echo $serie_id == $s['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($s['nome_serie']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-users mr-1 text-green-600"></i>Turma
                        </label>
                        <select name="turma" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($turmas_db as $t): ?>
                            <option value="<?php echo $t['id']; ?>" <?php echo $turma_id == $t['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($t['nome_turma']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-check mr-1 text-green-600"></i>Bimestre
                        </label>
                        <select name="bimestre" onchange="this.form.submit()" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white">
                            <option value="1" <?php echo $bimestre == 1 ? 'selected' : ''; ?>>1º Bimestre</option>
                            <option value="2" <?php echo $bimestre == 2 ? 'selected' : ''; ?>>2º Bimestre</option>
                            <option value="3" <?php echo $bimestre == 3 ? 'selected' : ''; ?>>3º Bimestre</option>
                            <option value="4" <?php echo $bimestre == 4 ? 'selected' : ''; ?>>4º Bimestre</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-alt mr-1 text-green-600"></i>Ano Letivo
                        </label>
                        <select name="ano_letivo" onchange="this.form.submit()" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white">
                            <?php for ($a = date('Y'); $a >= 2020; $a--): ?>
                            <option value="<?php echo $a; ?>" <?php echo $ano_letivo == $a ? 'selected' : ''; ?>><?php echo $a; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button type="submit" class="w-full bg-green-600 text-white px-4 py-3 rounded-md font-semibold hover:bg-green-700 shadow-md hover:shadow-lg transition-all">
                            <i class="fas fa-filter mr-2"></i>Filtrar
                        </button>
                    </div>
                </form>
            </div>

            <?php if ($escola_id && $serie_id && $turma_id && $bimestre && $ano_letivo): ?>
            <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6">
                <p class="font-semibold">Turma Selecionada: <?php echo htmlspecialchars($escola_nome . ' > ' . $serie_nome . ' > Turma ' . $turma_nome); ?></p>
                <p class="text-sm">Bimestre: <?php echo $bimestre; ?>º | Ano Letivo: <?php echo $ano_letivo; ?></p>
            </div>

            <!-- Formulário -->
            <form method="POST" class="space-y-6">
                <input type="hidden" name="action" value="save_condensado_matematica_finais">
                <input type="hidden" name="bimestre" value="<?php echo $bimestre; ?>">
                <input type="hidden" name="escola_id" value="<?php echo $escola_id; ?>">
                <input type="hidden" name="serie_id" value="<?php echo $serie_id; ?>">
                <input type="hidden" name="turma_id" value="<?php echo $turma_id; ?>">
                <input type="hidden" name="ano_letivo" value="<?php echo $ano_letivo; ?>">

                <!-- Campos Gerais -->
                <div class="bg-green-50 border-2 border-green-300 shadow rounded-lg p-6">
                    <h3 class="text-lg font-bold mb-4 text-green-700">Informações Gerais</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Número Total de Alunos</label>
                            <input type="number" name="total_alunos" value="<?php echo $dados_existentes['total_alunos'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Alunos com Necessidades Especiais</label>
                            <input type="number" name="alunos_necessidades_especiais" value="<?php echo $dados_existentes['alunos_necessidades_especiais'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500">
                        </div>
                    </div>
                </div>

                <!-- Tabela Horizontal -->
                <div class="bg-white shadow rounded-lg p-6 overflow-x-auto">
                    <h3 class="text-lg font-bold mb-4 text-green-700">Matemática - Total por Turma</h3>
                    <table class="w-full border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-green-600 text-white">
                                <th colspan="9" class="border border-gray-300 px-4 py-3 text-center font-bold">HABILIDADES NUMÉRICAS E OPERATÓRIAS</th>
                                <th colspan="2" class="border border-gray-300 px-4 py-3 text-center font-bold">RESOLUÇÃO DE PROBLEMAS</th>
                            </tr>
                            <tr class="bg-gray-100 text-xs">
                                <th class="border border-gray-300 px-2 py-2">Lê e Registra Números</th>
                                <th class="border border-gray-300 px-2 py-2">Interpreta Quantidades/Valores</th>
                                <th class="border border-gray-300 px-2 py-2">Compara e Estabelece Relações</th>
                                <th colspan="6" class="border border-gray-300 px-2 py-2">REALIZA CÁLCULOS COM COMPREENSÃO DOS PROCESSOS ENVOLVIDOS</th>
                                <th class="border border-gray-300 px-2 py-2">Resolve Situações Problemas Simples</th>
                                <th class="border border-gray-300 px-2 py-2">Resolve Situações Problemas Complexas</th>
                            </tr>
                            <tr class="bg-gray-50 text-xs">
                                <th class="border border-gray-300 px-2 py-2"></th>
                                <th class="border border-gray-300 px-2 py-2"></th>
                                <th class="border border-gray-300 px-2 py-2"></th>
                                <th class="border border-gray-300 px-2 py-2">Adição</th>
                                <th class="border border-gray-300 px-2 py-2">Subtração</th>
                                <th class="border border-gray-300 px-2 py-2">Multiplicação</th>
                                <th class="border border-gray-300 px-2 py-2">Divisão</th>
                                <th class="border border-gray-300 px-2 py-2">Potenciação</th>
                                <th class="border border-gray-300 px-2 py-2">Radiciação</th>
                                <th class="border border-gray-300 px-2 py-2"></th>
                                <th class="border border-gray-300 px-2 py-2"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 p-1"><input type="number" name="le_registra_numeros" value="<?php echo $dados_existentes['le_registra_numeros'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="interpreta_quantidades" value="<?php echo $dados_existentes['interpreta_quantidades'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="compara_estabelece_relacoes" value="<?php echo $dados_existentes['compara_estabelece_relacoes'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="calculo_adicao" value="<?php echo $dados_existentes['calculo_adicao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="calculo_subtracao" value="<?php echo $dados_existentes['calculo_subtracao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="calculo_multiplicacao" value="<?php echo $dados_existentes['calculo_multiplicacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="calculo_divisao" value="<?php echo $dados_existentes['calculo_divisao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="calculo_potenciacao" value="<?php echo $dados_existentes['calculo_potenciacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="calculo_radiciacao" value="<?php echo $dados_existentes['calculo_radiciacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="resolve_problemas_simples" value="<?php echo $dados_existentes['resolve_problemas_simples'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="resolve_problemas_complexos" value="<?php echo $dados_existentes['resolve_problemas_complexos'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 text-lg font-semibold">
                        <i class="fas fa-save mr-2"></i>Salvar Condensado
                    </button>
                </div>
            </form>
            <?php else: ?>
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 text-gray-700">
                    <p class="text-center">Selecione Escola, Série e Turma acima para cadastrar o condensado.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
