<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Tabela condensados de matemática por turma
$pdo->exec("CREATE TABLE IF NOT EXISTS condensado_matematica_turma (
    id INT AUTO_INCREMENT PRIMARY KEY,
    escola_id INT NOT NULL,
    serie_id INT NOT NULL,
    turma_id INT NOT NULL,
    ano_letivo INT NOT NULL,
    bimestre INT DEFAULT 1,
    
    total_alunos INT DEFAULT 0,
    necessidades_especiais INT DEFAULT 0,
    
    le_registra_numeros INT DEFAULT 0,
    interpreta_quantidades INT DEFAULT 0,
    compara_estabelece_relacoes INT DEFAULT 0,
    realiza_adicao INT DEFAULT 0,
    realiza_subtracao INT DEFAULT 0,
    realiza_multiplicacao INT DEFAULT 0,
    realiza_divisao INT DEFAULT 0,
    resolve_problemas_simples INT DEFAULT 0,
    resolve_problemas_complexos INT DEFAULT 0,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_turma_ano (escola_id, serie_id, turma_id, ano_letivo, bimestre)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

$escolas = $pdo->query('SELECT * FROM escolas ORDER BY nome')->fetchAll();

$msg_ok = '';
$msg_err = '';

// Capturar filtros
$escola_id = isset($_GET['escola']) ? (int)$_GET['escola'] : 0;
$serie_id = isset($_GET['serie']) ? (int)$_GET['serie'] : 0;
$turma_id = isset($_GET['turma']) ? (int)$_GET['turma'] : 0;
$ano_letivo = isset($_GET['ano_letivo']) ? (int)$_GET['ano_letivo'] : (int)date('Y');
$bimestre = isset($_GET['bimestre']) ? (int)$_GET['bimestre'] : 1;

// Buscar séries dinamicamente (apenas 1º ao 5º Ano)
$series_db = array();
if ($escola_id) {
    $st = $pdo->prepare("SELECT id, nome_serie FROM escola_series WHERE escola_id = ? AND (
        nome_serie LIKE '%1º ANO%' OR nome_serie LIKE '%1° ANO%' OR nome_serie LIKE '%1ª SÉRIE%' OR nome_serie LIKE '%1° SÉRIE%' OR
        nome_serie LIKE '%2º ANO%' OR nome_serie LIKE '%2° ANO%' OR nome_serie LIKE '%2ª SÉRIE%' OR nome_serie LIKE '%2° SÉRIE%' OR
        nome_serie LIKE '%3º ANO%' OR nome_serie LIKE '%3° ANO%' OR nome_serie LIKE '%3ª SÉRIE%' OR nome_serie LIKE '%3° SÉRIE%' OR
        nome_serie LIKE '%4º ANO%' OR nome_serie LIKE '%4° ANO%' OR nome_serie LIKE '%4ª SÉRIE%' OR nome_serie LIKE '%4° SÉRIE%' OR
        nome_serie LIKE '%5º ANO%' OR nome_serie LIKE '%5° ANO%' OR nome_serie LIKE '%5ª SÉRIE%' OR nome_serie LIKE '%5° SÉRIE%'
    ) ORDER BY nome_serie");
    $st->execute(array($escola_id));
    $series_db = $st->fetchAll();
}
$turmas_db = array();
if ($escola_id && $serie_id) {
    $st = $pdo->prepare('SELECT id, nome_turma FROM turmas WHERE escola_id = ? AND serie_id = ? ORDER BY nome_turma');
    $st->execute(array($escola_id, $serie_id));
    $turmas_db = $st->fetchAll();
}

// Determinar ano_tipo baseado na série selecionada
$ano_tipo = '1ano';
$serie_nome = '';
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute(array($serie_id));
    $s = $st->fetch();
    if ($s) {
        $serie_nome = $s['nome_serie'];
        $serie_upper = strtoupper($serie_nome);
        
        // Detectar 1º ao 5º Ano
        if (strpos($serie_upper, '1') !== false && (strpos($serie_upper, 'ANO') !== false || strpos($serie_upper, 'SÉRIE') !== false || strpos($serie_upper, 'SERIE') !== false)) {
            $ano_tipo = '1ano';
        } elseif (strpos($serie_upper, '2') !== false && (strpos($serie_upper, 'ANO') !== false || strpos($serie_upper, 'SÉRIE') !== false || strpos($serie_upper, 'SERIE') !== false)) {
            $ano_tipo = '2ano';
        } elseif (strpos($serie_upper, '3') !== false && (strpos($serie_upper, 'ANO') !== false || strpos($serie_upper, 'SÉRIE') !== false || strpos($serie_upper, 'SERIE') !== false)) {
            $ano_tipo = '3ano';
        } elseif (strpos($serie_upper, '4') !== false && (strpos($serie_upper, 'ANO') !== false || strpos($serie_upper, 'SÉRIE') !== false || strpos($serie_upper, 'SERIE') !== false)) {
            $ano_tipo = '4ano';
        } elseif (strpos($serie_upper, '5') !== false && (strpos($serie_upper, 'ANO') !== false || strpos($serie_upper, 'SÉRIE') !== false || strpos($serie_upper, 'SERIE') !== false)) {
            $ano_tipo = '5ano';
        }
    }
}

// Carregar dados existentes
$dados_existentes = null;
if ($escola_id && $serie_id && $turma_id) {
    $st = $pdo->prepare('SELECT * FROM condensado_matematica_turma WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
    $st->execute(array($escola_id, $serie_id, $turma_id, $ano_letivo, $bimestre));
    $dados_existentes = $st->fetch();
}

// Salvar / Atualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save_condensado_matematica') {
    $escola_id_post = (int)($_POST['escola_id'] ?? 0);
    $serie_id_post = (int)($_POST['serie_id'] ?? 0);
    $turma_id_post = (int)($_POST['turma_id'] ?? 0);
    $ano_letivo_post = (int)($_POST['ano_letivo'] ?? date('Y'));
    $bimestre_post = (int)($_POST['bimestre'] ?? 1);

    $total_alunos = (int)($_POST['total_alunos'] ?? 0);
    $necessidades_especiais = (int)($_POST['necessidades_especiais'] ?? 0);

    $le_registra_numeros = (int)($_POST['le_registra_numeros'] ?? 0);
    $interpreta_quantidades = (int)($_POST['interpreta_quantidades'] ?? 0);
    $compara_estabelece_relacoes = (int)($_POST['compara_estabelece_relacoes'] ?? 0);
    $realiza_adicao = (int)($_POST['realiza_adicao'] ?? 0);
    $realiza_subtracao = (int)($_POST['realiza_subtracao'] ?? 0);
    $realiza_multiplicacao = (int)($_POST['realiza_multiplicacao'] ?? 0);
    $realiza_divisao = (int)($_POST['realiza_divisao'] ?? 0);
    $resolve_problemas_simples = (int)($_POST['resolve_problemas_simples'] ?? 0);
    $resolve_problemas_complexos = (int)($_POST['resolve_problemas_complexos'] ?? 0);

    if ($escola_id_post && $serie_id_post && $turma_id_post) {
        // Verificar se já existe
        $st = $pdo->prepare('SELECT id FROM condensado_matematica_turma WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
        $st->execute(array($escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $existente = $st->fetch();

        if ($existente) {
            // Update
            $upd = $pdo->prepare('UPDATE condensado_matematica_turma SET total_alunos=?, necessidades_especiais=?,
                le_registra_numeros=?, interpreta_quantidades=?, compara_estabelece_relacoes=?,
                realiza_adicao=?, realiza_subtracao=?, realiza_multiplicacao=?, realiza_divisao=?,
                resolve_problemas_simples=?, resolve_problemas_complexos=?
                WHERE id = ?');
            $upd->execute(array(
                $total_alunos, $necessidades_especiais,
                $le_registra_numeros, $interpreta_quantidades, $compara_estabelece_relacoes,
                $realiza_adicao, $realiza_subtracao, $realiza_multiplicacao, $realiza_divisao,
                $resolve_problemas_simples, $resolve_problemas_complexos,
                $existente['id']
            ));
            $msg_ok = 'Condensado atualizado com sucesso!';
        } else {
            // Insert
            $ins = $pdo->prepare('INSERT INTO condensado_matematica_turma (
                escola_id, serie_id, turma_id, ano_letivo, bimestre,
                total_alunos, necessidades_especiais,
                le_registra_numeros, interpreta_quantidades, compara_estabelece_relacoes,
                realiza_adicao, realiza_subtracao, realiza_multiplicacao, realiza_divisao,
                resolve_problemas_simples, resolve_problemas_complexos
            ) VALUES (?,?,?,?,?, ?,?, ?,?,?, ?,?,?,?, ?,?)');
            $ins->execute(array(
                $escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post,
                $total_alunos, $necessidades_especiais,
                $le_registra_numeros, $interpreta_quantidades, $compara_estabelece_relacoes,
                $realiza_adicao, $realiza_subtracao, $realiza_multiplicacao, $realiza_divisao,
                $resolve_problemas_simples, $resolve_problemas_complexos
            ));
            $msg_ok = 'Condensado salvo com sucesso!';
        }
        // Reload data
        $st = $pdo->prepare('SELECT * FROM condensado_matematica_turma WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
        $st->execute(array($escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $dados_existentes = $st->fetch();

        $escola_id = $escola_id_post;
        $serie_id = $serie_id_post;
        $turma_id = $turma_id_post;
        $ano_letivo = $ano_letivo_post;
    } else {
        $msg_err = 'Selecione Escola, Série e Turma antes de salvar.';
    }
}

// Buscar nome da escola/série/turma para exibição
$escola_nome = '';
$serie_nome = '';
$turma_nome = '';
if ($escola_id) {
    $st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
    $st->execute(array($escola_id));
    $r = $st->fetch();
    if ($r) $escola_nome = $r['nome'];
}
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute(array($serie_id));
    $r = $st->fetch();
    if ($r) $serie_nome = $r['nome_serie'];
}
if ($turma_id) {
    $st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
    $st->execute(array($turma_id));
    $r = $st->fetch();
    if ($r) $turma_nome = $r['nome_turma'];
}

?>

<div class="max-w-full">
    <div class="bg-white shadow rounded-lg mb-6">
        <div class="bg-gradient-to-r from-green-600 to-green-800 px-6 py-4 border-b border-gray-200">
            <h1 class="text-2xl font-bold text-white">
                <i class="fas fa-calculator mr-3"></i>
                CONDENSADO GERAL MATEMÁTICA ANOS INICIAIS 1º AO 5º ANO
            </h1>
            <p class="text-green-100 mt-1">Selecione a Escola, Série e Turma, depois insira os dados agregados da turma.</p>
        </div>

        <div class="p-6">
            <?php if ($msg_ok): ?><div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?php echo $msg_ok; ?></div><?php endif; ?>
            <?php if ($msg_err): ?><div class="mb-4 p-3 bg-red-100 text-red-700 rounded"><?php echo $msg_err; ?></div><?php endif; ?>

            <!-- Filtros -->
            <div class="bg-gradient-to-r from-green-50 to-emerald-50 border-2 border-green-200 rounded-lg p-6 mb-6">
                <h3 class="text-lg font-bold text-green-800 mb-4">
                    <i class="fas fa-filter mr-2"></i>Seleção de Turma
                </h3>
                <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                    <input type="hidden" name="page" value="condensado_matematica_iniciais">
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-school mr-1 text-green-600"></i>Escola
                        </label>
                        <select name="escola" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($escolas as $esc): ?>
                            <option value="<?php echo $esc['id']; ?>" <?php echo $escola_id == $esc['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($esc['nome']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-layer-group mr-1 text-green-600"></i>Série
                        </label>
                        <select name="serie" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($series_db as $s): ?>
                            <option value="<?php echo $s['id']; ?>" <?php echo $serie_id == $s['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($s['nome_serie']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-users mr-1 text-green-600"></i>Turma
                        </label>
                        <select name="turma" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($turmas_db as $t): ?>
                            <option value="<?php echo $t['id']; ?>" <?php echo $turma_id == $t['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($t['nome_turma']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-check mr-1 text-green-600"></i>Bimestre
                        </label>
                        <select name="bimestre" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <option value="1" <?php echo $bimestre == 1 ? 'selected' : ''; ?>>1º Bimestre</option>
                            <option value="2" <?php echo $bimestre == 2 ? 'selected' : ''; ?>>2º Bimestre</option>
                            <option value="3" <?php echo $bimestre == 3 ? 'selected' : ''; ?>>3º Bimestre</option>
                            <option value="4" <?php echo $bimestre == 4 ? 'selected' : ''; ?>>4º Bimestre</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-alt mr-1 text-green-600"></i>Ano Letivo
                        </label>
                        <select name="ano_letivo" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500 bg-white" onchange="this.form.submit()">
                            <?php for ($a = date('Y'); $a >= 2020; $a--): ?>
                            <option value="<?php echo $a; ?>" <?php echo $ano_letivo == $a ? 'selected' : ''; ?>><?php echo $a; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button type="submit" class="w-full bg-green-600 text-white px-4 py-3 rounded-md font-semibold hover:bg-green-700 shadow-md hover:shadow-lg transition-all">
                            <i class="fas fa-filter mr-2"></i>Filtrar
                        </button>
                    </div>
                </form>
            </div>

            <?php if ($escola_id && $serie_id && $turma_id && $bimestre && $ano_letivo): ?>
            <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6">
                <p class="font-semibold">Turma Selecionada: <?php echo htmlspecialchars($escola_nome . ' > ' . $serie_nome . ' > Turma ' . $turma_nome); ?></p>
                <p class="text-sm">Bimestre: <?php echo $bimestre; ?>º | Ano Letivo: <?php echo $ano_letivo; ?></p>
            </div>

            <!-- Formulário de Entrada -->
            <form method="POST" class="space-y-6">
                <input type="hidden" name="action" value="save_condensado_matematica">
                <input type="hidden" name="escola_id" value="<?php echo $escola_id; ?>">
                <input type="hidden" name="serie_id" value="<?php echo $serie_id; ?>">
                <input type="hidden" name="turma_id" value="<?php echo $turma_id; ?>">
                <input type="hidden" name="ano_letivo" value="<?php echo $ano_letivo; ?>">
                <input type="hidden" name="bimestre" value="<?php echo $bimestre; ?>">

                <!-- Campos Gerais -->
                <div class="bg-green-50 border-2 border-green-300 shadow rounded-lg p-6 mb-6">
                    <h3 class="text-lg font-bold mb-4 text-green-700">Informações Gerais</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Número Total de Alunos</label>
                            <input type="number" name="total_alunos" value="<?php echo $dados_existentes['total_alunos'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Alunos com Necessidades Especiais</label>
                            <input type="number" name="necessidades_especiais" value="<?php echo $dados_existentes['necessidades_especiais'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-green-500 focus:border-green-500">
                        </div>
                    </div>
                </div>

                <!-- Tabela de Habilidades e Noções -->
                <div class="overflow-x-auto">
                    <table class="w-full border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-green-600 text-white">
                                <th colspan="3" class="border border-gray-300 px-4 py-3 text-center font-bold text-lg">HABILIDADES NUMÉRICAS E OPERATÓRIAS</th>
                                <th colspan="4" class="border border-gray-300 px-4 py-3 text-center font-bold text-lg">REALIZA CÁLCULOS</th>
                                <th colspan="2" class="border border-gray-300 px-4 py-3 text-center font-bold text-lg">NOÇÕES</th>
                            </tr>
                            <tr class="bg-gray-100">
                                <!-- Habilidades Numéricas Headers -->
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">LÊ E REGISTRA NÚMEROS</th>
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">INTERPRETA QUANTIDADES/VALORES</th>
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">COMPARA E ESTABELECE RELAÇÕES</th>
                                
                                <!-- Realiza Cálculos Headers -->
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">ADIÇÃO</th>
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">SUBTRAÇÃO</th>
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">MULTIPLICAÇÃO</th>
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">DIVISÃO</th>
                                
                                <!-- Noções Headers -->
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">RESOLVE SITUAÇÕES PROBLEMAS SIMPLES</th>
                                <th class="border border-gray-300 px-2 py-2 text-xs font-semibold text-center">RESOLVE SITUAÇÕES PROBLEMAS COMPLEXAS</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <!-- Habilidades Numéricas Inputs -->
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="le_registra_numeros" value="<?php echo $dados_existentes['le_registra_numeros'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="interpreta_quantidades" value="<?php echo $dados_existentes['interpreta_quantidades'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="compara_estabelece_relacoes" value="<?php echo $dados_existentes['compara_estabelece_relacoes'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                
                                <!-- Realiza Cálculos Inputs -->
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="realiza_adicao" value="<?php echo $dados_existentes['realiza_adicao'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="realiza_subtracao" value="<?php echo $dados_existentes['realiza_subtracao'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="realiza_multiplicacao" value="<?php echo $dados_existentes['realiza_multiplicacao'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="realiza_divisao" value="<?php echo $dados_existentes['realiza_divisao'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                
                                <!-- Noções Inputs -->
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="resolve_problemas_simples" value="<?php echo $dados_existentes['resolve_problemas_simples'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                                <td class="border border-gray-300 p-1">
                                    <input type="number" name="resolve_problemas_complexos" value="<?php echo $dados_existentes['resolve_problemas_complexos'] ?? 0; ?>" min="0" class="w-full border-gray-300 rounded text-center p-2">
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 text-lg font-semibold">
                        <i class="fas fa-save mr-2"></i>Salvar Condensado
                    </button>
                </div>
            </form>
            <?php else: ?>
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 text-gray-700">
                    <p class="text-center">Selecione Escola, Série e Turma acima para cadastrar o condensado.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
