<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Tabela condensados de redação (6º ao 9º ano)
$pdo->exec("CREATE TABLE IF NOT EXISTS condensado_redacao_finais (
    id INT AUTO_INCREMENT PRIMARY KEY,
    escola_id INT NOT NULL,
    serie_id INT NOT NULL,
    turma_id INT NOT NULL,
    ano_letivo INT NOT NULL,
    bimestre INT DEFAULT 1,
    
    total_alunos INT DEFAULT 0,
    alunos_necessidades_especiais INT DEFAULT 0,
    
    fluencia_compreensao INT DEFAULT 0,
    fluencia_interpretacao INT DEFAULT 0,
    fluencia_oralidade INT DEFAULT 0,
    
    producao_ortografia INT DEFAULT 0,
    producao_pontuacao INT DEFAULT 0,
    producao_concordancia INT DEFAULT 0,
    
    textual_coesao INT DEFAULT 0,
    textual_coerencia INT DEFAULT 0,
    textual_genero_tema INT DEFAULT 0,
    textual_segmentacao INT DEFAULT 0,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_turma_ano (escola_id, serie_id, turma_id, ano_letivo, bimestre)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

$escolas = $pdo->query('SELECT * FROM escolas ORDER BY nome')->fetchAll();

$msg_ok = '';
$msg_err = '';

// Capturar filtros
$escola_id = isset($_GET['escola']) ? (int)$_GET['escola'] : 0;
$serie_id = isset($_GET['serie']) ? (int)$_GET['serie'] : 0;
$turma_id = isset($_GET['turma']) ? (int)$_GET['turma'] : 0;
$ano_letivo = isset($_GET['ano_letivo']) ? (int)$_GET['ano_letivo'] : (int)date('Y');
$bimestre = isset($_GET['bimestre']) ? (int)$_GET['bimestre'] : 1;

// Buscar séries dinamicamente (apenas 6º ao 9º Ano)
$series_db = array();
if ($escola_id) {
    $st = $pdo->prepare("SELECT id, nome_serie FROM escola_series WHERE escola_id = ? AND (
        nome_serie LIKE '%6º ANO%' OR nome_serie LIKE '%6° ANO%' OR nome_serie LIKE '%6ª SÉRIE%' OR nome_serie LIKE '%6° SÉRIE%' OR
        nome_serie LIKE '%7º ANO%' OR nome_serie LIKE '%7° ANO%' OR nome_serie LIKE '%7ª SÉRIE%' OR nome_serie LIKE '%7° SÉRIE%' OR
        nome_serie LIKE '%8º ANO%' OR nome_serie LIKE '%8° ANO%' OR nome_serie LIKE '%8ª SÉRIE%' OR nome_serie LIKE '%8° SÉRIE%' OR
        nome_serie LIKE '%9º ANO%' OR nome_serie LIKE '%9° ANO%' OR nome_serie LIKE '%9ª SÉRIE%' OR nome_serie LIKE '%9° SÉRIE%'
    ) ORDER BY nome_serie");
    $st->execute(array($escola_id));
    $series_db = $st->fetchAll();
}

// Buscar turmas dinamicamente
$turmas_db = array();
if ($escola_id && $serie_id) {
    $st = $pdo->prepare('SELECT id, nome_turma FROM turmas WHERE escola_id = ? AND serie_id = ? ORDER BY nome_turma');
    $st->execute(array($escola_id, $serie_id));
    $turmas_db = $st->fetchAll();
}

// Carregar dados existentes
$dados_existentes = null;
if ($escola_id && $serie_id && $turma_id) {
    $st = $pdo->prepare('SELECT * FROM condensado_redacao_finais WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
    $st->execute(array($escola_id, $serie_id, $turma_id, $ano_letivo, $bimestre));
    $dados_existentes = $st->fetch();
}

// Salvar / Atualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save_condensado_redacao_finais') {
    $escola_id_post = (int)($_POST['escola_id'] ?? 0);
    $serie_id_post = (int)($_POST['serie_id'] ?? 0);
    $turma_id_post = (int)($_POST['turma_id'] ?? 0);
    $ano_letivo_post = (int)($_POST['ano_letivo'] ?? date('Y'));
    $bimestre_post = (int)($_POST['bimestre'] ?? 1);

    $total_alunos = (int)($_POST['total_alunos'] ?? 0);
    $alunos_necessidades_especiais = (int)($_POST['alunos_necessidades_especiais'] ?? 0);

    $fluencia_compreensao = (int)($_POST['fluencia_compreensao'] ?? 0);
    $fluencia_interpretacao = (int)($_POST['fluencia_interpretacao'] ?? 0);
    $fluencia_oralidade = (int)($_POST['fluencia_oralidade'] ?? 0);

    $producao_ortografia = (int)($_POST['producao_ortografia'] ?? 0);
    $producao_pontuacao = (int)($_POST['producao_pontuacao'] ?? 0);
    $producao_concordancia = (int)($_POST['producao_concordancia'] ?? 0);

    $textual_coesao = (int)($_POST['textual_coesao'] ?? 0);
    $textual_coerencia = (int)($_POST['textual_coerencia'] ?? 0);
    $textual_genero_tema = (int)($_POST['textual_genero_tema'] ?? 0);
    $textual_segmentacao = (int)($_POST['textual_segmentacao'] ?? 0);

    if ($escola_id_post && $serie_id_post && $turma_id_post) {
        // Verificar se já existe
        $st = $pdo->prepare('SELECT id FROM condensado_redacao_finais WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
        $st->execute(array($escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $existente = $st->fetch();

        if ($existente) {
            // Update
            $upd = $pdo->prepare('UPDATE condensado_redacao_finais SET 
                total_alunos=?, alunos_necessidades_especiais=?,
                fluencia_compreensao=?, fluencia_interpretacao=?, fluencia_oralidade=?,
                producao_ortografia=?, producao_pontuacao=?, producao_concordancia=?,
                textual_coesao=?, textual_coerencia=?, textual_genero_tema=?, textual_segmentacao=?
                WHERE id = ?');
            $upd->execute(array(
                $total_alunos, $alunos_necessidades_especiais,
                $fluencia_compreensao, $fluencia_interpretacao, $fluencia_oralidade,
                $producao_ortografia, $producao_pontuacao, $producao_concordancia,
                $textual_coesao, $textual_coerencia, $textual_genero_tema, $textual_segmentacao,
                $existente['id']
            ));
            $msg_ok = 'Condensado atualizado com sucesso!';
        } else {
            // Insert
            $ins = $pdo->prepare('INSERT INTO condensado_redacao_finais (
                escola_id, serie_id, turma_id, ano_letivo, bimestre, total_alunos, alunos_necessidades_especiais,
                fluencia_compreensao, fluencia_interpretacao, fluencia_oralidade,
                producao_ortografia, producao_pontuacao, producao_concordancia,
                textual_coesao, textual_coerencia, textual_genero_tema, textual_segmentacao
            ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
            $ins->execute(array(
                $escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post, $total_alunos, $alunos_necessidades_especiais,
                $fluencia_compreensao, $fluencia_interpretacao, $fluencia_oralidade,
                $producao_ortografia, $producao_pontuacao, $producao_concordancia,
                $textual_coesao, $textual_coerencia, $textual_genero_tema, $textual_segmentacao
            ));
            $msg_ok = 'Condensado salvo com sucesso!';
        }

        // Reload
        $st = $pdo->prepare('SELECT * FROM condensado_redacao_finais WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?');
        $st->execute(array($escola_id_post, $serie_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $dados_existentes = $st->fetch();

        $escola_id = $escola_id_post;
        $serie_id = $serie_id_post;
        $turma_id = $turma_id_post;
        $ano_letivo = $ano_letivo_post;
    } else {
        $msg_err = 'Selecione Escola, Série e Turma antes de salvar.';
    }
}

// Buscar nomes para exibição
$escola_nome = '';
$serie_nome = '';
$turma_nome = '';
if ($escola_id) {
    $st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
    $st->execute(array($escola_id));
    $esc = $st->fetch();
    if ($esc) $escola_nome = $esc['nome'];
}
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute(array($serie_id));
    $s = $st->fetch();
    if ($s) $serie_nome = $s['nome_serie'];
}
if ($turma_id) {
    $st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
    $st->execute(array($turma_id));
    $t = $st->fetch();
    if ($t) $turma_nome = $t['nome_turma'];
}
?>

<div class="max-w-full">
    <div class="bg-white rounded-lg shadow-md">
        <div class="bg-gradient-to-r from-indigo-600 to-indigo-800 text-white px-6 py-4 ">
            <h2 class="text-2xl font-bold flex items-center">
                <i class="fas fa-pen-fancy mr-3"></i>
                Condensado Geral de Redação - 6º ao 9º Ano
            </h2>
            <p class="text-blue-100 mt-1">Selecione a Escola, Série e Turma, depois insira os dados agregados da turma.</p>
        </div>

        <div class="p-6">
            <?php if ($msg_ok): ?><div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?php echo $msg_ok; ?></div><?php endif; ?>
            <?php if ($msg_err): ?><div class="mb-4 p-3 bg-red-100 text-red-700 rounded"><?php echo $msg_err; ?></div><?php endif; ?>

            <!-- Filtros -->
            <div class="bg-gradient-to-r from-indigo-50 to-purple-50 border-2 border-indigo-200 rounded-lg p-6 mb-6">
                <h3 class="text-lg font-bold text-indigo-800 mb-4">
                    <i class="fas fa-filter mr-2"></i>Seleção de Turma
                </h3>
                <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                    <input type="hidden" name="page" value="condensado_redacao_finais">
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-school mr-1 text-indigo-600"></i>Escola
                        </label>
                        <select name="escola" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($escolas as $esc): ?>
                            <option value="<?php echo $esc['id']; ?>" <?php echo $escola_id == $esc['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($esc['nome']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-layer-group mr-1 text-indigo-600"></i>Série (6º-9º Ano)
                        </label>
                        <select name="serie" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($series_db as $s): ?>
                            <option value="<?php echo $s['id']; ?>" <?php echo $serie_id == $s['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($s['nome_serie']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-users mr-1 text-indigo-600"></i>Turma
                        </label>
                        <select name="turma" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($turmas_db as $t): ?>
                            <option value="<?php echo $t['id']; ?>" <?php echo $turma_id == $t['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($t['nome_turma']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-check mr-1 text-indigo-600"></i>Bimestre
                        </label>
                        <select name="bimestre" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 bg-white" onchange="this.form.submit()">
                            <option value="1" <?php echo $bimestre == 1 ? 'selected' : ''; ?>>1º Bimestre</option>
                            <option value="2" <?php echo $bimestre == 2 ? 'selected' : ''; ?>>2º Bimestre</option>
                            <option value="3" <?php echo $bimestre == 3 ? 'selected' : ''; ?>>3º Bimestre</option>
                            <option value="4" <?php echo $bimestre == 4 ? 'selected' : ''; ?>>4º Bimestre</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-alt mr-1 text-indigo-600"></i>Ano Letivo
                        </label>
                        <select name="ano_letivo" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 bg-white" onchange="this.form.submit()">
                            <?php for ($a = date('Y'); $a >= 2020; $a--): ?>
                            <option value="<?php echo $a; ?>" <?php echo $ano_letivo == $a ? 'selected' : ''; ?>><?php echo $a; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button type="submit" class="w-full bg-indigo-600 text-white px-4 py-3 rounded-md font-semibold hover:bg-indigo-700 shadow-md hover:shadow-lg transition-all">
                            <i class="fas fa-filter mr-2"></i>Filtrar
                        </button>
                    </div>
                </form>
            </div>

            <?php if ($escola_id && $serie_id && $turma_id && $bimestre && $ano_letivo): ?>
            <div class="bg-indigo-50 border-l-4 border-indigo-500 p-4 mb-6">
                <p class="font-semibold">Turma Selecionada: <?php echo htmlspecialchars($escola_nome . ' > ' . $serie_nome . ' > Turma ' . $turma_nome); ?></p>
                <p class="text-sm">Bimestre: <?php echo $bimestre; ?>º | Ano Letivo: <?php echo $ano_letivo; ?></p>
            </div>

            <!-- Formulário -->
            <form method="POST" class="space-y-6">
                <input type="hidden" name="action" value="save_condensado_redacao_finais">
                <input type="hidden" name="escola_id" value="<?php echo $escola_id; ?>">
                <input type="hidden" name="serie_id" value="<?php echo $serie_id; ?>">
                <input type="hidden" name="turma_id" value="<?php echo $turma_id; ?>">
                <input type="hidden" name="ano_letivo" value="<?php echo $ano_letivo; ?>">
                <input type="hidden" name="bimestre" value="<?php echo $bimestre; ?>">

                <!-- Campos Gerais -->
                <div class="bg-indigo-50 border-2 border-indigo-300 shadow rounded-lg p-6">
                    <h3 class="text-lg font-bold mb-4 text-indigo-700">Informações Gerais</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Número Total de Alunos</label>
                            <input type="number" name="total_alunos" value="<?php echo $dados_existentes['total_alunos'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Alunos com Necessidades Especiais</label>
                            <input type="number" name="alunos_necessidades_especiais" value="<?php echo $dados_existentes['alunos_necessidades_especiais'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                        </div>
                    </div>
                </div>

                <!-- Tabela Horizontal -->
                <div class="bg-white shadow rounded-lg p-6 overflow-x-auto">
                    <h3 class="text-lg font-bold mb-4 text-indigo-700">Redação - Total por Turma</h3>
                    <table class="w-full border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-indigo-600 text-white">
                                <th colspan="3" class="border border-gray-300 px-4 py-3 text-center font-bold">FLUÊNCIA NA LEITURA</th>
                                <th colspan="3" class="border border-gray-300 px-4 py-3 text-center font-bold">PRODUÇÃO ESCRITA</th>
                                <th colspan="4" class="border border-gray-300 px-4 py-3 text-center font-bold">PRODUÇÃO TEXTUAL</th>
                            </tr>
                            <tr class="bg-gray-100 text-xs">
                                <th class="border border-gray-300 px-2 py-2">Compreensão</th>
                                <th class="border border-gray-300 px-2 py-2">Interpretação</th>
                                <th class="border border-gray-300 px-2 py-2">Oralidade (expressividade e acentuação gráfica)</th>
                                <th class="border border-gray-300 px-2 py-2">Ortografia</th>
                                <th class="border border-gray-300 px-2 py-2">Pontuação</th>
                                <th class="border border-gray-300 px-2 py-2">Concordância</th>
                                <th class="border border-gray-300 px-2 py-2">Coesão</th>
                                <th class="border border-gray-300 px-2 py-2">Coerência</th>
                                <th class="border border-gray-300 px-2 py-2">Considera o Gênero e o Tema Proposto</th>
                                <th class="border border-gray-300 px-2 py-2">Segmentação em Parágrafo</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 p-1"><input type="number" name="fluencia_compreensao" value="<?php echo $dados_existentes['fluencia_compreensao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="fluencia_interpretacao" value="<?php echo $dados_existentes['fluencia_interpretacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="fluencia_oralidade" value="<?php echo $dados_existentes['fluencia_oralidade'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="producao_ortografia" value="<?php echo $dados_existentes['producao_ortografia'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="producao_pontuacao" value="<?php echo $dados_existentes['producao_pontuacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="producao_concordancia" value="<?php echo $dados_existentes['producao_concordancia'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="textual_coesao" value="<?php echo $dados_existentes['textual_coesao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="textual_coerencia" value="<?php echo $dados_existentes['textual_coerencia'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="textual_genero_tema" value="<?php echo $dados_existentes['textual_genero_tema'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="textual_segmentacao" value="<?php echo $dados_existentes['textual_segmentacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="bg-indigo-600 text-white px-6 py-3 rounded-lg hover:bg-indigo-700 text-lg font-semibold">
                        <i class="fas fa-save mr-2"></i>Salvar Condensado
                    </button>
                </div>
            </form>
            <?php else: ?>
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 text-gray-700">
                    <p class="text-center">Selecione Escola, Série e Turma acima para cadastrar o condensado.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
