<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Tabela condensados supervisor - Maternal
$pdo->exec("CREATE TABLE IF NOT EXISTS condensado_supervisor_maternal (
    id INT AUTO_INCREMENT PRIMARY KEY,
    escola_id INT NOT NULL,
    turma_id INT NOT NULL,
    ano_letivo INT NOT NULL,
    bimestre INT DEFAULT 1,
    
    total_alunos INT DEFAULT 0,
    alunos_com_laudo INT DEFAULT 0,
    
    realiza_pseudoleitura INT DEFAULT 0,
    relata_experiencias INT DEFAULT 0,
    relata_historias_ouvidas INT DEFAULT 0,
    representa_historias_pictoricas INT DEFAULT 0,
    diferencia_letra_desenho INT DEFAULT 0,
    manuseia_instrumentos_escrita INT DEFAULT 0,
    identifica_10_letras INT DEFAULT 0,
    escreve_primeiro_nome INT DEFAULT 0,
    reconhece_formas_geometricas INT DEFAULT 0,
    contagem_ate_10 INT DEFAULT 0,
    representa_quantidades_ate_3 INT DEFAULT 0,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_turma_ano (escola_id, turma_id, ano_letivo, bimestre)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Tabela condensados supervisor - 1º Período
$pdo->exec("CREATE TABLE IF NOT EXISTS condensado_supervisor_1periodo (
    id INT AUTO_INCREMENT PRIMARY KEY,
    escola_id INT NOT NULL,
    turma_id INT NOT NULL,
    ano_letivo INT NOT NULL,
    bimestre INT DEFAULT 1,
    
    total_alunos INT DEFAULT 0,
    alunos_com_laudo INT DEFAULT 0,
    
    realiza_pseudoleitura INT DEFAULT 0,
    reconta_historias INT DEFAULT 0,
    reconhece_ideia_principal INT DEFAULT 0,
    le_textos_nao_verbais INT DEFAULT 0,
    conta_historias INT DEFAULT 0,
    reconhece_dois_generos INT DEFAULT 0,
    diferencia_letras_numeros INT DEFAULT 0,
    nomeia_letras_alfabeto INT DEFAULT 0,
    reconhece_palavras_mesmo_som INT DEFAULT 0,
    realiza_copia_textos INT DEFAULT 0,
    escreve_nome_completo_ficha INT DEFAULT 0,
    escrita_nivel_silabico INT DEFAULT 0,
    reconhece_formas_geometricas INT DEFAULT 0,
    classificacao_tres_criterios INT DEFAULT 0,
    realiza_seriacao INT DEFAULT 0,
    contagem_oral_ate_20 INT DEFAULT 0,
    registra_sequencia_ate_10 INT DEFAULT 0,
    representa_quantidades_ate_10 INT DEFAULT 0,
    resolve_problemas_concretos INT DEFAULT 0,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_turma_ano (escola_id, turma_id, ano_letivo, bimestre)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Tabela condensados supervisor - 2º Período
$pdo->exec("CREATE TABLE IF NOT EXISTS condensado_supervisor_2periodo (
    id INT AUTO_INCREMENT PRIMARY KEY,
    escola_id INT NOT NULL,
    turma_id INT NOT NULL,
    ano_letivo INT NOT NULL,
    bimestre INT DEFAULT 1,
    
    total_alunos INT DEFAULT 0,
    alunos_com_laudo INT DEFAULT 0,
    
    reconta_historias_completas INT DEFAULT 0,
    produz_textos_escriba INT DEFAULT 0,
    reconhece_tres_generos INT DEFAULT 0,
    reconhece_ideia_principal INT DEFAULT 0,
    le_textos_nao_verbais INT DEFAULT 0,
    nomeia_letras_alfabeto INT DEFAULT 0,
    diferencia_letras_numeros INT DEFAULT 0,
    escreve_alfabeto_sem_copia INT DEFAULT 0,
    escreve_nome_sem_ficha INT DEFAULT 0,
    escrita_silabico_alfabetico INT DEFAULT 0,
    reconhece_palavras_mesmo_som INT DEFAULT 0,
    realiza_copia_textos INT DEFAULT 0,
    utiliza_conservacao INT DEFAULT 0,
    utiliza_seriacao INT DEFAULT 0,
    utiliza_classificacao INT DEFAULT 0,
    registra_sequencia_ate_20 INT DEFAULT 0,
    contagem_oral_ate_30 INT DEFAULT 0,
    identifica_antes_depois_entre INT DEFAULT 0,
    representa_quantidades_ate_20 INT DEFAULT 0,
    resolve_problemas_adicao INT DEFAULT 0,
    resolve_problemas_subtracao INT DEFAULT 0,
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY uniq_turma_ano (escola_id, turma_id, ano_letivo, bimestre)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

$escolas = $pdo->query('SELECT * FROM escolas ORDER BY nome')->fetchAll();

$msg_ok = '';
$msg_err = '';

// Capturar filtros
$escola_id = isset($_GET['escola']) ? (int)$_GET['escola'] : 0;
$serie_id = isset($_GET['serie']) ? (int)$_GET['serie'] : 0;
$turma_id = isset($_GET['turma']) ? (int)$_GET['turma'] : 0;
$ano_letivo = isset($_GET['ano_letivo']) ? (int)$_GET['ano_letivo'] : (int)date('Y');
$bimestre = isset($_GET['bimestre']) ? (int)$_GET['bimestre'] : 1;

// Buscar séries dinamicamente (apenas Maternal, 1º e 2º Período)
$series_db = array();
if ($escola_id) {
    $st = $pdo->prepare("SELECT * FROM escola_series WHERE escola_id = ? AND (nome_serie LIKE '%Maternal%' OR nome_serie LIKE '%1º Período%' OR nome_serie LIKE '%1° Período%' OR nome_serie LIKE '%2º Período%' OR nome_serie LIKE '%2° Período%') ORDER BY nome_serie");
    $st->execute(array($escola_id));
    $series_db = $st->fetchAll();
}

// Buscar turmas dinamicamente
$turmas_db = array();
if ($escola_id && $serie_id) {
    $st = $pdo->prepare('SELECT * FROM turmas WHERE escola_id = ? AND serie_id = ? ORDER BY nome_turma');
    $st->execute(array($escola_id, $serie_id));
    $turmas_db = $st->fetchAll();
}

// Determinar período_tipo baseado na série selecionada
$periodo_tipo = 'maternal';
$serie_nome = '';
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute(array($serie_id));
    $s = $st->fetch();
    if ($s) {
        $serie_nome = $s['nome_serie'];
        $serie_upper = strtoupper($serie_nome);
        
        if (strpos($serie_upper, 'MATERNAL') !== false) {
            $periodo_tipo = 'maternal';
        } elseif (strpos($serie_upper, 'PERÍODO') !== false || strpos($serie_upper, 'PERIODO') !== false) {
            // Detectar se é 1º ou 2º Período
            if (strpos($serie_upper, '1') !== false) {
                $periodo_tipo = '1periodo';
            } elseif (strpos($serie_upper, '2') !== false) {
                $periodo_tipo = '2periodo';
            }
        }
    }
}

// Carregar dados existentes
$dados_existentes = null;
if ($escola_id && $serie_id && $turma_id) {
    $tabela = '';
    if ($periodo_tipo === 'maternal') $tabela = 'condensado_supervisor_maternal';
    elseif ($periodo_tipo === '1periodo') $tabela = 'condensado_supervisor_1periodo';
    elseif ($periodo_tipo === '2periodo') $tabela = 'condensado_supervisor_2periodo';
    
    if ($tabela) {
        $st = $pdo->prepare("SELECT * FROM $tabela WHERE escola_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?");
        $st->execute(array($escola_id, $turma_id, $ano_letivo, $bimestre));
        $dados_existentes = $st->fetch();
    }
}

// Salvar / Atualizar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'save_condensado_supervisor') {
    $periodo_tipo_post = trim($_POST['periodo_tipo'] ?? 'maternal');
    $escola_id_post = (int)($_POST['escola_id'] ?? 0);
    $serie_id_post = (int)($_POST['serie_id'] ?? 0);
    $turma_id_post = (int)($_POST['turma_id'] ?? 0);
    $ano_letivo_post = (int)($_POST['ano_letivo'] ?? date('Y'));
    $bimestre_post = (int)($_POST['bimestre'] ?? 1);

    $total_alunos = (int)($_POST['total_alunos'] ?? 0);
    $alunos_com_laudo = (int)($_POST['alunos_com_laudo'] ?? 0);

    if ($escola_id_post && $serie_id_post && $turma_id_post) {
        $tabela = '';
        $campos = array();
        $valores = array($total_alunos, $alunos_com_laudo);
        
        if ($periodo_tipo_post === 'maternal') {
            $tabela = 'condensado_supervisor_maternal';
            $campos = array('realiza_pseudoleitura', 'relata_experiencias', 'relata_historias_ouvidas', 'representa_historias_pictoricas', 
                          'diferencia_letra_desenho', 'manuseia_instrumentos_escrita', 'identifica_10_letras', 'escreve_primeiro_nome',
                          'reconhece_formas_geometricas', 'contagem_ate_10', 'representa_quantidades_ate_3');
        } elseif ($periodo_tipo_post === '1periodo') {
            $tabela = 'condensado_supervisor_1periodo';
            $campos = array('realiza_pseudoleitura', 'reconta_historias', 'reconhece_ideia_principal', 'le_textos_nao_verbais',
                          'conta_historias', 'reconhece_dois_generos', 'diferencia_letras_numeros', 'nomeia_letras_alfabeto',
                          'reconhece_palavras_mesmo_som', 'realiza_copia_textos', 'escreve_nome_completo_ficha', 'escrita_nivel_silabico',
                          'reconhece_formas_geometricas', 'classificacao_tres_criterios', 'realiza_seriacao', 'contagem_oral_ate_20',
                          'registra_sequencia_ate_10', 'representa_quantidades_ate_10', 'resolve_problemas_concretos');
        } elseif ($periodo_tipo_post === '2periodo') {
            $tabela = 'condensado_supervisor_2periodo';
            $campos = array('reconta_historias_completas', 'produz_textos_escriba', 'reconhece_tres_generos', 'reconhece_ideia_principal',
                          'le_textos_nao_verbais', 'nomeia_letras_alfabeto', 'diferencia_letras_numeros', 'escreve_alfabeto_sem_copia',
                          'escreve_nome_sem_ficha', 'escrita_silabico_alfabetico', 'reconhece_palavras_mesmo_som', 'realiza_copia_textos',
                          'utiliza_conservacao', 'utiliza_seriacao', 'utiliza_classificacao', 'registra_sequencia_ate_20',
                          'contagem_oral_ate_30', 'identifica_antes_depois_entre', 'representa_quantidades_ate_20',
                          'resolve_problemas_adicao', 'resolve_problemas_subtracao');
        }
        
        foreach ($campos as $campo) {
            $valores[] = (int)($_POST[$campo] ?? 0);
        }
        
        // Verificar se já existe
        $st = $pdo->prepare("SELECT id FROM $tabela WHERE escola_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?");
        $st->execute(array($escola_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $existente = $st->fetch();

        if ($existente) {
            // Update
            $set_campos = 'total_alunos=?, alunos_com_laudo=?';
            foreach ($campos as $campo) {
                $set_campos .= ", $campo=?";
            }
            $valores[] = $existente['id'];
            
            $upd = $pdo->prepare("UPDATE $tabela SET $set_campos WHERE id = ?");
            $upd->execute($valores);
            $msg_ok = 'Condensado atualizado com sucesso!';
        } else {
            // Insert
            $campos_str = 'escola_id, turma_id, ano_letivo, bimestre, total_alunos, alunos_com_laudo';
            foreach ($campos as $campo) {
                $campos_str .= ", $campo";
            }
            
            $placeholders = '?,?,?,?';
            for ($i = 0; $i < count($valores); $i++) {
                $placeholders .= ',?';
            }
            
            array_unshift($valores, $escola_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post);
            
            $ins = $pdo->prepare("INSERT INTO $tabela ($campos_str) VALUES ($placeholders)");
            $ins->execute($valores);
            $msg_ok = 'Condensado salvo com sucesso!';
        }
        
        // Reload data
        $st = $pdo->prepare("SELECT * FROM $tabela WHERE escola_id = ? AND turma_id = ? AND ano_letivo = ? AND bimestre = ?");
        $st->execute(array($escola_id_post, $turma_id_post, $ano_letivo_post, $bimestre_post));
        $dados_existentes = $st->fetch();

        $periodo_tipo = $periodo_tipo_post;
        $escola_id = $escola_id_post;
        $serie_id = $serie_id_post;
        $turma_id = $turma_id_post;
        $ano_letivo = $ano_letivo_post;
        
        // Recarregar série nome
        $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
        $st->execute(array($serie_id));
        $s = $st->fetch();
        if ($s) $serie_nome = $s['nome_serie'];
        
        // Recarregar séries e turmas
        $st = $pdo->prepare("SELECT * FROM escola_series WHERE escola_id = ? AND (nome_serie LIKE '%Maternal%' OR nome_serie LIKE '%1º Período%' OR nome_serie LIKE '%1° Período%' OR nome_serie LIKE '%2º Período%' OR nome_serie LIKE '%2° Período%') ORDER BY nome_serie");
        $st->execute(array($escola_id));
        $series_db = $st->fetchAll();
        
        $st = $pdo->prepare('SELECT * FROM turmas WHERE escola_id = ? AND serie_id = ? ORDER BY nome_turma');
        $st->execute(array($escola_id, $serie_id));
        $turmas_db = $st->fetchAll();
    } else {
        $msg_err = 'Selecione Escola, Série e Turma antes de salvar.';
    }
}

// Buscar nome da escola/série/turma para exibição
$escola_nome = '';
$turma_nome = '';
if ($escola_id) {
    $st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
    $st->execute(array($escola_id));
    $esc = $st->fetch();
    if ($esc) $escola_nome = $esc['nome'];
}
if ($serie_id && !$serie_nome) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute(array($serie_id));
    $s = $st->fetch();
    if ($s) $serie_nome = $s['nome_serie'];
}
if ($turma_id) {
    $st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
    $st->execute(array($turma_id));
    $t = $st->fetch();
    if ($t) $turma_nome = $t['nome_turma'];
}
?>

<div class="max-w-full">
    <div class="bg-white rounded-lg shadow-md">
        <div class="bg-gradient-to-r from-purple-600 to-purple-800 text-white px-6 py-4 ">
            <h2 class="text-2xl font-bold flex items-center">
                <i class="fas fa-clipboard-check mr-3"></i>
                Supervisor: Monitoramento da Aprendizagem - Condensado
            </h2>
            <p class="text-blue-100 mt-1">Selecione a Escola, Série e Turma, depois insira os dados agregados da turma.</p>
        </div>

        <div class="p-6">
            <?php if ($msg_ok): ?><div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?php echo $msg_ok; ?></div><?php endif; ?>
            <?php if ($msg_err): ?><div class="mb-4 p-3 bg-red-100 text-red-700 rounded"><?php echo $msg_err; ?></div><?php endif; ?>

            <!-- Filtros -->
            <div class="bg-gradient-to-r from-purple-50 to-pink-50 border-2 border-purple-200 rounded-lg p-6 mb-6">
                <h3 class="text-lg font-bold text-purple-800 mb-4">
                    <i class="fas fa-filter mr-2"></i>Seleção de Turma
                </h3>
                <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                    <input type="hidden" name="page" value="condensado_supervisor">
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-school mr-1 text-purple-600"></i>Escola
                        </label>
                        <select name="escola" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($escolas as $esc): ?>
                            <option value="<?php echo $esc['id']; ?>" <?php echo $escola_id == $esc['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($esc['nome']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-layer-group mr-1 text-purple-600"></i>Série (Maternal/Períodos)
                        </label>
                        <select name="serie" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($series_db as $s): ?>
                            <option value="<?php echo $s['id']; ?>" <?php echo $serie_id == $s['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($s['nome_serie']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-users mr-1 text-purple-600"></i>Turma
                        </label>
                        <select name="turma" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500 bg-white" onchange="this.form.submit()">
                            <option value="">Selecione...</option>
                            <?php foreach ($turmas_db as $t): ?>
                            <option value="<?php echo $t['id']; ?>" <?php echo $turma_id == $t['id'] ? 'selected' : ''; ?>><?php echo htmlspecialchars($t['nome_turma']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-check mr-1 text-purple-600"></i>Bimestre
                        </label>
                        <select name="bimestre" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500 bg-white" onchange="this.form.submit()">
                            <option value="1" <?php echo $bimestre == 1 ? 'selected' : ''; ?>>1º Bimestre</option>
                            <option value="2" <?php echo $bimestre == 2 ? 'selected' : ''; ?>>2º Bimestre</option>
                            <option value="3" <?php echo $bimestre == 3 ? 'selected' : ''; ?>>3º Bimestre</option>
                            <option value="4" <?php echo $bimestre == 4 ? 'selected' : ''; ?>>4º Bimestre</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-bold text-gray-700 mb-2">
                            <i class="fas fa-calendar-alt mr-1 text-purple-600"></i>Ano Letivo
                        </label>
                        <select name="ano_letivo" class="block w-full border-2 border-gray-400 rounded-md p-3 text-base font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500 bg-white" onchange="this.form.submit()">
                            <?php for ($a = date('Y'); $a >= 2020; $a--): ?>
                            <option value="<?php echo $a; ?>" <?php echo $ano_letivo == $a ? 'selected' : ''; ?>><?php echo $a; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button type="submit" class="w-full bg-purple-600 text-white px-4 py-3 rounded-md font-semibold hover:bg-purple-700 shadow-md hover:shadow-lg transition-all">
                            <i class="fas fa-filter mr-2"></i>Filtrar
                        </button>
                    </div>
                </form>
            </div>

            <?php if ($escola_id && $serie_id && $turma_id && $bimestre && $ano_letivo): ?>
            <div class="bg-purple-50 border-l-4 border-purple-500 p-4 mb-6">
                <p class="font-semibold">Turma Selecionada: <?php echo htmlspecialchars($escola_nome . ' > ' . $serie_nome . ' > Turma ' . $turma_nome); ?></p>
                <p class="text-sm">Bimestre: <?php echo $bimestre; ?>º | Ano Letivo: <?php echo $ano_letivo; ?> | Formulário: <?php 
                    if ($periodo_tipo === 'maternal') echo 'Maternal (11 objetivos)';
                    elseif ($periodo_tipo === '1periodo') echo '1º Período (19 objetivos)';
                    elseif ($periodo_tipo === '2periodo') echo '2º Período (21 objetivos)';
                    else echo 'Não detectado';
                ?></p>
            </div>

            <!-- Formulário de Entrada -->
            <form method="post" class="bg-white shadow-md rounded-lg p-6">
                <input type="hidden" name="action" value="save_condensado_supervisor">
                <input type="hidden" name="periodo_tipo" value="<?php echo htmlspecialchars($periodo_tipo); ?>">
                <input type="hidden" name="escola_id" value="<?php echo $escola_id; ?>">
                <input type="hidden" name="serie_id" value="<?php echo $serie_id; ?>">
                <input type="hidden" name="turma_id" value="<?php echo $turma_id; ?>">
                <input type="hidden" name="ano_letivo" value="<?php echo $ano_letivo; ?>">
                <input type="hidden" name="bimestre" value="<?php echo $bimestre; ?>">

                <!-- Campos Gerais -->
                <div class="bg-purple-50 border-2 border-purple-300 shadow rounded-lg p-6 mb-6">
                    <h3 class="text-lg font-bold mb-4 text-purple-700">Informações Gerais</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Número de Alunos da Turma</label>
                            <input type="number" name="total_alunos" value="<?php echo $dados_existentes['total_alunos'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500">
                        </div>
                        <div>
                            <label class="block text-sm font-bold text-gray-700 mb-2">Número de Alunos com Laudo</label>
                            <input type="number" name="alunos_com_laudo" value="<?php echo $dados_existentes['alunos_com_laudo'] ?? 0; ?>" min="0" class="block w-full border-2 border-gray-400 rounded-md p-3 text-lg font-semibold focus:ring-2 focus:ring-purple-500 focus:border-purple-500">
                        </div>
                    </div>
                </div>

                <?php if ($periodo_tipo === 'maternal'): ?>
                <!-- MATERNAL -->
                <div class="overflow-x-auto">
                    <h3 class="text-lg font-bold mb-3 text-purple-700">CAMPOS DE EXPERIÊNCIAS / OBJETIVOS DE APRENDIZAGEM</h3>
                    <table class="w-full border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-purple-600 text-white">
                                <th colspan="8" class="border border-gray-300 px-4 py-3 text-center font-bold">ESCUTA, FALA, PENSAMENTO E IMAGINAÇÃO</th>
                                <th colspan="3" class="border border-gray-300 px-4 py-3 text-center font-bold">ESPAÇOS, TEMPOS, QUANTIDADES, RELAÇÕES E TRANSFORMAÇÕES</th>
                            </tr>
                            <tr class="bg-gray-100 text-xs">
                                <th class="border border-gray-300 px-2 py-2">Realizar pseudoleitura</th>
                                <th class="border border-gray-300 px-2 py-2">Relatar experiências e fatos acontecidos (Conta histórias)</th>
                                <th class="border border-gray-300 px-2 py-2">Relatar histórias ouvidas ou filmes assistidos (Reconta histórias)</th>
                                <th class="border border-gray-300 px-2 py-2">Representar histórias por meio de registro pictórico</th>
                                <th class="border border-gray-300 px-2 py-2">Diferenciar letra e desenho</th>
                                <th class="border border-gray-300 px-2 py-2">Manusear diferentes instrumentos e suportes de escrita para desenhar, traçar letras e outros sinais gráficos (atendendo ao nível Pré-silábico)</th>
                                <th class="border border-gray-300 px-2 py-2">Identificar 10 letras do alfabeto</th>
                                <th class="border border-gray-300 px-2 py-2">Escrever o primeiro nome com apoio da ficha</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer duas formas geométricas básicas</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar contagem numérica até 10</th>
                                <th class="border border-gray-300 px-2 py-2">Representar quantidades até 3</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 p-1"><input type="number" name="realiza_pseudoleitura" value="<?php echo $dados_existentes['realiza_pseudoleitura'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="relata_experiencias" value="<?php echo $dados_existentes['relata_experiencias'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="relata_historias_ouvidas" value="<?php echo $dados_existentes['relata_historias_ouvidas'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="representa_historias_pictoricas" value="<?php echo $dados_existentes['representa_historias_pictoricas'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="diferencia_letra_desenho" value="<?php echo $dados_existentes['diferencia_letra_desenho'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="manuseia_instrumentos_escrita" value="<?php echo $dados_existentes['manuseia_instrumentos_escrita'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="identifica_10_letras" value="<?php echo $dados_existentes['identifica_10_letras'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="escreve_primeiro_nome" value="<?php echo $dados_existentes['escreve_primeiro_nome'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_formas_geometricas" value="<?php echo $dados_existentes['reconhece_formas_geometricas'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="contagem_ate_10" value="<?php echo $dados_existentes['contagem_ate_10'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="representa_quantidades_ate_3" value="<?php echo $dados_existentes['representa_quantidades_ate_3'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <?php elseif ($periodo_tipo === '1periodo'): ?>
                <!-- 1º PERÍODO -->
                <div class="overflow-x-auto">
                    <h3 class="text-lg font-bold mb-3 text-purple-700">CAMPOS DE EXPERIÊNCIAS / OBJETIVOS DE APRENDIZAGEM</h3>
                    <table class="w-full border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-purple-600 text-white">
                                <th colspan="12" class="border border-gray-300 px-4 py-3 text-center font-bold">ESCUTA, FALA, PENSAMENTO E IMAGINAÇÃO</th>
                                <th colspan="7" class="border border-gray-300 px-4 py-3 text-center font-bold">ESPAÇOS, TEMPOS, QUANTIDADES, RELAÇÕES E TRANSFORMAÇÕES</th>
                            </tr>
                            <tr class="bg-gray-100 text-xs">
                                <th class="border border-gray-300 px-2 py-2">Realizar pseudoleitura</th>
                                <th class="border border-gray-300 px-2 py-2">Recontar histórias</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer a ideia principal de um texto ouvido</th>
                                <th class="border border-gray-300 px-2 py-2">Ler textos não verbais</th>
                                <th class="border border-gray-300 px-2 py-2">Contar histórias</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer, pelo menos, dois gêneros textuais</th>
                                <th class="border border-gray-300 px-2 py-2">Diferenciar letras de números e outros símbolos</th>
                                <th class="border border-gray-300 px-2 py-2">Nomear todas as letras do alfabeto</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer palavras que iniciam ou terminam com o mesmo som</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar cópia de listas ou pequenos textos</th>
                                <th class="border border-gray-300 px-2 py-2">Escrever o próprio nome completo com apoio da ficha</th>
                                <th class="border border-gray-300 px-2 py-2">Levantar hipóteses em relação à linguagem escrita, realizando registro de palavras e textos utilizando letras, por meio de escrita espontânea, atendendo o nível silábico</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer as formas geométricas: círculo, quadrado, triângulo e retângulo</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar classificação com três critérios</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar seriação</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar contagem oral até 20</th>
                                <th class="border border-gray-300 px-2 py-2">Registrar sequência numérica até 10, com cópia</th>
                                <th class="border border-gray-300 px-2 py-2">Representar quantidades até 10</th>
                                <th class="border border-gray-300 px-2 py-2">Resolver situações-problema por meio de materiais concretos ou desenhos</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 p-1"><input type="number" name="realiza_pseudoleitura" value="<?php echo $dados_existentes['realiza_pseudoleitura'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconta_historias" value="<?php echo $dados_existentes['reconta_historias'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_ideia_principal" value="<?php echo $dados_existentes['reconhece_ideia_principal'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="le_textos_nao_verbais" value="<?php echo $dados_existentes['le_textos_nao_verbais'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="conta_historias" value="<?php echo $dados_existentes['conta_historias'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_dois_generos" value="<?php echo $dados_existentes['reconhece_dois_generos'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="diferencia_letras_numeros" value="<?php echo $dados_existentes['diferencia_letras_numeros'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="nomeia_letras_alfabeto" value="<?php echo $dados_existentes['nomeia_letras_alfabeto'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_palavras_mesmo_som" value="<?php echo $dados_existentes['reconhece_palavras_mesmo_som'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="realiza_copia_textos" value="<?php echo $dados_existentes['realiza_copia_textos'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="escreve_nome_completo_ficha" value="<?php echo $dados_existentes['escreve_nome_completo_ficha'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="escrita_nivel_silabico" value="<?php echo $dados_existentes['escrita_nivel_silabico'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_formas_geometricas" value="<?php echo $dados_existentes['reconhece_formas_geometricas'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="classificacao_tres_criterios" value="<?php echo $dados_existentes['classificacao_tres_criterios'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="realiza_seriacao" value="<?php echo $dados_existentes['realiza_seriacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="contagem_oral_ate_20" value="<?php echo $dados_existentes['contagem_oral_ate_20'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="registra_sequencia_ate_10" value="<?php echo $dados_existentes['registra_sequencia_ate_10'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="representa_quantidades_ate_10" value="<?php echo $dados_existentes['representa_quantidades_ate_10'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="resolve_problemas_concretos" value="<?php echo $dados_existentes['resolve_problemas_concretos'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <?php elseif ($periodo_tipo === '2periodo'): ?>
                <!-- 2º PERÍODO -->
                <div class="overflow-x-auto">
                    <h3 class="text-lg font-bold mb-3 text-purple-700">CAMPOS DE EXPERIÊNCIAS / OBJETIVOS DE APRENDIZAGEM</h3>
                    <table class="w-full border-collapse border border-gray-300">
                        <thead>
                            <tr class="bg-purple-600 text-white">
                                <th colspan="12" class="border border-gray-300 px-4 py-3 text-center font-bold">ESCUTA, FALA, PENSAMENTO E IMAGINAÇÃO</th>
                                <th colspan="9" class="border border-gray-300 px-4 py-3 text-center font-bold">ESPAÇOS, TEMPOS, QUANTIDADES, RELAÇÕES E TRANSFORMAÇÕES</th>
                            </tr>
                            <tr class="bg-gray-100 text-xs">
                                <th class="border border-gray-300 px-2 py-2">Recontar histórias ouvidas definindo os contextos, os personagens e a estrutura da história</th>
                                <th class="border border-gray-300 px-2 py-2">Produzir textos de diferentes gêneros por meio de um escriba</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer pelo menos três gêneros textuais</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer a ideia principal de um texto ouvido</th>
                                <th class="border border-gray-300 px-2 py-2">Ler textos não verbais em diferentes suportes</th>
                                <th class="border border-gray-300 px-2 py-2">Nomear todas as letras do alfabeto</th>
                                <th class="border border-gray-300 px-2 py-2">Diferenciar letras de números e outros símbolos</th>
                                <th class="border border-gray-300 px-2 py-2">Escrever todas as letras do alfabeto, sem cópia</th>
                                <th class="border border-gray-300 px-2 py-2">Escrever o próprio nome completo sem apoio da ficha</th>
                                <th class="border border-gray-300 px-2 py-2">Levantar hipóteses em relação à linguagem escrita, realizando registros de palavras e textos utilizando sílabas, por meio de escrita espontânea, atendendo o nível silábico alfabético</th>
                                <th class="border border-gray-300 px-2 py-2">Reconhecer palavras que iniciam ou terminam com o mesmo som</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar cópia de pequenos textos</th>
                                <th class="border border-gray-300 px-2 py-2">Utilizar estratégias de conservação</th>
                                <th class="border border-gray-300 px-2 py-2">Utilizar estratégias de seriação</th>
                                <th class="border border-gray-300 px-2 py-2">Utilizar estratégias classificação</th>
                                <th class="border border-gray-300 px-2 py-2">Registrar sequência numérica até 20, sem cópia</th>
                                <th class="border border-gray-300 px-2 py-2">Realizar contagem oral até 30</th>
                                <th class="border border-gray-300 px-2 py-2">Identificar o antes, o depois e o entre em uma sequência numérica, no mínimo, até 20</th>
                                <th class="border border-gray-300 px-2 py-2">Representar quantidades até 20</th>
                                <th class="border border-gray-300 px-2 py-2">Resolver situações-problema que envolve a noção de adição, por meio de materiais concretos ou desenhos</th>
                                <th class="border border-gray-300 px-2 py-2">Resolver situações-problema que envolve a noção de subtração, por meio de materiais concretos ou desenhos</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconta_historias_completas" value="<?php echo $dados_existentes['reconta_historias_completas'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="produz_textos_escriba" value="<?php echo $dados_existentes['produz_textos_escriba'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_tres_generos" value="<?php echo $dados_existentes['reconhece_tres_generos'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_ideia_principal" value="<?php echo $dados_existentes['reconhece_ideia_principal'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="le_textos_nao_verbais" value="<?php echo $dados_existentes['le_textos_nao_verbais'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="nomeia_letras_alfabeto" value="<?php echo $dados_existentes['nomeia_letras_alfabeto'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="diferencia_letras_numeros" value="<?php echo $dados_existentes['diferencia_letras_numeros'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="escreve_alfabeto_sem_copia" value="<?php echo $dados_existentes['escreve_alfabeto_sem_copia'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="escreve_nome_sem_ficha" value="<?php echo $dados_existentes['escreve_nome_sem_ficha'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="escrita_silabico_alfabetico" value="<?php echo $dados_existentes['escrita_silabico_alfabetico'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="reconhece_palavras_mesmo_som" value="<?php echo $dados_existentes['reconhece_palavras_mesmo_som'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="realiza_copia_textos" value="<?php echo $dados_existentes['realiza_copia_textos'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="utiliza_conservacao" value="<?php echo $dados_existentes['utiliza_conservacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="utiliza_seriacao" value="<?php echo $dados_existentes['utiliza_seriacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="utiliza_classificacao" value="<?php echo $dados_existentes['utiliza_classificacao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="registra_sequencia_ate_20" value="<?php echo $dados_existentes['registra_sequencia_ate_20'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="contagem_oral_ate_30" value="<?php echo $dados_existentes['contagem_oral_ate_30'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="identifica_antes_depois_entre" value="<?php echo $dados_existentes['identifica_antes_depois_entre'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="representa_quantidades_ate_20" value="<?php echo $dados_existentes['representa_quantidades_ate_20'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="resolve_problemas_adicao" value="<?php echo $dados_existentes['resolve_problemas_adicao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                                <td class="border border-gray-300 p-1"><input type="number" name="resolve_problemas_subtracao" value="<?php echo $dados_existentes['resolve_problemas_subtracao'] ?? 0; ?>" min="0" class="w-full text-center p-2"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>

                <div class="flex justify-end">
                    <button type="submit" class="bg-purple-600 text-white px-6 py-3 rounded-lg hover:bg-purple-700 text-lg font-semibold">
                        <i class="fas fa-save mr-2"></i>Salvar Condensado
                    </button>
                </div>
            </form>
            <?php else: ?>
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-6 text-gray-700">
                    <p class="text-center">Selecione Escola, Série e Turma acima para cadastrar o condensado.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
