<!-- Dashboard Home -->
<div class="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-4 mb-8">
    <!-- Estatísticas Cards -->
    <div class="bg-white overflow-hidden shadow rounded-lg">
        <div class="p-5">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-users text-primary-600 text-2xl"></i>
                </div>
                <div class="ml-5 w-0 flex-1">
                    <dl>
                        <dt class="text-sm font-medium text-gray-500 truncate">Total de Usuários</dt>
                        <dd class="text-lg font-medium text-gray-900">
                            <?php
                            try {
                                // Usa a conexão global do dashboard
                                global $pdo;
                                if (!isset($pdo)) {
                                    require_once __DIR__ . '/../config/database.php';
                                    $pdo = getDBConnection();
                                }
                                $count = $pdo->query("SELECT COUNT(*) FROM usuarios")->fetchColumn();
                                echo $count;
                            } catch (Exception $e) {
                                echo "0";
                            }
                            ?>
                        </dd>
                    </dl>
                </div>
            </div>
        </div>
        <div class="bg-gray-50 px-5 py-3">
            <div class="text-sm">
                <a href="?page=users" class="font-medium text-primary-700 hover:text-primary-900">
                    Ver todos
                </a>
            </div>
        </div>
    </div>

    <div class="bg-white overflow-hidden shadow rounded-lg">
        <div class="p-5">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-user-check text-green-600 text-2xl"></i>
                </div>
                <div class="ml-5 w-0 flex-1">
                    <dl>
                        <dt class="text-sm font-medium text-gray-500 truncate">Usuários Ativos</dt>
                        <dd class="text-lg font-medium text-gray-900">
                            <?php
                            try {
                                $count = $pdo->query("SELECT COUNT(*) FROM usuarios WHERE ativo = 1")->fetchColumn();
                                echo $count;
                            } catch (Exception $e) {
                                echo "0";
                            }
                            ?>
                        </dd>
                    </dl>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white overflow-hidden shadow rounded-lg">
        <div class="p-5">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-shield-alt text-blue-600 text-2xl"></i>
                </div>
                <div class="ml-5 w-0 flex-1">
                    <dl>
                        <dt class="text-sm font-medium text-gray-500 truncate">Administradores</dt>
                        <dd class="text-lg font-medium text-gray-900">
                            <?php
                            try {
                                $count = $pdo->query("SELECT COUNT(*) FROM usuarios WHERE nivel = 9")->fetchColumn();
                                echo $count;
                            } catch (Exception $e) {
                                echo "0";
                            }
                            ?>
                        </dd>
                    </dl>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white overflow-hidden shadow rounded-lg">
        <div class="p-5">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <i class="fas fa-clock text-orange-600 text-2xl"></i>
                </div>
                <div class="ml-5 w-0 flex-1">
                    <dl>
                        <dt class="text-sm font-medium text-gray-500 truncate">Últimos Logins</dt>
                        <dd class="text-lg font-medium text-gray-900">
                            <?php
                            try {
                                $count = $pdo->query("SELECT COUNT(*) FROM usuarios WHERE ultimo_login >= DATE_SUB(NOW(), INTERVAL 7 DAY)")->fetchColumn();
                                echo $count;
                            } catch (Exception $e) {
                                echo "0";
                            }
                            ?>
                        </dd>
                    </dl>
                </div>
            </div>
        </div>
        <div class="bg-gray-50 px-5 py-3">
            <div class="text-sm">
                <span class="text-gray-500">Últimos 7 dias</span>
            </div>
        </div>
    </div>
</div>

<!-- Ações Rápidas -->
<div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
    <div class="bg-white shadow rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">Ações Rápidas</h3>
        <div class="space-y-3">
            <a href="?page=users&action=new" class="w-full flex items-center justify-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-primary-600 hover:bg-primary-700">
                <i class="fas fa-user-plus mr-2"></i>
                Novo Usuário
            </a>
            <a href="?page=settings" class="w-full flex items-center justify-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                <i class="fas fa-cog mr-2"></i>
                Configurações
            </a>
        </div>
    </div>

    <div class="bg-white shadow rounded-lg p-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">Últimas Atividades</h3>
        <div class="flow-root">
            <ul class="-mb-8">
                <?php
                try {
                    $stmt = $pdo->query("SELECT nome, email, criado_em FROM usuarios ORDER BY criado_em DESC LIMIT 5");
                    while ($user = $stmt->fetch()) {
                        echo '<li class="relative pb-4">';
                        echo '<div class="relative flex space-x-3">';
                        echo '<div class="min-w-0 flex-1">';
                        echo '<div class="text-sm text-gray-500">';
                        echo '<span class="font-medium text-gray-900">' . htmlspecialchars($user['nome']) . '</span>';
                        echo ' se registrou';
                        echo '</div>';
                        echo '<div class="mt-0.5 text-xs text-gray-500">';
                        echo date('d/m/Y H:i', strtotime($user['criado_em']));
                        echo '</div>';
                        echo '</div>';
                        echo '</div>';
                        echo '</li>';
                    }
                } catch (Exception $e) {
                    echo '<li class="text-gray-500 text-sm">Nenhuma atividade recente</li>';
                }
                ?>
            </ul>
        </div>
    </div>
</div>