<!-- Gerenciamento de Permissões -->
<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Criar tabela de permissões se não existir
$pdo->exec("CREATE TABLE IF NOT EXISTS permissoes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nome VARCHAR(100) NOT NULL UNIQUE,
        descricao TEXT,
        modulo VARCHAR(50),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Verificar se já existem permissões
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM permissoes");
    $count = $stmt->fetch()['total'];
    
    // Inserir permissões padrão apenas se a tabela estiver vazia
    if ($count == 0) {
        $permissions = [
            ['Gerenciar Usuários', 'Criar, editar e excluir usuários', 'usuarios'],
            ['Visualizar Usuários', 'Apenas visualizar lista de usuários', 'usuarios'],
            ['Gerenciar Configurações', 'Alterar configurações do sistema', 'configuracoes'],
            ['Visualizar Relatórios', 'Acesso aos relatórios do sistema', 'relatorios'],
            ['Administrador Total', 'Acesso completo ao sistema', 'sistema']
        ];
        
        foreach ($permissions as $perm) {
            $stmt = $pdo->prepare("INSERT INTO permissoes (nome, descricao, modulo) VALUES (?, ?, ?)");
            $stmt->execute($perm);
        }
    }
    
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// Processar ações
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create_permission':
                $nome = $_POST['nome'];
                $descricao = $_POST['descricao'];
                $modulo = $_POST['modulo'];
                
                $stmt = $pdo->prepare("INSERT INTO permissoes (nome, descricao, modulo) VALUES (?, ?, ?)");
                if ($stmt->execute([$nome, $descricao, $modulo])) {
                    echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Permissão criada com sucesso!</div>';
                }
                break;
                
            case 'edit_permission':
                $id = $_POST['id'];
                $nome = $_POST['nome'];
                $descricao = $_POST['descricao'];
                $modulo = $_POST['modulo'];
                
                $stmt = $pdo->prepare("UPDATE permissoes SET nome = ?, descricao = ?, modulo = ? WHERE id = ?");
                if ($stmt->execute([$nome, $descricao, $modulo, $id])) {
                    echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Permissão editada com sucesso!</div>';
                }
                break;
                
            case 'delete_permission':
                $id = $_POST['id'];
                
                // Verificar se a permissão está sendo usada
                $stmt = $pdo->prepare("SELECT COUNT(*) FROM usuario_permissoes WHERE permissao_id = ?");
                $stmt->execute([$id]);
                $inUse = $stmt->fetchColumn();
                
                if ($inUse > 0) {
                    echo '<div class="mb-4 p-4 bg-yellow-100 text-yellow-700 rounded-lg">Não é possível excluir esta permissão pois ela está sendo usada por usuários.</div>';
                } else {
                    $stmt = $pdo->prepare("DELETE FROM permissoes WHERE id = ?");
                    if ($stmt->execute([$id])) {
                        echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Permissão excluída com sucesso!</div>';
                    }
                }
                break;
                
            case 'update_user_permissions':
                $user_id = $_POST['user_id'];
                $permissions = $_POST['permissions'] ?? [];
                
                // Primeiro, limpar permissões existentes do usuário
                $stmt = $pdo->prepare("DELETE FROM usuario_permissoes WHERE usuario_id = ?");
                $stmt->execute([$user_id]);
                
                // Inserir novas permissões
                foreach ($permissions as $perm_id) {
                    $stmt = $pdo->prepare("INSERT INTO usuario_permissoes (usuario_id, permissao_id) VALUES (?, ?)");
                    $stmt->execute([$user_id, $perm_id]);
                }
                
                echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Permissões do usuário atualizadas!</div>';
                break;
        }
    }
}

// Criar tabela de relacionamento usuário-permissões se não existir
$pdo->exec("CREATE TABLE IF NOT EXISTS usuario_permissoes (
    usuario_id INT,
    permissao_id INT,
    PRIMARY KEY (usuario_id, permissao_id),
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE,
    FOREIGN KEY (permissao_id) REFERENCES permissoes(id) ON DELETE CASCADE
)");
?>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <!-- Lista de Permissões -->
    <div class="bg-white shadow rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-900">Permissões do Sistema</h3>
            <button onclick="openPermissionModal()" class="bg-primary-600 text-white px-3 py-1 rounded text-sm hover:bg-primary-700">
                <i class="fas fa-plus mr-1"></i>Nova
            </button>
        </div>
        
        <div class="p-6">
            <?php
            $stmt = $pdo->query("SELECT * FROM permissoes ORDER BY modulo, nome");
            $current_module = '';
            while ($perm = $stmt->fetch()):
                if ($current_module !== $perm['modulo']):
                    if ($current_module !== '') echo '</div>';
                    echo '<div class="mb-4">';
                    echo '<h4 class="text-sm font-medium text-gray-900 mb-2">' . ucfirst($perm['modulo']) . '</h4>';
                    $current_module = $perm['modulo'];
                endif;
            ?>
            <div class="flex items-center justify-between p-3 bg-gray-50 rounded mb-2">
                <div>
                    <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($perm['nome']); ?></div>
                    <div class="text-xs text-gray-500"><?php echo htmlspecialchars($perm['descricao']); ?></div>
                </div>
                <div class="flex space-x-2">
                    <button onclick="editPermission(<?php echo $perm['id']; ?>, '<?php echo addslashes($perm['nome']); ?>', '<?php echo addslashes($perm['descricao']); ?>', '<?php echo $perm['modulo']; ?>')" 
                            class="text-indigo-600 hover:text-indigo-900 text-sm" title="Editar">
                        <i class="fas fa-edit"></i>
                    </button>
                    <button onclick="deletePermission(<?php echo $perm['id']; ?>, '<?php echo addslashes($perm['nome']); ?>')" 
                            class="text-red-600 hover:text-red-900 text-sm" title="Excluir">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
            <?php endwhile; ?>
            </div>
        </div>
    </div>

    <!-- Gerenciar Permissões por Usuário -->
    <div class="bg-white shadow rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Permissões por Usuário</h3>
        </div>
        
        <div class="p-6">
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-2">Selecionar Usuário</label>
                <select id="userSelect" onchange="loadUserPermissions()" class="block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                    <option value="">Selecione um usuário...</option>
                    <?php
                    $stmt = $pdo->query("SELECT id, nome, email FROM usuarios ORDER BY nome");
                    while ($user = $stmt->fetch()):
                    ?>
                    <option value="<?php echo $user['id']; ?>"><?php echo htmlspecialchars($user['nome'] . ' (' . $user['email'] . ')'); ?></option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div id="userPermissions" style="display: none;">
                <form method="POST" id="permissionsForm">
                    <input type="hidden" name="action" value="update_user_permissions">
                    <input type="hidden" name="user_id" id="selectedUserId">
                    
                    <div class="space-y-3" id="permissionsList">
                        <!-- Permissões serão carregadas via JavaScript -->
                    </div>
                    
                    <div class="mt-4 flex justify-end">
                        <button type="submit" class="bg-primary-600 text-white px-4 py-2 rounded hover:bg-primary-700">
                            <i class="fas fa-save mr-2"></i>Salvar Permissões
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Matriz de Permissões -->
<div class="mt-6 bg-white shadow rounded-lg">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-lg font-medium text-gray-900">Matriz de Permissões</h3>
        <p class="text-sm text-gray-500">Visão geral das permissões por usuário</p>
    </div>
    
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Usuário</th>
                    <?php
                    $permissions = $pdo->query("SELECT id, nome FROM permissoes ORDER BY nome")->fetchAll();
                    foreach ($permissions as $perm):
                    ?>
                    <th class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider" style="writing-mode: vertical-lr; text-orientation: mixed;">
                        <?php echo htmlspecialchars($perm['nome']); ?>
                    </th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php
                $users = $pdo->query("SELECT id, nome FROM usuarios ORDER BY nome")->fetchAll();
                foreach ($users as $user):
                    // Buscar permissões do usuário
                    $stmt = $pdo->prepare("SELECT permissao_id FROM usuario_permissoes WHERE usuario_id = ?");
                    $stmt->execute([$user['id']]);
                    $userPerms = $stmt->fetchAll(PDO::FETCH_COLUMN);
                ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                        <?php echo htmlspecialchars($user['nome']); ?>
                    </td>
                    <?php foreach ($permissions as $perm): ?>
                    <td class="px-3 py-4 text-center">
                        <?php if (in_array($perm['id'], $userPerms)): ?>
                            <i class="fas fa-check-circle text-green-500"></i>
                        <?php else: ?>
                            <i class="fas fa-times-circle text-red-300"></i>
                        <?php endif; ?>
                    </td>
                    <?php endforeach; ?>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal para Nova Permissão -->
<div id="permissionModal" class="fixed inset-0 z-50 overflow-y-auto hidden">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75" onclick="closePermissionModal()"></div>
        <div class="bg-white rounded-lg overflow-hidden shadow-xl max-w-md w-full z-50">
            <form method="POST">
                <div class="px-6 py-4 border-b">
                    <h3 class="text-lg font-medium text-gray-900">Nova Permissão</h3>
                </div>
                <div class="p-6 space-y-4">
                    <input type="hidden" name="action" value="create_permission">
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Nome da Permissão</label>
                        <input type="text" name="nome" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Descrição</label>
                        <textarea name="descricao" rows="2" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Módulo</label>
                        <select name="modulo" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                            <option value="usuarios">Usuários</option>
                            <option value="configuracoes">Configurações</option>
                            <option value="relatorios">Relatórios</option>
                            <option value="sistema">Sistema</option>
                        </select>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 flex justify-end space-x-3">
                    <button type="button" onclick="closePermissionModal()" class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                        Cancelar
                    </button>
                    <button type="submit" class="px-4 py-2 bg-primary-600 border border-transparent rounded-md text-sm font-medium text-white hover:bg-primary-700">
                        Criar Permissão
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal para Editar Permissão -->
<div id="editPermissionModal" class="fixed inset-0 z-50 overflow-y-auto hidden">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75" onclick="closeEditPermissionModal()"></div>
        <div class="bg-white rounded-lg overflow-hidden shadow-xl max-w-md w-full z-50">
            <form method="POST">
                <div class="px-6 py-4 border-b">
                    <h3 class="text-lg font-medium text-gray-900">Editar Permissão</h3>
                </div>
                <div class="p-6 space-y-4">
                    <input type="hidden" name="action" value="edit_permission">
                    <input type="hidden" name="id" id="edit_permission_id">
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Nome da Permissão</label>
                        <input type="text" name="nome" id="edit_nome" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Descrição</label>
                        <textarea name="descricao" id="edit_descricao" rows="2" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Módulo</label>
                        <select name="modulo" id="edit_modulo" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                            <option value="usuarios">Usuários</option>
                            <option value="configuracoes">Configurações</option>
                            <option value="relatorios">Relatórios</option>
                            <option value="sistema">Sistema</option>
                        </select>
                    </div>
                </div>
                <div class="px-6 py-4 bg-gray-50 flex justify-end space-x-3">
                    <button type="button" onclick="closeEditPermissionModal()" class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                        Cancelar
                    </button>
                    <button type="submit" class="px-4 py-2 bg-primary-600 border border-transparent rounded-md text-sm font-medium text-white hover:bg-primary-700">
                        Salvar Alterações
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openPermissionModal() {
    document.getElementById('permissionModal').classList.remove('hidden');
}

function closePermissionModal() {
    document.getElementById('permissionModal').classList.add('hidden');
}

function openEditPermissionModal() {
    document.getElementById('editPermissionModal').classList.remove('hidden');
}

function closeEditPermissionModal() {
    document.getElementById('editPermissionModal').classList.add('hidden');
}

function editPermission(id, nome, descricao, modulo) {
    document.getElementById('edit_permission_id').value = id;
    document.getElementById('edit_nome').value = nome;
    document.getElementById('edit_descricao').value = descricao;
    document.getElementById('edit_modulo').value = modulo;
    openEditPermissionModal();
}

function deletePermission(id, nome) {
    if (confirm('Tem certeza que deseja excluir a permissão "' + nome + '"?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = '<input type="hidden" name="action" value="delete_permission"><input type="hidden" name="id" value="' + id + '">';
        document.body.appendChild(form);
        form.submit();
    }
}

function loadUserPermissions() {
    const userId = document.getElementById('userSelect').value;
    if (!userId) {
        document.getElementById('userPermissions').style.display = 'none';
        return;
    }
    
    document.getElementById('selectedUserId').value = userId;
    
    // Buscar permissões do usuário via AJAX
    fetch(`api/user_permissions.php?user_id=${userId}`)
        .then(response => response.json())
        .then(data => {
            const permissionsList = document.getElementById('permissionsList');
            permissionsList.innerHTML = '';
            
            data.all_permissions.forEach(permission => {
                const isChecked = data.user_permissions.includes(permission.id.toString());
                
                const div = document.createElement('div');
                div.className = 'flex items-center';
                div.innerHTML = `
                    <input type="checkbox" name="permissions[]" value="${permission.id}" 
                           ${isChecked ? 'checked' : ''} 
                           class="h-4 w-4 text-primary-600 focus:ring-primary-500 border-gray-300 rounded">
                    <label class="ml-3 text-sm text-gray-700">
                        <span class="font-medium">${permission.nome}</span>
                        <span class="text-gray-500"> - ${permission.descricao}</span>
                    </label>
                `;
                permissionsList.appendChild(div);
            });
            
            document.getElementById('userPermissions').style.display = 'block';
        })
        .catch(error => {
            console.error('Erro ao carregar permissões:', error);
        });
}
</script>