<?php
// Proteção da página
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$tipo_relatorio = $_GET['tipo'] ?? '';
$escola_id = $_GET['escola'] ?? '';
$serie_id = $_GET['serie'] ?? '';
$turma_id = $_GET['turma'] ?? '';
$bimestre = $_GET['bimestre'] ?? '';
$ano_letivo = $_GET['ano_letivo'] ?? date('Y');

if (!$tipo_relatorio || !$escola_id || !$turma_id) {
    die('Parâmetros inválidos!');
}

// Buscar informações
$st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
$st->execute([$escola_id]);
$escola = $st->fetch(PDO::FETCH_ASSOC);

$serie = null;
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute([$serie_id]);
    $serie = $st->fetch(PDO::FETCH_ASSOC);
}

$st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
$st->execute([$turma_id]);
$turma = $st->fetch(PDO::FETCH_ASSOC);

$tabelas = [
    'leitura_iniciais' => 'condensado_leitura_turma',
    'matematica_iniciais' => 'condensado_matematica_turma',
    'supervisor' => 'condensado_supervisor_maternal',
    'leitura_finais' => 'condensado_leitura_finais',
    'redacao_finais' => 'condensado_redacao_finais',
    'matematica_finais' => 'condensado_matematica_finais'
];

$titulos = [
    'leitura_iniciais' => 'Condensado Leitura Escrita 1-5',
    'matematica_iniciais' => 'Condensado Matemática 1-5',
    'supervisor' => 'Condensado Supervisor',
    'leitura_finais' => 'Condensado Leitura Escrita 6-9',
    'redacao_finais' => 'Condensado Redação 6-9',
    'matematica_finais' => 'Condensado Matemática 6-9'
];

$tabela = $tabelas[$tipo_relatorio] ?? '';
$titulo = $titulos[$tipo_relatorio] ?? 'Relatório';

// Buscar dados do condensado
// Supervisor não usa serie_id, apenas turma_id
if ($tipo_relatorio === 'supervisor') {
    $query = "SELECT * FROM {$tabela} WHERE escola_id = ? AND turma_id = ? AND ano_letivo = ?";
    $params = [$escola_id, $turma_id, $ano_letivo];
} else {
    $query = "SELECT * FROM {$tabela} WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ?";
    $params = [$escola_id, $serie_id, $turma_id, $ano_letivo];
}

// Adicionar filtro de bimestre se especificado
if ($bimestre) {
    $query .= " AND bimestre = ?";
    $params[] = $bimestre;
}

$st = $pdo->prepare($query);
$st->execute($params);
$dados = $st->fetch(PDO::FETCH_ASSOC);

if (!$dados) {
    die('Nenhum dado encontrado!');
}

// Configurar headers para download Excel
$serie_nome = $serie ? $serie['nome_serie'] : 'Supervisor';
$filename = $titulo . '_' . $escola['nome'] . '_' . $serie_nome . '_' . $turma['nome_turma'];
if ($bimestre) {
    $filename .= '_' . $bimestre . 'Bim';
}
$filename .= '_' . $ano_letivo . '.xls';
$filename = preg_replace('/[^A-Za-z0-9_\-]/', '_', $filename);

header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=\"{$filename}\"");
header("Pragma: no-cache");
header("Expires: 0");

echo "\xEF\xBB\xBF"; // UTF-8 BOM
?>
<html xmlns:x="urn:schemas-microsoft-com:office:excel">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <xml>
        <x:ExcelWorkbook>
            <x:ExcelWorksheets>
                <x:ExcelWorksheet>
                    <x:Name><?php echo $titulo; ?></x:Name>
                    <x:WorksheetOptions>
                        <x:Print>
                            <x:ValidPrinterInfo/>
                        </x:Print>
                    </x:WorksheetOptions>
                </x:ExcelWorksheet>
            </x:ExcelWorksheets>
        </x:ExcelWorkbook>
    </xml>
</head>
<body>
    <table border="1">
        <thead>
            <tr style="background-color: #0d9488; color: white; font-weight: bold;">
                <th colspan="2" style="padding: 10px; font-size: 16px;"><?php echo $titulo; ?></th>
            </tr>
            <tr>
                <th colspan="2" style="background-color: #e0f2f1; padding: 5px;">INFORMAÇÕES DA TURMA</th>
            </tr>
            <tr>
                <td style="font-weight: bold;">Escola:</td>
                <td><?php echo htmlspecialchars($escola['nome']); ?></td>
            </tr>
            <tr>
                <td style="font-weight: bold;">Série:</td>
                <td><?php echo htmlspecialchars($serie['nome_serie']); ?></td>
            </tr>
            <tr>
                <td style="font-weight: bold;">Turma:</td>
                <td><?php echo htmlspecialchars($turma['nome_turma']); ?></td>
            </tr>
            <tr>
                <td style="font-weight: bold;">Ano Letivo:</td>
                <td><?php echo $ano_letivo; ?></td>
            </tr>
            <tr>
                <th colspan="2" style="background-color: #e0f2f1; padding: 5px;">INFORMAÇÕES GERAIS</th>
            </tr>
            <tr>
                <td style="font-weight: bold;">Total de Alunos:</td>
                <td><?php echo $dados['total_alunos'] ?? 0; ?></td>
            </tr>
            <tr>
                <td style="font-weight: bold;">Alunos com Necessidades Especiais:</td>
                <td><?php echo $dados['alunos_necessidades_especiais'] ?? $dados['necessidades_especiais'] ?? $dados['alunos_com_laudo'] ?? 0; ?></td>
            </tr>
            <tr>
                <th colspan="2" style="background-color: #0d9488; color: white; font-weight: bold; padding: 5px;">DADOS DO CONDENSADO</th>
            </tr>
            <tr style="background-color: #b2dfdb; font-weight: bold;">
                <th>Campo</th>
                <th>Valor</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $campos_ignorar = ['id', 'escola_id', 'serie_id', 'turma_id', 'ano_letivo', 'total_alunos', 
                              'alunos_necessidades_especiais', 'necessidades_especiais', 'alunos_com_laudo', 
                              'created_at', 'updated_at'];
            
            foreach ($dados as $campo => $valor):
                if (in_array($campo, $campos_ignorar)) continue;
                $nome_formatado = ucfirst(str_replace('_', ' ', $campo));
            ?>
            <tr>
                <td><?php echo htmlspecialchars($nome_formatado); ?></td>
                <td style="font-weight: bold;"><?php echo $valor ?? 0; ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
