<?php
// Proteção da página
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$tipo_relatorio = $_GET['tipo'] ?? '';
$escola_id = $_GET['escola'] ?? '';
$serie_id = $_GET['serie'] ?? '';
$turma_id = $_GET['turma'] ?? '';
$bimestre = $_GET['bimestre'] ?? '';
$ano_letivo = $_GET['ano_letivo'] ?? date('Y');

if (!$tipo_relatorio || !$escola_id || !$turma_id) {
    die('Parâmetros inválidos!');
}

// Buscar informações
$st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
$st->execute([$escola_id]);
$escola = $st->fetch(PDO::FETCH_ASSOC);

$serie = null;
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute([$serie_id]);
    $serie = $st->fetch(PDO::FETCH_ASSOC);
}

$st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
$st->execute([$turma_id]);
$turma = $st->fetch(PDO::FETCH_ASSOC);

$tabelas = [
    'leitura_iniciais' => 'condensado_leitura_turma',
    'matematica_iniciais' => 'condensado_matematica_turma',
    'supervisor' => 'condensado_supervisor_maternal',
    'leitura_finais' => 'condensado_leitura_finais',
    'redacao_finais' => 'condensado_redacao_finais',
    'matematica_finais' => 'condensado_matematica_finais'
];

$titulos = [
    'leitura_iniciais' => 'Condensado Geral de Leitura e Escrita - 1º ao 5º Ano',
    'matematica_iniciais' => 'Condensado Geral de Matemática - 1º ao 5º Ano',
    'supervisor' => 'Supervisor: Monitoramento da Aprendizagem',
    'leitura_finais' => 'Condensado Geral de Leitura e Escrita - 6º ao 9º Ano',
    'redacao_finais' => 'Condensado Geral de Redação - 6º ao 9º Ano',
    'matematica_finais' => 'Condensado Geral de Matemática - 6º ao 9º Ano'
];

$tabela = $tabelas[$tipo_relatorio] ?? '';
$titulo = $titulos[$tipo_relatorio] ?? 'Relatório';

// Buscar dados do condensado
// Supervisor não usa serie_id, apenas turma_id
if ($tipo_relatorio === 'supervisor') {
    $query = "SELECT * FROM {$tabela} WHERE escola_id = ? AND turma_id = ? AND ano_letivo = ?";
    $params = [$escola_id, $turma_id, $ano_letivo];
} else {
    $query = "SELECT * FROM {$tabela} WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ?";
    $params = [$escola_id, $serie_id, $turma_id, $ano_letivo];
}

// Adicionar filtro de bimestre se especificado
if ($bimestre) {
    $query .= " AND bimestre = ?";
    $params[] = $bimestre;
}

$st = $pdo->prepare($query);
$st->execute($params);
$dados = $st->fetch(PDO::FETCH_ASSOC);

if (!$dados) {
    die('Nenhum dado encontrado!');
}

// Configurar para PDF
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Relatório - <?php echo $titulo; ?></title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { background: #0d9488; color: white; padding: 20px; margin-bottom: 20px; }
        .info-box { background: #f0f9ff; border: 2px solid #0ea5e9; padding: 15px; margin-bottom: 20px; }
        .data-box { background: #f9fafb; border: 1px solid #d1d5db; padding: 10px; margin: 5px; display: inline-block; width: 30%; }
        .label { font-size: 12px; color: #6b7280; }
        .value { font-size: 24px; font-weight: bold; color: #1f2937; }
        h2 { color: #0d9488; border-bottom: 2px solid #0d9488; padding-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #d1d5db; padding: 8px; text-align: left; }
        th { background: #e5e7eb; font-weight: bold; }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo $titulo; ?></h1>
        <p>Relatório Detalhado</p>
    </div>

    <div class="info-box">
        <h2>Informações da Turma</h2>
        <p><strong>Escola:</strong> <?php echo htmlspecialchars($escola['nome']); ?></p>
        <p><strong>Série:</strong> <?php echo htmlspecialchars($serie['nome_serie']); ?></p>
        <p><strong>Turma:</strong> <?php echo htmlspecialchars($turma['nome_turma']); ?></p>
        <p><strong>Ano Letivo:</strong> <?php echo $ano_letivo; ?></p>
    </div>

    <h2>Informações Gerais</h2>
    <div class="data-box">
        <div class="label">Total de Alunos</div>
        <div class="value"><?php echo $dados['total_alunos'] ?? 0; ?></div>
    </div>
    <div class="data-box">
        <div class="label">Alunos com Necessidades Especiais</div>
        <div class="value">
            <?php echo $dados['alunos_necessidades_especiais'] ?? $dados['necessidades_especiais'] ?? $dados['alunos_com_laudo'] ?? 0; ?>
        </div>
    </div>

    <h2>Dados do Condensado</h2>
    <table>
        <thead>
            <tr>
                <th>Campo</th>
                <th>Valor</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $campos_ignorar = ['id', 'escola_id', 'serie_id', 'turma_id', 'ano_letivo', 'total_alunos', 
                              'alunos_necessidades_especiais', 'necessidades_especiais', 'alunos_com_laudo', 
                              'created_at', 'updated_at'];
            
            foreach ($dados as $campo => $valor):
                if (in_array($campo, $campos_ignorar)) continue;
                $nome_formatado = ucfirst(str_replace('_', ' ', $campo));
            ?>
            <tr>
                <td><?php echo htmlspecialchars($nome_formatado); ?></td>
                <td><strong><?php echo $valor ?? 0; ?></strong></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>
