<?php
// Proteção da página
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// O $pdo já está disponível do dashboard.php

$tipo_relatorio = $_GET['tipo'] ?? '';
$escola_id = $_GET['escola'] ?? '';
$serie_id = $_GET['serie'] ?? '';
$turma_id = $_GET['turma'] ?? '';
$bimestre = $_GET['bimestre'] ?? '';
$ano_letivo = $_GET['ano_letivo'] ?? date('Y');

if (!$tipo_relatorio || !$escola_id || !$turma_id) {
    echo '<div class="p-6 bg-red-100 text-red-700 rounded">Parâmetros inválidos!</div>';
    return;
}

// Buscar informações da escola/série/turma
$st = $pdo->prepare('SELECT nome FROM escolas WHERE id = ?');
$st->execute([$escola_id]);
$escola = $st->fetch(PDO::FETCH_ASSOC);

$serie = null;
if ($serie_id) {
    $st = $pdo->prepare('SELECT nome_serie FROM escola_series WHERE id = ?');
    $st->execute([$serie_id]);
    $serie = $st->fetch(PDO::FETCH_ASSOC);
}

$st = $pdo->prepare('SELECT nome_turma FROM turmas WHERE id = ?');
$st->execute([$turma_id]);
$turma = $st->fetch(PDO::FETCH_ASSOC);

// Determinar qual tabela buscar
$tabelas = [
    'leitura_iniciais' => 'condensado_leitura_turma',
    'matematica_iniciais' => 'condensado_matematica_turma',
    'supervisor' => 'condensado_supervisor_maternal',
    'leitura_finais' => 'condensado_leitura_finais',
    'redacao_finais' => 'condensado_redacao_finais',
    'matematica_finais' => 'condensado_matematica_finais'
];

$titulos = [
    'leitura_iniciais' => 'Condensado Geral de Leitura e Escrita - 1º ao 5º Ano',
    'matematica_iniciais' => 'Condensado Geral de Matemática - 1º ao 5º Ano',
    'supervisor' => 'Supervisor: Monitoramento da Aprendizagem - Condensado',
    'leitura_finais' => 'Condensado Geral de Leitura e Escrita - 6º ao 9º Ano',
    'redacao_finais' => 'Condensado Geral de Redação - 6º ao 9º Ano',
    'matematica_finais' => 'Condensado Geral de Matemática - 6º ao 9º Ano'
];

$tabela = $tabelas[$tipo_relatorio] ?? '';
$titulo = $titulos[$tipo_relatorio] ?? 'Relatório';

if (!$tabela) {
    echo '<div class="p-6 bg-red-100 text-red-700 rounded">Tipo de relatório inválido!</div>';
    return;
}

// Buscar dados do condensado
// Supervisor não usa serie_id, apenas turma_id
if ($tipo_relatorio === 'supervisor') {
    $query = "SELECT * FROM {$tabela} WHERE escola_id = ? AND turma_id = ? AND ano_letivo = ?";
    $params = [$escola_id, $turma_id, $ano_letivo];
} else {
    $query = "SELECT * FROM {$tabela} WHERE escola_id = ? AND serie_id = ? AND turma_id = ? AND ano_letivo = ?";
    $params = [$escola_id, $serie_id, $turma_id, $ano_letivo];
}

// Adicionar filtro de bimestre se especificado
if ($bimestre) {
    $query .= " AND bimestre = ?";
    $params[] = $bimestre;
}

$st = $pdo->prepare($query);
$st->execute($params);
$dados = $st->fetch(PDO::FETCH_ASSOC);

if (!$dados) {
    echo '<div class="p-6 bg-yellow-100 text-yellow-700 rounded">Nenhum dado encontrado para esta turma!</div>';
    return;
}
?>

<div class="max-w-full">
    <div class="bg-white shadow-lg rounded-lg mb-6">
        <!-- Cabeçalho do Relatório -->
        <div class="bg-gradient-to-r from-teal-600 to-cyan-800 px-6 py-4 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-white">
                        <i class="fas fa-file-alt mr-3"></i><?php echo $titulo; ?>
                    </h1>
                    <p class="text-teal-100 mt-1">Relatório Detalhado</p>
                </div>
                <button onclick="window.print()" class="bg-white text-teal-700 px-4 py-2 rounded-md font-semibold hover:bg-teal-50 print:hidden">
                    <i class="fas fa-print mr-2"></i>Imprimir
                </button>
            </div>
        </div>

        <div class="p-6">
            <!-- Informações da Turma -->
            <div class="bg-gradient-to-r from-gray-50 to-slate-50 border-2 border-gray-300 rounded-lg p-6 mb-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4">
                    <i class="fas fa-info-circle mr-2"></i>Informações da Turma
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-<?php echo $bimestre ? '5' : '4'; ?> gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Escola</p>
                        <p class="text-lg font-semibold"><?php echo htmlspecialchars($escola['nome']); ?></p>
                    </div>
                    <?php if ($serie): ?>
                    <div>
                        <p class="text-sm text-gray-600">Série</p>
                        <p class="text-lg font-semibold"><?php echo htmlspecialchars($serie['nome_serie']); ?></p>
                    </div>
                    <?php endif; ?>
                    <div>
                        <p class="text-sm text-gray-600">Turma</p>
                        <p class="text-lg font-semibold"><?php echo htmlspecialchars($turma['nome_turma']); ?></p>
                    </div>
                    <?php if ($bimestre): ?>
                    <div>
                        <p class="text-sm text-gray-600">Bimestre</p>
                        <p class="text-lg font-semibold text-teal-700"><?php echo $bimestre; ?>º Bimestre</p>
                    </div>
                    <?php endif; ?>
                    <div>
                        <p class="text-sm text-gray-600">Ano Letivo</p>
                        <p class="text-lg font-semibold"><?php echo $ano_letivo; ?></p>
                    </div>
                </div>
            </div>

            <!-- Informações Gerais -->
            <div class="bg-teal-50 border-2 border-teal-300 rounded-lg p-6 mb-6">
                <h2 class="text-xl font-bold text-teal-800 mb-4">
                    <i class="fas fa-users mr-2"></i>Informações Gerais
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="bg-white p-4 rounded-lg border border-teal-200">
                        <p class="text-sm text-gray-600">Número Total de Alunos</p>
                        <p class="text-3xl font-bold text-teal-700"><?php echo $dados['total_alunos'] ?? 0; ?></p>
                    </div>
                    <div class="bg-white p-4 rounded-lg border border-teal-200">
                        <p class="text-sm text-gray-600">Alunos com Necessidades Especiais</p>
                        <p class="text-3xl font-bold text-teal-700">
                            <?php 
                            echo $dados['alunos_necessidades_especiais'] ?? 
                                 $dados['necessidades_especiais'] ?? 
                                 $dados['alunos_com_laudo'] ?? 0; 
                            ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Dados Específicos por Tipo -->
            <?php
            // Remover campos que não são dados do formulário
            $campos_ignorar = ['id', 'escola_id', 'serie_id', 'turma_id', 'ano_letivo', 'total_alunos', 
                              'alunos_necessidades_especiais', 'necessidades_especiais', 'alunos_com_laudo', 
                              'created_at', 'updated_at'];
            
            $dados_filtrados = array_filter($dados, function($key) use ($campos_ignorar) {
                return !in_array($key, $campos_ignorar);
            }, ARRAY_FILTER_USE_KEY);
            ?>

            <div class="bg-white border-2 border-gray-300 rounded-lg p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4">
                    <i class="fas fa-chart-bar mr-2"></i>Dados do Condensado
                </h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php foreach ($dados_filtrados as $campo => $valor): ?>
                    <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                        <p class="text-sm text-gray-600 mb-1">
                            <?php 
                            // Formatar nome do campo
                            $nome_formatado = ucfirst(str_replace('_', ' ', $campo));
                            echo htmlspecialchars($nome_formatado); 
                            ?>
                        </p>
                        <p class="text-2xl font-bold text-gray-800"><?php echo $valor ?? 0; ?></p>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Botões de Ação -->
            <div class="mt-6 flex gap-4 print:hidden">
                <a href="?page=relatorios&tipo=<?php echo $tipo_relatorio; ?>&escola=<?php echo $escola_id; ?>&serie=<?php echo $serie_id; ?>&turma=<?php echo $turma_id; ?>&ano_letivo=<?php echo $ano_letivo; ?>" 
                   class="bg-gray-600 text-white px-6 py-3 rounded-md font-semibold hover:bg-gray-700">
                    <i class="fas fa-arrow-left mr-2"></i>Voltar
                </a>
                <a href="?page=relatorio_pdf&tipo=<?php echo $tipo_relatorio; ?>&escola=<?php echo $escola_id; ?>&serie=<?php echo $serie_id; ?>&turma=<?php echo $turma_id; ?>&ano_letivo=<?php echo $ano_letivo; ?>" 
                   target="_blank"
                   class="bg-red-600 text-white px-6 py-3 rounded-md font-semibold hover:bg-red-700">
                    <i class="fas fa-file-pdf mr-2"></i>Baixar PDF
                </a>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    body * {
        visibility: hidden;
    }
    .container, .container * {
        visibility: visible;
    }
    .container {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
}
</style>
