<!-- Configurações do Sistema -->
<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Criar tabela de configurações se não existir
$pdo->exec("CREATE TABLE IF NOT EXISTS configuracoes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        chave VARCHAR(100) NOT NULL UNIQUE,
        valor TEXT,
        descricao TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");
    
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}

// Processar salvamento das configurações
if ($_POST && isset($_POST['save_settings'])) {
    
    // Processar upload de logo
    if (isset($_FILES['logo_file']) && $_FILES['logo_file']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = dirname(__DIR__, 2) . '/uploads/system/';
        $fileName = 'logo_' . time() . '_' . $_FILES['logo_file']['name'];
        $uploadPath = $uploadDir . $fileName;
        
        // Criar diretório se não existir
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        // Verificar tipo de arquivo
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
        if (in_array($_FILES['logo_file']['type'], $allowedTypes)) {
            if (move_uploaded_file($_FILES['logo_file']['tmp_name'], $uploadPath)) {
                $_POST['logo_url'] = '../uploads/system/' . $fileName;
                echo '<div class="mb-6 p-4 bg-green-100 text-green-700 rounded-lg">
                        <i class="fas fa-check-circle mr-2"></i>
                        Logo enviado com sucesso!
                      </div>';
            } else {
                echo '<div class="mb-6 p-4 bg-red-100 text-red-700 rounded-lg">
                        <i class="fas fa-exclamation-circle mr-2"></i>
                        Erro ao enviar logo!
                      </div>';
            }
        } else {
            echo '<div class="mb-6 p-4 bg-red-100 text-red-700 rounded-lg">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    Tipo de arquivo não permitido! Use apenas JPG, PNG, GIF ou WebP.
                  </div>';
        }
    }
    
    // Processar upload de favicon
    if (isset($_FILES['favicon_file']) && $_FILES['favicon_file']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = dirname(__DIR__, 2) . '/uploads/system/';
        $fileName = 'favicon_' . time() . '_' . $_FILES['favicon_file']['name'];
        $uploadPath = $uploadDir . $fileName;
        
        // Criar diretório se não existir
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
        
        // Verificar tipo de arquivo
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'image/x-icon', 'image/vnd.microsoft.icon'];
        if (in_array($_FILES['favicon_file']['type'], $allowedTypes)) {
            if (move_uploaded_file($_FILES['favicon_file']['tmp_name'], $uploadPath)) {
                $_POST['favicon_url'] = '../uploads/system/' . $fileName;
                echo '<div class="mb-6 p-4 bg-green-100 text-green-700 rounded-lg">
                        <i class="fas fa-check-circle mr-2"></i>
                        Favicon enviado com sucesso!
                      </div>';
            } else {
                echo '<div class="mb-6 p-4 bg-red-100 text-red-700 rounded-lg">
                        <i class="fas fa-exclamation-circle mr-2"></i>
                        Erro ao enviar favicon!
                      </div>';
            }
        } else {
            echo '<div class="mb-6 p-4 bg-red-100 text-red-700 rounded-lg">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    Tipo de arquivo não permitido para favicon!
                  </div>';
        }
    }
    
    // Atualizar configurações na tabela
    $stmt = $pdo->prepare("UPDATE configuracoes SET 
        titulo_site = ?, 
        descricao_site = ?, 
        logo_url = ?, 
        favicon_url = ?, 
        cor_primaria = ?, 
        cor_secundaria = ?, 
        cor_texto = ?, 
        cor_fundo = ? 
        WHERE id = 1");
    
    $stmt->execute([
        $_POST['titulo_site'] ?? '',
        $_POST['descricao_site'] ?? '',
        $_POST['logo_url'] ?? '',
        $_POST['favicon_url'] ?? '',
        $_POST['cor_primaria'] ?? '#3b82f6',
        $_POST['cor_secundaria'] ?? '#10b981',
        $_POST['cor_texto'] ?? '#374151',
        $_POST['cor_fundo'] ?? '#f9fafb'
    ]);
    
    echo '<div class="mb-6 p-4 bg-green-100 text-green-700 rounded-lg">
            <i class="fas fa-check-circle mr-2"></i>
            Configurações salvas com sucesso!
          </div>';
}

// Buscar configurações
$config = null;
$stmt = $pdo->query("SELECT * FROM configuracoes WHERE id = 1");
$config = $stmt->fetch(PDO::FETCH_ASSOC);

// Se não existir registro, criar um padrão
if (!$config) {
    $stmt = $pdo->prepare("INSERT INTO configuracoes (
        titulo_site, descricao_site, cor_primaria, cor_secundaria, cor_texto, cor_fundo
    ) VALUES (?, ?, ?, ?, ?, ?)");
    
    $stmt->execute([
        'SIMAE Admin',
        'Sistema de Administração',
        '#3b82f6',
        '#10b981',
        '#374151',
        '#f9fafb'
    ]);
    
    // Buscar novamente
    $stmt = $pdo->query("SELECT * FROM configuracoes WHERE id = 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<div class="max-w-4xl">
    <div class="bg-white shadow rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Configurações do Sistema</h3>
            <p class="mt-1 text-sm text-gray-500">Personalize a aparência e configurações gerais do sistema.</p>
        </div>
        
        <form method="POST" enctype="multipart/form-data" class="p-6 space-y-6">
            <!-- Configurações Gerais -->
            <div>
                <h4 class="text-md font-medium text-gray-900 mb-4">Informações Gerais</h4>
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Título do Sistema</label>
                        <input type="text" name="titulo_site" value="<?php echo htmlspecialchars($config['titulo_site'] ?? ''); ?>" 
                               class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                        <p class="mt-1 text-xs text-gray-500">Nome que aparecerá no cabeçalho do sistema</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Descrição do Sistema</label>
                        <input type="text" name="descricao_site" value="<?php echo htmlspecialchars($config['descricao_site'] ?? ''); ?>" 
                               class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                </div>
            </div>
            
            <!-- Upload de Imagens -->
            <div>
                <h4 class="text-md font-medium text-gray-900 mb-4">Imagens do Sistema</h4>
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Logo do Sistema</label>
                        <div class="mt-1 space-y-2">
                            <!-- Preview do logo atual -->
                            <?php if (!empty($config['logo_url'])): ?>
                            <div class="flex items-center space-x-3">
                                <img src="<?php echo htmlspecialchars($config['logo_url']); ?>" 
                                     alt="Logo atual" class="h-12 w-auto border border-gray-300 rounded">
                                <span class="text-sm text-gray-500">Logo atual</span>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Upload de novo logo -->
                            <div>
                                <input type="file" name="logo_file" accept="image/*" 
                                       class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-50 file:text-primary-700 hover:file:bg-primary-100">
                                <p class="mt-1 text-xs text-gray-500">JPG, PNG, GIF ou WebP (máx. 2MB)</p>
                            </div>
                            
                            <!-- URL manual (alternativa) -->
                            <div>
                                <label class="text-xs text-gray-500">Ou insira URL manual:</label>
                                <input type="url" name="logo_url" value="<?php echo htmlspecialchars($config['logo_url'] ?? ''); ?>" 
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 text-sm">
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Favicon</label>
                        <div class="mt-1 space-y-2">
                            <!-- Preview do favicon atual -->
                            <?php if (!empty($config['favicon_url'])): ?>
                            <div class="flex items-center space-x-3">
                                <img src="<?php echo htmlspecialchars($config['favicon_url']); ?>" 
                                     alt="Favicon atual" class="h-8 w-8 border border-gray-300 rounded">
                                <span class="text-sm text-gray-500">Favicon atual</span>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Upload de novo favicon -->
                            <div>
                                <input type="file" name="favicon_file" accept="image/*" 
                                       class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary-50 file:text-primary-700 hover:file:bg-primary-100">
                                <p class="mt-1 text-xs text-gray-500">ICO, PNG (16x16 ou 32x32 pixels)</p>
                            </div>
                            
                            <!-- URL manual (alternativa) -->
                            <div>
                                <label class="text-xs text-gray-500">Ou insira URL manual:</label>
                                <input type="url" name="favicon_url" value="<?php echo htmlspecialchars($config['favicon_url'] ?? ''); ?>" 
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500 text-sm">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Configurações Visuais -->
            <div class="border-t border-gray-200 pt-6">
                <h4 class="text-md font-medium text-gray-900 mb-4">Aparência</h4>
                <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Cor Primária</label>
                        <div class="mt-1 flex items-center space-x-3">
                            <input type="color" name="cor_primaria" value="<?php echo $config['cor_primaria'] ?? '#3b82f6'; ?>" 
                                   class="h-10 w-20 border border-gray-300 rounded-md">
                            <input type="text" value="<?php echo $config['cor_primaria'] ?? '#3b82f6'; ?>" 
                                   class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500"
                                   readonly>
                        </div>
                        <p class="mt-1 text-xs text-gray-500">Cor principal dos elementos da interface</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Cor Secundária</label>
                        <div class="mt-1 flex items-center space-x-3">
                            <input type="color" name="cor_secundaria" value="<?php echo $config['cor_secundaria'] ?? '#10b981'; ?>" 
                                   class="h-10 w-20 border border-gray-300 rounded-md">
                            <input type="text" value="<?php echo $config['cor_secundaria'] ?? '#10b981'; ?>" 
                                   class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500"
                                   readonly>
                        </div>
                        <p class="mt-1 text-xs text-gray-500">Cor para destaques e botões secundários</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Cor do Texto</label>
                        <div class="mt-1 flex items-center space-x-3">
                            <input type="color" name="cor_texto" value="<?php echo $config['cor_texto'] ?? '#374151'; ?>" 
                                   class="h-10 w-20 border border-gray-300 rounded-md">
                            <input type="text" value="<?php echo $config['cor_texto'] ?? '#374151'; ?>" 
                                   class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500"
                                   readonly>
                        </div>
                        <p class="mt-1 text-xs text-gray-500">Cor principal do texto</p>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Cor de Fundo</label>
                        <div class="mt-1 flex items-center space-x-3">
                            <input type="color" name="cor_fundo" value="<?php echo $config['cor_fundo'] ?? '#f9fafb'; ?>" 
                                   class="h-10 w-20 border border-gray-300 rounded-md">
                            <input type="text" value="<?php echo $config['cor_fundo'] ?? '#f9fafb'; ?>" 
                                   class="flex-1 border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500"
                                   readonly>
                        </div>
                        <p class="mt-1 text-xs text-gray-500">Cor de fundo das páginas</p>
                    </div>
                </div>
            </div>

            <!-- Preview -->
            <div class="border-t border-gray-200 pt-6">
                <h4 class="text-md font-medium text-gray-900 mb-4">Preview das Cores</h4>
                <div class="flex space-x-4" id="colorPreview">
                    <div class="flex-1 p-4 rounded-lg text-white" style="background-color: <?php echo $config['cor_primaria'] ?? '#3b82f6'; ?>">
                        <h5 class="font-medium">Cor Primária</h5>
                        <p class="text-sm opacity-90">Botões principais, links, destaques</p>
                    </div>
                    <div class="flex-1 p-4 rounded-lg text-white" style="background-color: <?php echo $config['cor_secundaria'] ?? '#10b981'; ?>">
                        <h5 class="font-medium">Cor Secundária</h5>
                        <p class="text-sm opacity-90">Hover states, elementos secundários</p>
                    </div>
                </div>
            </div>

            <div class="flex justify-end space-x-3 border-t border-gray-200 pt-6">
                <button type="button" onclick="resetSettings()" class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                    Restaurar Padrões
                </button>
                <button type="submit" name="save_settings" class="px-4 py-2 bg-primary-600 border border-transparent rounded-md text-sm font-medium text-white hover:bg-primary-700">
                    <i class="fas fa-save mr-2"></i>
                    Salvar Configurações
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Atualizar preview das cores em tempo real
document.addEventListener('DOMContentLoaded', function() {
    const primaryColorInput = document.querySelector('input[name="cor_primaria"]');
    const secondaryColorInput = document.querySelector('input[name="cor_secundaria"]');
    const preview = document.getElementById('colorPreview');
    
    function updatePreview() {
        const primaryColor = primaryColorInput.value;
        const secondaryColor = secondaryColorInput.value;
        
        // Atualizar os campos de texto
        primaryColorInput.nextElementSibling.value = primaryColor;
        secondaryColorInput.nextElementSibling.value = secondaryColor;
        
        // Atualizar preview
        preview.children[0].style.backgroundColor = primaryColor;
        preview.children[1].style.backgroundColor = secondaryColor;
    }
    
    primaryColorInput.addEventListener('change', updatePreview);
    secondaryColorInput.addEventListener('change', updatePreview);
});

function resetSettings() {
    if (confirm('Tem certeza que deseja restaurar as configurações padrão?')) {
        document.querySelector('input[name="titulo_site"]').value = 'SIMAE';
        document.querySelector('input[name="descricao_site"]').value = 'Sistema de Administração';
        document.querySelector('input[name="cor_primaria"]').value = '#3b82f6';
        document.querySelector('input[name="cor_secundaria"]').value = '#10b981';
        document.querySelector('input[name="cor_texto"]').value = '#374151';
        document.querySelector('input[name="cor_fundo"]').value = '#f9fafb';
        document.querySelector('input[name="logo_url"]').value = '';
        document.querySelector('input[name="favicon_url"]').value = '';
        
        // Atualizar preview
        document.getElementById('colorPreview').children[0].style.backgroundColor = '#3b82f6';
        document.getElementById('colorPreview').children[1].style.backgroundColor = '#10b981';
        
        // Atualizar campos de texto das cores
        document.querySelector('input[name="cor_primaria"]').nextElementSibling.value = '#3b82f6';
        document.querySelector('input[name="cor_secundaria"]').nextElementSibling.value = '#10b981';
    }
}
</script>