<!-- Gerenciamento de Usuários -->
<?php
// Carrega configurações e inicia sessão
require_once __DIR__ . '/../includes/init.php';

// Processar ações
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create':
                $nome = $_POST['nome'];
                $email = $_POST['email'];
                $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
                $nivel = $_POST['nivel'];
                
                $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, nivel, ativo) VALUES (?, ?, ?, ?, 1)");
                if ($stmt->execute([$nome, $email, $senha, $nivel])) {
                    echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Usuário criado com sucesso!</div>';
                }
                break;
                
            case 'update':
                $id = $_POST['id'];
                $nome = $_POST['nome'];
                $email = $_POST['email'];
                $nivel = $_POST['nivel'];
                $ativo = $_POST['ativo'];
                
                if (!empty($_POST['senha'])) {
                    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
                    $stmt = $pdo->prepare("UPDATE usuarios SET nome = ?, email = ?, senha = ?, nivel = ?, ativo = ? WHERE id = ?");
                    $stmt->execute([$nome, $email, $senha, $nivel, $ativo, $id]);
                } else {
                    $stmt = $pdo->prepare("UPDATE usuarios SET nome = ?, email = ?, nivel = ?, ativo = ? WHERE id = ?");
                    $stmt->execute([$nome, $email, $nivel, $ativo, $id]);
                }
                echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Usuário atualizado com sucesso!</div>';
                break;
                
            case 'delete':
                $id = $_POST['id'];
                $stmt = $pdo->prepare("DELETE FROM usuarios WHERE id = ? AND id != 1"); // Proteger admin principal
                if ($stmt->execute([$id])) {
                    echo '<div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">Usuário excluído com sucesso!</div>';
                }
                break;
        }
    }
}

$editUser = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$_GET['edit']]);
    $editUser = $stmt->fetch();
}
?>

<div class="flex justify-between items-center mb-6">
    <h2 class="text-xl font-semibold text-gray-900">Lista de Usuários</h2>
    <button onclick="openModal()" class="bg-primary-600 text-white px-4 py-2 rounded-lg hover:bg-primary-700">
        <i class="fas fa-plus mr-2"></i>Novo Usuário
    </button>
</div>

<!-- Tabela de Usuários -->
<div class="bg-white shadow overflow-hidden sm:rounded-md">
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Usuário</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nível</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Último Login</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Ações</th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            <?php
            $stmt = $pdo->query("SELECT * FROM usuarios ORDER BY nome");
            while ($user = $stmt->fetch()):
            ?>
            <tr>
                <td class="px-6 py-4 whitespace-nowrap">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 h-10 w-10">
                            <div class="h-10 w-10 rounded-full bg-primary-600 text-white flex items-center justify-center">
                                <?php echo strtoupper(substr($user['nome'], 0, 1)); ?>
                            </div>
                        </div>
                        <div class="ml-4">
                            <div class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user['nome']); ?></div>
                        </div>
                    </div>
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($user['email']); ?></td>
                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                    <?php 
                    switch($user['nivel']) {
                        case 9: echo '<span class="px-2 py-1 text-xs bg-red-100 text-red-800 rounded-full">Administrador</span>'; break;
                        case 5: echo '<span class="px-2 py-1 text-xs bg-yellow-100 text-yellow-800 rounded-full">Gerente</span>'; break;
                        default: echo '<span class="px-2 py-1 text-xs bg-blue-100 text-blue-800 rounded-full">Usuário</span>'; break;
                    }
                    ?>
                </td>
                <td class="px-6 py-4 whitespace-nowrap">
                    <?php if ($user['ativo']): ?>
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Ativo</span>
                    <?php else: ?>
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">Inativo</span>
                    <?php endif; ?>
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                    <?php echo $user['ultimo_login'] ? date('d/m/Y H:i', strtotime($user['ultimo_login'])) : 'Nunca'; ?>
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                    <button onclick="editUser(<?php echo $user['id']; ?>)" class="text-indigo-600 hover:text-indigo-900 mr-3">
                        <i class="fas fa-edit"></i>
                    </button>
                    <?php if ($user['id'] != 1): // Proteger admin principal ?>
                    <button onclick="deleteUser(<?php echo $user['id']; ?>)" class="text-red-600 hover:text-red-900">
                        <i class="fas fa-trash"></i>
                    </button>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- Modal -->
<div id="userModal" class="fixed inset-0 z-50 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" onclick="closeModal()"></div>
        <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
            <form id="userForm" method="POST">
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4" id="modalTitle">Novo Usuário</h3>
                    
                    <input type="hidden" name="action" id="formAction" value="create">
                    <input type="hidden" name="id" id="userId">
                    
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Nome</label>
                        <input type="text" name="nome" id="userName" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Email</label>
                        <input type="email" name="email" id="userEmail" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Senha <span id="passwordNote" class="text-gray-500">(deixe em branco para manter a atual)</span></label>
                        <input type="password" name="senha" id="userPassword" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700">Nível</label>
                        <select name="nivel" id="userLevel" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                            <option value="1">Usuário</option>
                            <option value="5">Gerente</option>
                            <option value="9">Administrador</option>
                        </select>
                    </div>
                    
                    <div class="mb-4" id="statusField" style="display: none;">
                        <label class="block text-sm font-medium text-gray-700">Status</label>
                        <select name="ativo" id="userStatus" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring-primary-500 focus:border-primary-500">
                            <option value="1">Ativo</option>
                            <option value="0">Inativo</option>
                        </select>
                    </div>
                </div>
                
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="submit" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-primary-600 text-base font-medium text-white hover:bg-primary-700 focus:outline-none sm:ml-3 sm:w-auto sm:text-sm">
                        Salvar
                    </button>
                    <button type="button" onclick="closeModal()" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                        Cancelar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openModal() {
    document.getElementById('userModal').classList.remove('hidden');
    document.getElementById('modalTitle').textContent = 'Novo Usuário';
    document.getElementById('formAction').value = 'create';
    document.getElementById('userForm').reset();
    document.getElementById('passwordNote').style.display = 'none';
    document.getElementById('statusField').style.display = 'none';
    document.getElementById('userPassword').required = true;
}

function closeModal() {
    document.getElementById('userModal').classList.add('hidden');
}

function editUser(id) {
    fetch(`api/user.php?id=${id}`)
        .then(response => response.json())
        .then(user => {
            document.getElementById('userModal').classList.remove('hidden');
            document.getElementById('modalTitle').textContent = 'Editar Usuário';
            document.getElementById('formAction').value = 'update';
            document.getElementById('userId').value = user.id;
            document.getElementById('userName').value = user.nome;
            document.getElementById('userEmail').value = user.email;
            document.getElementById('userLevel').value = user.nivel;
            document.getElementById('userStatus').value = user.ativo;
            document.getElementById('passwordNote').style.display = 'inline';
            document.getElementById('statusField').style.display = 'block';
            document.getElementById('userPassword').required = false;
        });
}

function deleteUser(id) {
    if (confirm('Tem certeza que deseja excluir este usuário?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="action" value="delete">
            <input type="hidden" name="id" value="${id}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>