<?php
// Arquivo base para todas as páginas
if (!defined('BASEPATH')) {
    define('BASEPATH', true);
}

// Iniciar sessão se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Função para redirecionamento seguro
function redirect($path) {
    header('Location: /simae/' . ltrim($path, '/'));
    exit;
}

// Função para verificar se está logado
function is_logged_in() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

// Função para garantir que usuário está logado
function require_login() {
    if (!is_logged_in()) {
        redirect('admin/login');
    }
}

// Função para renderizar uma view
function view($view_name, $data = []) {
    extract($data);
    require __DIR__ . '/views/' . $view_name . '.php';
}