<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Configuracoes extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->library('Auth_lib');
        
        // Verifica se está logado
        $this->auth_lib->verificar_login();
        
        // Verifica permissão de administrador
        $this->auth_lib->verificar_permissao(9);
    }

    public function index()
    {
        $data = array(
            'titulo' => 'Configurações - Painel Administrativo SIMAE',
            'usuario_logado' => $this->auth_lib->usuario()
        );

        $this->load->view('admin/layout/header', $data);
        $this->load->view('admin/configuracoes/index', $data);
        $this->load->view('admin/layout/footer');
    }
}