<?php

class Dashboard extends Controller {

    public function __construct()
    {
        parent::__construct();
        
        // Verifica se está logado
        if (!isset($_SESSION['admin_logado']) || $_SESSION['admin_logado'] !== true) {
            redirect('admin/login');
        }
    }

    /**
     * Página principal do dashboard
     */
    public function index()
    {
        $usuario_logado = (object) $_SESSION['admin_usuario'];
        
        $data = array(
            'titulo' => 'Dashboard - Painel Administrativo SIMAE',
            'usuario_logado' => $usuario_logado,
            'estatisticas' => $this->obter_estatisticas(),
            'atividades_recentes' => $this->obter_atividades_recentes()
        );

        $this->load_view('admin/layout/header', $data);
        $this->load_view('admin/dashboard', $data);
        $this->load_view('admin/layout/footer');
    }

    /**
     * Obtém estatísticas para o dashboard
     */
    private function obter_estatisticas()
    {
        $stats = array();
        
        // Estatísticas de usuários
        $sql_total = "SELECT COUNT(*) as total FROM usuarios";
        $result_total = $this->db->query($sql_total);
        $total = $result_total->fetch_object()->total;
        
        $sql_ativos = "SELECT COUNT(*) as ativos FROM usuarios WHERE ativo = 1";
        $result_ativos = $this->db->query($sql_ativos);
        $ativos = $result_ativos->fetch_object()->ativos;
        
        $sql_inativos = "SELECT COUNT(*) as inativos FROM usuarios WHERE ativo = 0";
        $result_inativos = $this->db->query($sql_inativos);
        $inativos = $result_inativos->fetch_object()->inativos;
        
        $sql_recentes = "SELECT COUNT(*) as recentes FROM usuarios WHERE ultimo_login >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
        $result_recentes = $this->db->query($sql_recentes);
        $recentes = $result_recentes->fetch_object()->recentes;
        
        $stats['usuarios'] = array(
            'total' => $total,
            'ativos' => $ativos,
            'inativos' => $inativos,
            'ultimos_logins' => $recentes
        );
        
        // Outras estatísticas podem ser adicionadas aqui
        $stats['sistema'] = array(
            'uptime' => $this->calcular_uptime(),
            'versao' => '1.0.0',
            'php_version' => PHP_VERSION,
            'memoria_uso' => $this->formatarBytes(memory_get_usage(true))
        );
        
        return $stats;
    }

    /**
     * Obtém atividades recentes
     */
    private function obter_atividades_recentes()
    {
        // Simulação de atividades recentes
        // Em um sistema real, isso viria de uma tabela de logs
        return array(
            array(
                'usuario' => 'Admin',
                'acao' => 'Login realizado',
                'data' => date('Y-m-d H:i:s'),
                'tipo' => 'info'
            ),
            array(
                'usuario' => 'Sistema',
                'acao' => 'Backup automático executado',
                'data' => date('Y-m-d H:i:s', strtotime('-1 hour')),
                'tipo' => 'success'
            ),
            array(
                'usuario' => 'Admin',
                'acao' => 'Configurações atualizadas',
                'data' => date('Y-m-d H:i:s', strtotime('-2 hours')),
                'tipo' => 'warning'
            )
        );
    }

    /**
     * Calcula uptime do sistema
     */
    private function calcular_uptime()
    {
        return 'Sistema funcionando';
    }

    /**
     * Formata bytes em formato legível
     */
    private function formatarBytes($size, $precision = 2)
    {
        $base = log($size, 1024);
        $suffixes = array('B', 'KB', 'MB', 'GB', 'TB');
        return round(pow(1024, $base - floor($base)), $precision) . ' ' . $suffixes[floor($base)];
    }
}