<?php

class Login extends Controller {

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Página de login
     */
    public function index()
    {
        // Se já estiver logado, redireciona para dashboard
        if (isset($_SESSION['admin_logado']) && $_SESSION['admin_logado'] === true) {
            redirect('admin/dashboard');
        }

        // Processa o formulário de login
        if ($_POST) {
            $this->processar_login();
        }

        // Carrega a view de login
        $data = array(
            'titulo' => 'Login - Painel Administrativo SIMAE',
            'erro' => isset($_SESSION['_flash_erro']) ? $_SESSION['_flash_erro'] : null,
            'sucesso' => isset($_SESSION['_flash_sucesso']) ? $_SESSION['_flash_sucesso'] : null
        );
        
        // Limpar mensagens flash
        unset($_SESSION['_flash_erro']);
        unset($_SESSION['_flash_sucesso']);

        $this->load_view('admin/login', $data);
    }

    /**
     * Processa o formulário de login
     */
    private function processar_login()
    {
        $email = isset($_POST['email']) ? trim($_POST['email']) : '';
        $senha = isset($_POST['senha']) ? $_POST['senha'] : '';

        // Validação básica
        if (empty($email) || empty($senha)) {
            $_SESSION['_flash_erro'] = 'Por favor, preencha todos os campos.';
            return;
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $_SESSION['_flash_erro'] = 'E-mail inválido.';
            return;
        }

        // Buscar usuário no banco
        $email_escaped = $this->db->escape($email);
        $sql = "SELECT * FROM usuarios WHERE email = '$email_escaped' AND ativo = 1";
        $result = $this->db->query($sql);

        if ($result->num_rows == 1) {
            $usuario = $result->fetch_object();
            
            // Verificar senha
            if (password_verify($senha, $usuario->senha)) {
                // Login bem-sucedido
                $_SESSION['admin_logado'] = true;
                $_SESSION['admin_usuario'] = array(
                    'id' => $usuario->id,
                    'nome' => $usuario->nome,
                    'email' => $usuario->email,
                    'nivel' => $usuario->nivel,
                    'ultimo_login' => $usuario->ultimo_login
                );
                
                // Atualizar último login
                $sql_update = "UPDATE usuarios SET ultimo_login = NOW() WHERE id = " . $usuario->id;
                $this->db->query($sql_update);
                
                $_SESSION['_flash_sucesso'] = 'Login realizado com sucesso!';
                redirect('admin/dashboard');
            } else {
                $_SESSION['_flash_erro'] = 'E-mail ou senha inválidos.';
            }
        } else {
            $_SESSION['_flash_erro'] = 'E-mail ou senha inválidos.';
        }
    }

    /**
     * Logout do usuário
     */
    public function logout()
    {
        session_destroy();
        session_start();
        $_SESSION['_flash_sucesso'] = 'Logout realizado com sucesso!';
        redirect('admin/login');
    }
}