<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Relatorios extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->library('Auth_lib');
        
        // Verifica se está logado
        $this->auth_lib->verificar_login();
        
        // Verifica permissão mínima de supervisor
        $this->auth_lib->verificar_permissao(5);
    }

    public function index()
    {
        $data = array(
            'titulo' => 'Relatórios - Painel Administrativo SIMAE',
            'usuario_logado' => $this->auth_lib->usuario()
        );

        $this->load->view('admin/layout/header', $data);
        $this->load->view('admin/relatorios/index', $data);
        $this->load->view('admin/layout/footer');
    }
}