<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sistema extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->library('Auth_lib');
        
        // Verifica se está logado
        $this->auth_lib->verificar_login();
        
        // Verifica permissão de administrador
        $this->auth_lib->verificar_permissao(9);
    }

    public function index()
    {
        $data = array(
            'titulo' => 'Sistema - Painel Administrativo SIMAE',
            'usuario_logado' => $this->auth_lib->usuario(),
            'info_sistema' => $this->obter_info_sistema()
        );

        $this->load->view('admin/layout/header', $data);
        $this->load->view('admin/sistema/index', $data);
        $this->load->view('admin/layout/footer');
    }

    private function obter_info_sistema()
    {
        return array(
            'versao_php' => PHP_VERSION,
            'versao_sistema' => '1.0.0',
            'servidor' => $_SERVER['SERVER_SOFTWARE'],
            'memoria_limite' => ini_get('memory_limit'),
            'tempo_execucao' => ini_get('max_execution_time'),
            'upload_max' => ini_get('upload_max_filesize'),
            'timezone' => date_default_timezone_get()
        );
    }
}