<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth_lib {

    protected $CI;

    public function __construct()
    {
        $this->CI =& get_instance();
        $this->CI->load->model('Usuario_model');
    }

    /**
     * Verifica se o usuário está logado
     */
    public function logado()
    {
        return $this->CI->session->userdata('admin_logado') === TRUE;
    }

    /**
     * Obtém dados do usuário logado
     */
    public function usuario()
    {
        if ($this->logado()) {
            return $this->CI->session->userdata('admin_usuario');
        }
        return false;
    }

    /**
     * Obtém ID do usuário logado
     */
    public function usuario_id()
    {
        $usuario = $this->usuario();
        return $usuario ? $usuario->id : false;
    }

    /**
     * Realiza login do usuário
     */
    public function login($email, $senha)
    {
        $usuario = $this->CI->Usuario_model->validar_login($email, $senha);
        
        if ($usuario) {
            $dados_sessao = array(
                'admin_logado' => TRUE,
                'admin_usuario' => $usuario
            );
            
            $this->CI->session->set_userdata($dados_sessao);
            return true;
        }
        
        return false;
    }

    /**
     * Realiza logout do usuário
     */
    public function logout()
    {
        $this->CI->session->unset_userdata('admin_logado');
        $this->CI->session->unset_userdata('admin_usuario');
        $this->CI->session->sess_destroy();
    }

    /**
     * Redireciona para login se não estiver logado
     */
    public function verificar_login()
    {
        if (!$this->logado()) {
            redirect('admin/login');
        }
    }

    /**
     * Verifica se usuário tem permissão de nível
     */
    public function tem_permissao($nivel_minimo)
    {
        if (!$this->logado()) {
            return false;
        }
        
        $usuario = $this->usuario();
        return $usuario->nivel >= $nivel_minimo;
    }

    /**
     * Redireciona se não tiver permissão
     */
    public function verificar_permissao($nivel_minimo)
    {
        if (!$this->tem_permissao($nivel_minimo)) {
            show_error('Acesso negado. Você não tem permissão para acessar esta área.', 403);
        }
    }
}