<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuario_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Valida as credenciais do usuário
     */
    public function validar_login($email, $senha)
    {
        // Busca o usuário pelo email
        $this->db->where('email', $email);
        $this->db->where('ativo', 1);
        $query = $this->db->get('usuarios');
        
        if ($query->num_rows() == 1) {
            $usuario = $query->row();
            
            // Verifica se a senha está correta
            if (password_verify($senha, $usuario->senha)) {
                // Atualiza o último login
                $this->atualizar_ultimo_login($usuario->id);
                
                // Remove a senha dos dados retornados
                unset($usuario->senha);
                return $usuario;
            }
        }
        
        return false;
    }

    /**
     * Busca usuário por ID
     */
    public function buscar_por_id($id)
    {
        $this->db->where('id', $id);
        $this->db->where('ativo', 1);
        $query = $this->db->get('usuarios');
        
        if ($query->num_rows() == 1) {
            $usuario = $query->row();
            unset($usuario->senha);
            return $usuario;
        }
        
        return false;
    }

    /**
     * Lista todos os usuários
     */
    public function listar_usuarios($limit = null, $offset = null)
    {
        $this->db->select('id, nome, email, nivel, ativo, criado_em, ultimo_login');
        $this->db->order_by('nome', 'ASC');
        
        if ($limit) {
            $this->db->limit($limit, $offset);
        }
        
        $query = $this->db->get('usuarios');
        return $query->result();
    }

    /**
     * Conta total de usuários
     */
    public function contar_usuarios()
    {
        return $this->db->count_all('usuarios');
    }

    /**
     * Insere novo usuário
     */
    public function inserir_usuario($dados)
    {
        // Criptografa a senha
        $dados['senha'] = password_hash($dados['senha'], PASSWORD_DEFAULT);
        $dados['criado_em'] = date('Y-m-d H:i:s');
        
        return $this->db->insert('usuarios', $dados);
    }

    /**
     * Atualiza usuário
     */
    public function atualizar_usuario($id, $dados)
    {
        // Se há senha, criptografar
        if (isset($dados['senha']) && !empty($dados['senha'])) {
            $dados['senha'] = password_hash($dados['senha'], PASSWORD_DEFAULT);
        } else {
            unset($dados['senha']);
        }
        
        $dados['atualizado_em'] = date('Y-m-d H:i:s');
        
        $this->db->where('id', $id);
        return $this->db->update('usuarios', $dados);
    }

    /**
     * Remove usuário (marca como inativo)
     */
    public function remover_usuario($id)
    {
        $dados = array(
            'ativo' => 0,
            'atualizado_em' => date('Y-m-d H:i:s')
        );
        
        $this->db->where('id', $id);
        return $this->db->update('usuarios', $dados);
    }

    /**
     * Atualiza último login do usuário
     */
    private function atualizar_ultimo_login($id)
    {
        $dados = array(
            'ultimo_login' => date('Y-m-d H:i:s')
        );
        
        $this->db->where('id', $id);
        $this->db->update('usuarios', $dados);
    }

    /**
     * Verifica se email já existe
     */
    public function email_existe($email, $excluir_id = null)
    {
        $this->db->where('email', $email);
        
        if ($excluir_id) {
            $this->db->where('id !=', $excluir_id);
        }
        
        $query = $this->db->get('usuarios');
        return ($query->num_rows() > 0);
    }

    /**
     * Busca estatísticas dos usuários
     */
    public function estatisticas_usuarios()
    {
        $stats = array();
        
        // Total de usuários
        $stats['total'] = $this->db->count_all('usuarios');
        
        // Usuários ativos
        $this->db->where('ativo', 1);
        $stats['ativos'] = $this->db->count_all_results('usuarios');
        
        // Usuários inativos
        $this->db->where('ativo', 0);
        $stats['inativos'] = $this->db->count_all_results('usuarios');
        
        // Últimos logins (7 dias)
        $this->db->where('ultimo_login >=', date('Y-m-d H:i:s', strtotime('-7 days')));
        $stats['ultimos_logins'] = $this->db->count_all_results('usuarios');
        
        return $stats;
    }
}