<div class="card">
    <div class="card-header">
        <i class="fas fa-cog"></i> Configurações do Sistema
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            
            <!-- Configurações Gerais -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-sliders-h"></i> Configurações Gerais
                </div>
                <div class="card-body">
                    <form id="configGerais">
                        <div class="form-group">
                            <label for="nome_sistema">Nome do Sistema</label>
                            <input type="text" id="nome_sistema" name="nome_sistema" class="form-control" value="SIMAE">
                        </div>
                        
                        <div class="form-group">
                            <label for="email_sistema">E-mail do Sistema</label>
                            <input type="email" id="email_sistema" name="email_sistema" class="form-control" value="admin@simae.com">
                        </div>
                        
                        <div class="form-group">
                            <label for="timezone">Fuso Horário</label>
                            <select id="timezone" name="timezone" class="form-control">
                                <option value="America/Sao_Paulo" selected>America/São Paulo</option>
                                <option value="America/New_York">America/New York</option>
                                <option value="Europe/London">Europe/London</option>
                            </select>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Salvar
                        </button>
                    </form>
                </div>
            </div>

            <!-- Configurações de Segurança -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-shield-alt"></i> Segurança
                </div>
                <div class="card-body">
                    <form id="configSeguranca">
                        <div class="form-group">
                            <label for="tempo_sessao">Tempo de Sessão (minutos)</label>
                            <input type="number" id="tempo_sessao" name="tempo_sessao" class="form-control" value="120" min="5" max="1440">
                        </div>
                        
                        <div class="form-group">
                            <label for="tentativas_login">Máx. Tentativas de Login</label>
                            <input type="number" id="tentativas_login" name="tentativas_login" class="form-control" value="5" min="3" max="10">
                        </div>
                        
                        <div class="form-group">
                            <label for="forca_senha">
                                <input type="checkbox" id="forca_senha" name="forca_senha" checked>
                                Exigir senha forte
                            </label>
                        </div>
                        
                        <div class="form-group">
                            <label for="dois_fatores">
                                <input type="checkbox" id="dois_fatores" name="dois_fatores">
                                Autenticação de dois fatores
                            </label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Salvar
                        </button>
                    </form>
                </div>
            </div>

            <!-- Configurações de E-mail -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-envelope"></i> Configurações de E-mail
                </div>
                <div class="card-body">
                    <form id="configEmail">
                        <div class="form-group">
                            <label for="smtp_host">Servidor SMTP</label>
                            <input type="text" id="smtp_host" name="smtp_host" class="form-control" placeholder="smtp.gmail.com">
                        </div>
                        
                        <div class="form-group">
                            <label for="smtp_porta">Porta SMTP</label>
                            <input type="number" id="smtp_porta" name="smtp_porta" class="form-control" value="587">
                        </div>
                        
                        <div class="form-group">
                            <label for="smtp_usuario">Usuário SMTP</label>
                            <input type="email" id="smtp_usuario" name="smtp_usuario" class="form-control">
                        </div>
                        
                        <div class="form-group">
                            <label for="smtp_senha">Senha SMTP</label>
                            <input type="password" id="smtp_senha" name="smtp_senha" class="form-control">
                        </div>
                        
                        <div class="form-group">
                            <label for="smtp_cripto">
                                <input type="checkbox" id="smtp_cripto" name="smtp_cripto" checked>
                                Usar criptografia (TLS)
                            </label>
                        </div>
                        
                        <div class="btn-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Salvar
                            </button>
                            <button type="button" class="btn btn-secondary" onclick="testarEmail()">
                                <i class="fas fa-paper-plane"></i> Testar
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Configurações de Backup -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-database"></i> Backup Automático
                </div>
                <div class="card-body">
                    <form id="configBackup">
                        <div class="form-group">
                            <label for="backup_ativo">
                                <input type="checkbox" id="backup_ativo" name="backup_ativo" checked>
                                Ativar backup automático
                            </label>
                        </div>
                        
                        <div class="form-group">
                            <label for="backup_frequencia">Frequência</label>
                            <select id="backup_frequencia" name="backup_frequencia" class="form-control">
                                <option value="diario" selected>Diário</option>
                                <option value="semanal">Semanal</option>
                                <option value="mensal">Mensal</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="backup_horario">Horário</label>
                            <input type="time" id="backup_horario" name="backup_horario" class="form-control" value="02:00">
                        </div>
                        
                        <div class="form-group">
                            <label for="backup_manter">Manter backups (dias)</label>
                            <input type="number" id="backup_manter" name="backup_manter" class="form-control" value="30" min="7" max="365">
                        </div>
                        
                        <div class="btn-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Salvar
                            </button>
                            <button type="button" class="btn btn-secondary" onclick="executarBackup()">
                                <i class="fas fa-download"></i> Backup Agora
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Manutenção do Sistema -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-wrench"></i> Manutenção do Sistema
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
            
            <button class="btn btn-warning" onclick="limparCache()">
                <i class="fas fa-broom"></i> Limpar Cache
            </button>
            
            <button class="btn btn-info" onclick="otimizarBanco()">
                <i class="fas fa-database"></i> Otimizar Banco
            </button>
            
            <button class="btn btn-secondary" onclick="limparLogs()">
                <i class="fas fa-file-alt"></i> Limpar Logs
            </button>
            
            <button class="btn btn-danger" onclick="modoManutencao()">
                <i class="fas fa-tools"></i> Modo Manutenção
            </button>
        </div>
    </div>
</div>

<script>
// Salvar configurações gerais
document.getElementById('configGerais').addEventListener('submit', function(e) {
    e.preventDefault();
    showLoading();
    
    // Simular salvamento
    setTimeout(function() {
        hideLoading();
        showSuccess('Configurações gerais salvas com sucesso!');
    }, 1000);
});

// Salvar configurações de segurança
document.getElementById('configSeguranca').addEventListener('submit', function(e) {
    e.preventDefault();
    showLoading();
    
    // Simular salvamento
    setTimeout(function() {
        hideLoading();
        showSuccess('Configurações de segurança salvas com sucesso!');
    }, 1000);
});

// Salvar configurações de e-mail
document.getElementById('configEmail').addEventListener('submit', function(e) {
    e.preventDefault();
    showLoading();
    
    // Simular salvamento
    setTimeout(function() {
        hideLoading();
        showSuccess('Configurações de e-mail salvas com sucesso!');
    }, 1000);
});

// Salvar configurações de backup
document.getElementById('configBackup').addEventListener('submit', function(e) {
    e.preventDefault();
    showLoading();
    
    // Simular salvamento
    setTimeout(function() {
        hideLoading();
        showSuccess('Configurações de backup salvas com sucesso!');
    }, 1000);
});

// Testar e-mail
function testarEmail() {
    showLoading();
    
    // Simular teste
    setTimeout(function() {
        hideLoading();
        showSuccess('E-mail de teste enviado com sucesso!');
    }, 2000);
}

// Executar backup
function executarBackup() {
    if (confirm('Deseja executar o backup agora?')) {
        showLoading();
        
        // Simular backup
        setTimeout(function() {
            hideLoading();
            showSuccess('Backup executado com sucesso!');
        }, 3000);
    }
}

// Limpar cache
function limparCache() {
    if (confirm('Deseja limpar o cache do sistema?')) {
        showLoading();
        
        setTimeout(function() {
            hideLoading();
            showSuccess('Cache limpo com sucesso!');
        }, 1500);
    }
}

// Otimizar banco
function otimizarBanco() {
    if (confirm('Deseja otimizar o banco de dados?')) {
        showLoading();
        
        setTimeout(function() {
            hideLoading();
            showSuccess('Banco de dados otimizado com sucesso!');
        }, 4000);
    }
}

// Limpar logs
function limparLogs() {
    if (confirm('Deseja limpar os logs do sistema?')) {
        showLoading();
        
        setTimeout(function() {
            hideLoading();
            showSuccess('Logs limpos com sucesso!');
        }, 1000);
    }
}

// Modo manutenção
function modoManutencao() {
    if (confirm('Deseja ativar o modo de manutenção? Isso impedirá o acesso de outros usuários.')) {
        showLoading();
        
        setTimeout(function() {
            hideLoading();
            showSuccess('Modo de manutenção ativado!');
        }, 1000);
    }
}
</script>