<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SIMAE - Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0fdf4',
                            100: '#dcfce7',
                            200: '#bbf7d0',
                            300: '#86efac',
                            400: '#4ade80',
                            500: '#22c55e',
                            600: '#16a34a',
                            700: '#15803d',
                            800: '#166534',
                            900: '#14532d',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Inter', sans-serif;
        }
        .gradient-bg {
            background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%);
        }
        .card-hover {
            transition: all 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-4px);
        }
        .animate-pulse-slow {
            animation: pulse 3s infinite;
        }
        .gradient-text {
            background: linear-gradient(135deg, #15803d, #22c55e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="gradient-bg min-h-screen">
    <!-- Header -->
    <header class="bg-gradient-to-r from-primary-600 to-primary-700 shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <!-- Logo e título -->
                <div class="flex items-center space-x-4">
                    <div class="bg-white bg-opacity-20 p-3 rounded-xl">
                        <i class="fas fa-shield-alt text-2xl text-white"></i>
                    </div>
                    <div>
                        <h1 class="text-2xl font-bold text-white">SIMAE</h1>
                        <p class="text-primary-100 text-sm">Sistema de Administração</p>
                    </div>
                </div>

                <!-- Informações do usuário -->
                <div class="flex items-center space-x-6">
                    <!-- Notificações -->
                    <button class="relative p-2 text-white hover:bg-white hover:bg-opacity-20 rounded-lg transition-colors duration-200">
                        <i class="fas fa-bell text-lg"></i>
                        <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center">3</span>
                    </button>

                    <!-- Perfil do usuário -->
                    <div class="flex items-center space-x-3 bg-white bg-opacity-10 rounded-xl px-4 py-2">
                        <div class="w-8 h-8 bg-white bg-opacity-20 rounded-lg flex items-center justify-center">
                            <i class="fas fa-user text-white text-sm"></i>
                        </div>
                        <div class="text-right">
                            <p class="text-white font-semibold text-sm"><?php echo $_SESSION['user_nome'] ?? 'Usuário'; ?></p>
                            <p class="text-primary-100 text-xs"><?php echo $_SESSION['user_email'] ?? ''; ?></p>
                        </div>
                    </div>

                    <!-- Botão de logout -->
                    <a 
                        href="/simae/admin/logout" 
                        onclick="return confirm('Tem certeza que deseja sair?')"
                        class="flex items-center space-x-2 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg transition-colors duration-200"
                    >
                        <i class="fas fa-sign-out-alt"></i>
                        <span class="hidden sm:inline">Sair</span>
                    </a>
                </div>
            </div>
        </div>
    </header>

    <!-- Conteúdo Principal -->
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Card de boas-vindas -->
        <div class="bg-white rounded-2xl shadow-lg p-8 mb-8 border border-primary-100">
            <div class="text-center">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-gradient-to-r from-primary-500 to-primary-600 rounded-2xl mb-4">
                    <i class="fas fa-chart-line text-white text-2xl"></i>
                </div>
                <h2 class="text-3xl font-bold gradient-text mb-2">Bem-vindo de volta!</h2>
                <p class="text-gray-600 text-lg">Gerencie seu sistema através do painel administrativo</p>
            </div>
        </div>

        <!-- Estatísticas -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <?php
            // Carrega configuração centralizada se não estiver carregada
            if (!defined('DB_HOST')) {
                require_once dirname(dirname(dirname(__DIR__))) . '/admin/config/database.php';
            }
            
            // Buscar estatísticas do banco
            try {
                $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
                $total_usuarios = 0;
                $usuarios_ativos = 0;
                $logins_recentes = 0;
                $usuarios_inativos = 0;

                if (!$conn->connect_error) {
                    $result = $conn->query("SELECT COUNT(*) as total FROM usuarios");
                    if ($result) $total_usuarios = $result->fetch_assoc()['total'];

                    $result = $conn->query("SELECT COUNT(*) as ativos FROM usuarios WHERE ativo = 1");
                    if ($result) $usuarios_ativos = $result->fetch_assoc()['ativos'];

                    $result = $conn->query("SELECT COUNT(*) as recentes FROM usuarios WHERE ultimo_login >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
                    if ($result) $logins_recentes = $result->fetch_assoc()['recentes'];

                    $result = $conn->query("SELECT COUNT(*) as inativos FROM usuarios WHERE ativo = 0");
                    if ($result) $usuarios_inativos = $result->fetch_assoc()['inativos'];

                    $conn->close();
                }
            } catch (Exception $e) {
                // Em caso de erro, usar valores padrão
            }
            ?>

            <!-- Card: Total de Usuários -->
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-primary-500 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-600 text-sm font-medium">Total de Usuários</p>
                        <p class="text-3xl font-bold text-gray-900 mt-1"><?php echo $total_usuarios; ?></p>
                    </div>
                    <div class="bg-primary-100 p-3 rounded-lg">
                        <i class="fas fa-users text-primary-600 text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center text-sm">
                    <i class="fas fa-arrow-up text-primary-500 mr-1"></i>
                    <span class="text-primary-600 font-medium">Sistema ativo</span>
                </div>
            </div>

            <!-- Card: Usuários Ativos -->
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-emerald-500 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-600 text-sm font-medium">Usuários Ativos</p>
                        <p class="text-3xl font-bold text-gray-900 mt-1"><?php echo $usuarios_ativos; ?></p>
                    </div>
                    <div class="bg-emerald-100 p-3 rounded-lg">
                        <i class="fas fa-user-check text-emerald-600 text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center text-sm">
                    <i class="fas fa-check-circle text-emerald-500 mr-1"></i>
                    <span class="text-emerald-600 font-medium">Online</span>
                </div>
            </div>

            <!-- Card: Logins Recentes -->
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-blue-500 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-600 text-sm font-medium">Logins (7 dias)</p>
                        <p class="text-3xl font-bold text-gray-900 mt-1"><?php echo $logins_recentes; ?></p>
                    </div>
                    <div class="bg-blue-100 p-3 rounded-lg">
                        <i class="fas fa-sign-in-alt text-blue-600 text-xl"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center text-sm">
                    <i class="fas fa-calendar text-blue-500 mr-1"></i>
                    <span class="text-blue-600 font-medium">Última semana</span>
                </div>
            </div>

            <!-- Card: Sistema -->
            <div class="bg-white rounded-xl shadow-lg p-6 border-l-4 border-amber-500 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-600 text-sm font-medium">Status do Sistema</p>
                        <p class="text-xl font-bold text-primary-600 mt-1">Online</p>
                    </div>
                    <div class="bg-amber-100 p-3 rounded-lg">
                        <i class="fas fa-server text-amber-600 text-xl animate-pulse-slow"></i>
                    </div>
                </div>
                <div class="mt-4 flex items-center text-sm">
                    <div class="w-2 h-2 bg-primary-500 rounded-full mr-2 animate-pulse"></div>
                    <span class="text-primary-600 font-medium">Funcionando</span>
                </div>
            </div>
        </div>

        <!-- Grid de Cards -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Menu Principal -->
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-primary-600 to-primary-700 px-6 py-4">
                    <h3 class="text-white font-semibold flex items-center">
                        <i class="fas fa-bars mr-3"></i>
                        Menu Principal
                    </h3>
                </div>
                <div class="p-6 space-y-3">
                    <a href="#" class="flex items-center p-4 bg-gray-50 hover:bg-primary-50 rounded-xl transition-colors duration-200 group">
                        <div class="bg-primary-100 group-hover:bg-primary-200 p-3 rounded-lg mr-4">
                            <i class="fas fa-users text-primary-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-gray-900">Gerenciar Usuários</p>
                            <p class="text-gray-600 text-sm">Adicionar, editar e remover usuários</p>
                        </div>
                    </a>
                    
                    <a href="#" class="flex items-center p-4 bg-gray-50 hover:bg-primary-50 rounded-xl transition-colors duration-200 group">
                        <div class="bg-primary-100 group-hover:bg-primary-200 p-3 rounded-lg mr-4">
                            <i class="fas fa-cog text-primary-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-gray-900">Configurações</p>
                            <p class="text-gray-600 text-sm">Configurar sistema e preferências</p>
                        </div>
                    </a>
                    
                    <a href="#" class="flex items-center p-4 bg-gray-50 hover:bg-primary-50 rounded-xl transition-colors duration-200 group">
                        <div class="bg-primary-100 group-hover:bg-primary-200 p-3 rounded-lg mr-4">
                            <i class="fas fa-chart-bar text-primary-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-gray-900">Relatórios</p>
                            <p class="text-gray-600 text-sm">Visualizar dados e estatísticas</p>
                        </div>
                    </a>
                    
                    <a href="#" class="flex items-center p-4 bg-gray-50 hover:bg-primary-50 rounded-xl transition-colors duration-200 group">
                        <div class="bg-primary-100 group-hover:bg-primary-200 p-3 rounded-lg mr-4">
                            <i class="fas fa-shield-alt text-primary-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-gray-900">Segurança</p>
                            <p class="text-gray-600 text-sm">Logs e configurações de segurança</p>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Atividades Recentes -->
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-primary-600 to-primary-700 px-6 py-4">
                    <h3 class="text-white font-semibold flex items-center">
                        <i class="fas fa-history mr-3"></i>
                        Atividades Recentes
                    </h3>
                </div>
                <div class="p-6 space-y-4">
                    <div class="flex items-start space-x-3 p-3 bg-gray-50 rounded-lg">
                        <div class="bg-primary-100 p-2 rounded-lg">
                            <i class="fas fa-user-plus text-primary-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="font-semibold text-gray-900 text-sm">Sistema iniciado</p>
                            <p class="text-gray-600 text-xs">Primeira execução do painel</p>
                            <p class="text-gray-500 text-xs mt-1">Agora</p>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-3 p-3 bg-gray-50 rounded-lg">
                        <div class="bg-emerald-100 p-2 rounded-lg">
                            <i class="fas fa-database text-emerald-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="font-semibold text-gray-900 text-sm">Banco criado</p>
                            <p class="text-gray-600 text-xs">Database simae_admin configurado</p>
                            <p class="text-gray-500 text-xs mt-1">Há poucos minutos</p>
                        </div>
                    </div>
                    
                    <div class="flex items-start space-x-3 p-3 bg-gray-50 rounded-lg">
                        <div class="bg-blue-100 p-2 rounded-lg">
                            <i class="fas fa-sign-in-alt text-blue-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="font-semibold text-gray-900 text-sm">Login realizado</p>
                            <p class="text-gray-600 text-xs"><?php echo $_SESSION['user_email'] ?? 'Usuário'; ?></p>
                            <p class="text-gray-500 text-xs mt-1">Agora</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informações do Sistema -->
            <div class="bg-white rounded-2xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-primary-600 to-primary-700 px-6 py-4">
                    <h3 class="text-white font-semibold flex items-center">
                        <i class="fas fa-info-circle mr-3"></i>
                        Informações do Sistema
                    </h3>
                </div>
                <div class="p-6 space-y-4">
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-gray-600 font-medium">Versão:</span>
                        <span class="text-gray-900 font-semibold">1.0.0</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-gray-600 font-medium">PHP:</span>
                        <span class="text-gray-900 font-semibold"><?php echo PHP_VERSION; ?></span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-gray-600 font-medium">Servidor:</span>
                        <span class="text-gray-900 font-semibold text-xs"><?php echo explode(' ', $_SERVER['SERVER_SOFTWARE'])[0]; ?></span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-100">
                        <span class="text-gray-600 font-medium">Sistema:</span>
                        <span class="text-gray-900 font-semibold">SIMAE</span>
                    </div>
                    <div class="flex justify-between items-center py-2">
                        <span class="text-gray-600 font-medium">Status:</span>
                        <span class="flex items-center">
                            <div class="w-2 h-2 bg-primary-500 rounded-full mr-2 animate-pulse"></div>
                            <span class="text-primary-600 font-semibold">Online</span>
                        </span>
                    </div>
                    
                    <!-- Botões de ação -->
                    <div class="pt-4 space-y-2">
                        <button class="w-full bg-primary-50 hover:bg-primary-100 text-primary-700 font-medium py-2 px-4 rounded-lg transition-colors duration-200">
                            <i class="fas fa-sync-alt mr-2"></i>
                            Atualizar Status
                        </button>
                        <button class="w-full bg-gray-50 hover:bg-gray-100 text-gray-700 font-medium py-2 px-4 rounded-lg transition-colors duration-200">
                            <i class="fas fa-download mr-2"></i>
                            Backup do Sistema
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Scripts -->
    <script>
        // Atualizar hora atual no título
        function updateTime() {
            const now = new Date();
            const timeString = now.toLocaleTimeString('pt-BR');
            document.title = `SIMAE Dashboard - ${timeString}`;
        }
        
        updateTime();
        setInterval(updateTime, 1000);
        
        // Animações de entrada
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.card-hover');
            cards.forEach((card, index) => {
                setTimeout(() => {
                    card.style.opacity = '0';
                    card.style.transform = 'translateY(20px)';
                    card.style.transition = 'all 0.5s ease';
                    
                    setTimeout(() => {
                        card.style.opacity = '1';
                        card.style.transform = 'translateY(0)';
                    }, 100);
                }, index * 100);
            });
        });
        
        // Confirmar ações
        function confirmAction(message) {
            return confirm(message);
        }
        
        // Simular carregamento de dados
        function updateStats() {
            // Aqui você pode adicionar lógica para atualizar estatísticas em tempo real
            console.log('Atualizando estatísticas...');
        }
        
        // Atualizar a cada 30 segundos
        setInterval(updateStats, 30000);
    </script>
</body>
</html>

        .user-info {
            text-align: right;
        }

        .user-info strong {
            display: block;
            font-size: 0.9rem;
        }

        .user-info small {
            opacity: 0.8;
            font-size: 0.8rem;
        }

        .btn-logout {
            background: rgba(255,255,255,0.2);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 20px;
            text-decoration: none;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .btn-logout:hover {
            background: rgba(255,255,255,0.3);
            color: white;
            text-decoration: none;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }

        .welcome-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            text-align: center;
        }

        .welcome-card h2 {
            color: #2c3e50;
            margin-bottom: 10px;
        }

        .welcome-card p {
            color: #6c757d;
            font-size: 1.1rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-card.primary { border-left: 5px solid #007bff; }
        .stat-card.success { border-left: 5px solid #28a745; }
        .stat-card.warning { border-left: 5px solid #ffc107; }
        .stat-card.danger { border-left: 5px solid #dc3545; }

        .stat-card h3 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 10px;
            color: #2c3e50;
        }

        .stat-card p {
            color: #6c757d;
            font-size: 1rem;
            margin: 0;
        }

        .stat-card i {
            margin-right: 8px;
        }

        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }

        .card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            font-weight: 600;
        }

        .card-body {
            padding: 25px;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 15px;
            margin: 10px 0;
            background: #f8f9fa;
            border-radius: 10px;
            text-decoration: none;
            color: #2c3e50;
            transition: all 0.3s ease;
        }

        .menu-item:hover {
            background: #e9ecef;
            transform: translateX(5px);
            color: #2c3e50;
            text-decoration: none;
        }

        .menu-item i {
            margin-right: 15px;
            width: 20px;
            color: #667eea;
        }

        .activity-item {
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .activity-item:last-child {
            border-bottom: none;
        }

        .activity-info strong {
            color: #2c3e50;
        }

        .activity-info span {
            color: #6c757d;
            font-size: 0.9rem;
        }

        .activity-time {
            color: #6c757d;
            font-size: 0.8rem;
        }

        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }

            .header-right {
                flex-direction: column;
                gap: 10px;
            }

            .stats-grid {
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            }

            .cards-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="admin-header">
        <div class="header-content">
            <div class="header-left">
                <h1><i class="fas fa-shield-alt"></i> SIMAE</h1>
                <p>Sistema de Administração</p>
            </div>
            <div class="header-right">
                <div class="user-info">
                    <strong><?php echo $_SESSION['user_nome'] ?? 'Usuário'; ?></strong>
                    <small><?php echo $_SESSION['user_email'] ?? ''; ?></small>
                </div>
                <a href="/simae/admin/logout" class="btn-logout">
                    <i class="fas fa-sign-out-alt"></i> Sair
                </a>
            </div>
        </div>
    </div>

    <!-- Conteúdo Principal -->
    <div class="container">
        <!-- Boas-vindas -->
        <div class="welcome-card">
            <h2>👋 Bem-vindo de volta!</h2>
            <p>Gerencie seu sistema através do painel administrativo</p>
        </div>

        <!-- Estatísticas -->
        <div class="stats-grid">
            <?php
            // Carrega configuração centralizada se não estiver carregada
            if (!defined('DB_HOST')) {
                require_once dirname(dirname(dirname(__DIR__))) . '/admin/config/database.php';
            }
            
            // Buscar estatísticas do banco
            try {
                $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
                $total_usuarios = 0;
                $usuarios_ativos = 0;
                $logins_recentes = 0;
                $usuarios_inativos = 0;

                if (!$conn->connect_error) {
                    $result = $conn->query("SELECT COUNT(*) as total FROM usuarios");
                    if ($result) $total_usuarios = $result->fetch_assoc()['total'];

                    $result = $conn->query("SELECT COUNT(*) as ativos FROM usuarios WHERE ativo = 1");
                    if ($result) $usuarios_ativos = $result->fetch_assoc()['ativos'];

                    $result = $conn->query("SELECT COUNT(*) as recentes FROM usuarios WHERE ultimo_login >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
                    if ($result) $logins_recentes = $result->fetch_assoc()['recentes'];

                    $result = $conn->query("SELECT COUNT(*) as inativos FROM usuarios WHERE ativo = 0");
                    if ($result) $usuarios_inativos = $result->fetch_assoc()['inativos'];

                    $conn->close();
                }
            } catch (Exception $e) {
                // Em caso de erro, usar valores padrão
            }
            ?>

            <div class="stat-card primary">
                <h3><?php echo $total_usuarios; ?></h3>
                <p><i class="fas fa-users"></i> Total de Usuários</p>
            </div>
            
            <div class="stat-card success">
                <h3><?php echo $usuarios_ativos; ?></h3>
                <p><i class="fas fa-user-check"></i> Usuários Ativos</p>
            </div>
            
            <div class="stat-card warning">
                <h3><?php echo $logins_recentes; ?></h3>
                <p><i class="fas fa-sign-in-alt"></i> Logins (7 dias)</p>
            </div>
            
            <div class="stat-card danger">
                <h3><?php echo $usuarios_inativos; ?></h3>
                <p><i class="fas fa-user-times"></i> Usuários Inativos</p>
            </div>
        </div>

        <!-- Cards de Funcionalidades -->
        <div class="cards-grid">
            <!-- Menu Principal -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-bars"></i> Menu Principal
                </div>
                <div class="card-body">
                    <a href="#" class="menu-item">
                        <i class="fas fa-users"></i>
                        Gerenciar Usuários
                    </a>
                    <a href="#" class="menu-item">
                        <i class="fas fa-cog"></i>
                        Configurações
                    </a>
                    <a href="#" class="menu-item">
                        <i class="fas fa-chart-bar"></i>
                        Relatórios
                    </a>
                    <a href="#" class="menu-item">
                        <i class="fas fa-shield-alt"></i>
                        Segurança
                    </a>
                </div>
            </div>

            <!-- Atividades Recentes -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-history"></i> Atividades Recentes
                </div>
                <div class="card-body">
                    <div class="activity-item">
                        <div class="activity-info">
                            <strong>Sistema iniciado</strong><br>
                            <span>Primeira execução do painel</span>
                        </div>
                        <div class="activity-time">
                            Agora
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-info">
                            <strong>Banco criado</strong><br>
                            <span>Database simae_admin configurado</span>
                        </div>
                        <div class="activity-time">
                            Há poucos minutos
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-info">
                            <strong>Login realizado</strong><br>
                            <span><?php echo $_SESSION['user_email'] ?? 'Usuário'; ?></span>
                        </div>
                        <div class="activity-time">
                            Agora
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informações do Sistema -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-info-circle"></i> Informações do Sistema
                </div>
                <div class="card-body">
                    <p><strong>Versão:</strong> 1.0.0</p>
                    <p><strong>PHP:</strong> <?php echo PHP_VERSION; ?></p>
                    <p><strong>Servidor:</strong> <?php echo $_SERVER['SERVER_SOFTWARE']; ?></p>
                    <p><strong>Sistema:</strong> SIMAE Admin Panel</p>
                    <p><strong>Status:</strong> <span style="color: #28a745;">✅ Online</span></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Adicionar interatividade aos cards
        document.addEventListener('DOMContentLoaded', function() {
            // Atualizar hora atual
            function updateTime() {
                const now = new Date();
                const timeString = now.toLocaleTimeString('pt-BR');
                document.title = `SIMAE Dashboard - ${timeString}`;
            }
            
            updateTime();
            setInterval(updateTime, 1000);
            
            // Confirmação de logout
            document.querySelector('.btn-logout').addEventListener('click', function(e) {
                if (!confirm('Tem certeza que deseja sair?')) {
                    e.preventDefault();
                }
            });
        });
    </script>
</body>
</html>