            </div>
        </main>
    </div>

    <!-- Scripts -->
    <script>
        // Funcionalidades básicas do sistema
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-hide dos alertas após 5 segundos
            const alerts = document.querySelectorAll('.bg-primary-50, .bg-red-50, .bg-yellow-50, .bg-green-50');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
                    alert.style.opacity = '0';
                    alert.style.transform = 'translateY(-10px)';
                    setTimeout(() => {
                        alert.remove();
                    }, 500);
                }, 5000);
            });

            // Confirmação para ações de exclusão
            const deleteButtons = document.querySelectorAll('a[href*="remover"], a[href*="excluir"], button[data-action="delete"]');
            deleteButtons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    // Criar modal de confirmação personalizado
                    const modal = document.createElement('div');
                    modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50';
                    modal.innerHTML = `
                        <div class="bg-white rounded-2xl shadow-2xl max-w-md w-full mx-4 transform transition-all">
                            <div class="p-6">
                                <div class="text-center">
                                    <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i class="fas fa-exclamation-triangle text-red-600 text-2xl"></i>
                                    </div>
                                    <h3 class="text-xl font-bold text-gray-900 mb-2">Confirmar Exclusão</h3>
                                    <p class="text-gray-600 mb-6">Esta ação não pode ser desfeita. Tem certeza que deseja continuar?</p>
                                    <div class="flex space-x-4">
                                        <button onclick="this.closest('.fixed').remove()" 
                                                class="flex-1 bg-gray-100 hover:bg-gray-200 text-gray-800 font-semibold py-3 px-4 rounded-lg transition-colors duration-200">
                                            Cancelar
                                        </button>
                                        <button onclick="window.location.href='${this.href}'" 
                                                class="flex-1 bg-red-600 hover:bg-red-700 text-white font-semibold py-3 px-4 rounded-lg transition-colors duration-200">
                                            Excluir
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    `;
                    document.body.appendChild(modal);
                    
                    // Fechar modal ao clicar no fundo
                    modal.addEventListener('click', function(e) {
                        if (e.target === this) {
                            this.remove();
                        }
                    });
                });
            });

            // Animações de entrada para elementos
            const animateElements = document.querySelectorAll('.bg-white, .rounded-xl, .shadow-lg');
            animateElements.forEach((element, index) => {
                element.style.opacity = '0';
                element.style.transform = 'translateY(20px)';
                element.style.transition = 'all 0.6s ease';
                
                setTimeout(() => {
                    element.style.opacity = '1';
                    element.style.transform = 'translateY(0)';
                }, index * 100);
            });

            // Validação de formulários
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function(e) {
                    const requiredFields = this.querySelectorAll('[required]');
                    let hasErrors = false;
                    
                    requiredFields.forEach(field => {
                        if (!field.value.trim()) {
                            hasErrors = true;
                            field.classList.add('border-red-500');
                            field.classList.remove('border-gray-300');
                            
                            // Remover erro ao focar no campo
                            field.addEventListener('focus', function() {
                                this.classList.remove('border-red-500');
                                this.classList.add('border-primary-500');
                            });
                        }
                    });
                    
                    if (hasErrors) {
                        e.preventDefault();
                        showNotification('Por favor, preencha todos os campos obrigatórios.', 'error');
                    }
                });
            });

            // Sistema de notificações
            window.showNotification = function(message, type = 'success') {
                const notification = document.createElement('div');
                const colors = {
                    success: 'bg-primary-50 border-primary-200 text-primary-800',
                    error: 'bg-red-50 border-red-200 text-red-800',
                    warning: 'bg-yellow-50 border-yellow-200 text-yellow-800',
                    info: 'bg-blue-50 border-blue-200 text-blue-800'
                };
                
                const icons = {
                    success: 'fas fa-check-circle',
                    error: 'fas fa-exclamation-circle',
                    warning: 'fas fa-exclamation-triangle',
                    info: 'fas fa-info-circle'
                };
                
                notification.className = `fixed top-4 right-4 ${colors[type]} border px-4 py-3 rounded-lg shadow-lg z-50 transform translate-x-full transition-transform duration-300`;
                notification.innerHTML = `
                    <div class="flex items-center">
                        <i class="${icons[type]} mr-3"></i>
                        <span>${message}</span>
                        <button onclick="this.parentElement.parentElement.remove()" class="ml-3 text-current opacity-70 hover:opacity-100">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                `;
                
                document.body.appendChild(notification);
                
                setTimeout(() => {
                    notification.classList.remove('translate-x-full');
                }, 100);
                
                setTimeout(() => {
                    notification.classList.add('translate-x-full');
                    setTimeout(() => notification.remove(), 300);
                }, 5000);
            };

            // Navegação com AJAX (opcional)
            const ajaxLinks = document.querySelectorAll('a[data-ajax="true"]');
            ajaxLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    // Implementar carregamento AJAX aqui se necessário
                });
            });

            // Atualizar hora no título
            function updateTime() {
                const now = new Date();
                const timeString = now.toLocaleTimeString('pt-BR');
                if (document.title.includes('SIMAE')) {
                    document.title = document.title.split(' - ')[0] + ` - ${timeString}`;
                }
            }
            
            updateTime();
            setInterval(updateTime, 1000);

            // Indicador de conectividade
            window.addEventListener('online', () => {
                showNotification('Conexão restabelecida', 'success');
            });
            
            window.addEventListener('offline', () => {
                showNotification('Conexão perdida', 'warning');
            });

            // Shortcuts de teclado
            document.addEventListener('keydown', function(e) {
                // Ctrl+Shift+D para Dashboard
                if (e.ctrlKey && e.shiftKey && e.key === 'D') {
                    window.location.href = '/simae/admin/dashboard';
                }
                
                // Ctrl+Shift+U para Usuários
                if (e.ctrlKey && e.shiftKey && e.key === 'U') {
                    window.location.href = '/simae/admin/usuarios';
                }
                
                // Ctrl+Shift+L para Logout
                if (e.ctrlKey && e.shiftKey && e.key === 'L') {
                    if (confirm('Tem certeza que deseja sair?')) {
                        window.location.href = '/simae/admin/logout';
                    }
                }
            });
        });

        // Função para toggle de sidebar em mobile
        function toggleSidebar() {
            const sidebar = document.querySelector('nav');
            sidebar.classList.toggle('-translate-x-full');
        }

        // Função para recarregar página
        function reloadPage() {
            location.reload();
        }

        // Função para voltar
        function goBack() {
            window.history.back();
        }
    </script>

    <!-- Footer -->
    <footer class="bg-white border-t border-gray-200 px-6 py-4 mt-auto">
        <div class="flex items-center justify-between text-sm text-gray-600">
            <div>
                <p>&copy; 2025 SIMAE - Sistema de Administração</p>
            </div>
            <div class="flex items-center space-x-4">
                <span>Versão 2.0</span>
                <span>•</span>
                <span>PHP <?php echo PHP_VERSION; ?></span>
                <span>•</span>
                <span class="flex items-center space-x-1">
                    <div class="w-2 h-2 bg-primary-500 rounded-full animate-pulse"></div>
                    <span>Sistema Online</span>
                </span>
            </div>
        </div>
    </footer>
</body>
</html>
            $('form').submit(function() {
                var requiredFields = $(this).find('[required]');
                var isValid = true;
                
                requiredFields.each(function() {
                    if ($(this).val() === '') {
                        $(this).addClass('error');
                        isValid = false;
                    } else {
                        $(this).removeClass('error');
                    }
                });
                
                if (!isValid) {
                    alert('Por favor, preencha todos os campos obrigatórios.');
                    return false;
                }
            });

            // Máscara para campos de telefone (se necessário)
            $('.phone-mask').mask('(00) 00000-0000');
            
            // Máscara para CPF (se necessário)
            $('.cpf-mask').mask('000.000.000-00');

            // DataTables para tabelas grandes (se a biblioteca estiver incluída)
            if (typeof $.fn.DataTable !== 'undefined') {
                $('.data-table').DataTable({
                    "language": {
                        "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Portuguese-Brasil.json"
                    },
                    "pageLength": 25,
                    "order": [[ 0, "desc" ]]
                });
            }
        });

        // Função para mostrar loading
        function showLoading() {
            $('body').append('<div class="loading-overlay"><div class="loading-spinner"><i class="fas fa-spinner fa-spin"></i> Carregando...</div></div>');
        }

        // Função para esconder loading
        function hideLoading() {
            $('.loading-overlay').remove();
        }

        // Função para mostrar mensagem de sucesso
        function showSuccess(message) {
            showMessage(message, 'success');
        }

        // Função para mostrar mensagem de erro
        function showError(message) {
            showMessage(message, 'danger');
        }

        // Função para mostrar mensagens
        function showMessage(message, type) {
            var alertClass = 'alert-' + type;
            var icon = type === 'success' ? 'check-circle' : 'exclamation-triangle';
            
            var alert = $('<div class="alert ' + alertClass + '">')
                .html('<i class="fas fa-' + icon + '"></i> ' + message)
                .hide()
                .prependTo('.content-body')
                .fadeIn();
            
            setTimeout(function() {
                alert.fadeOut(function() {
                    $(this).remove();
                });
            }, 5000);
        }
    </script>

    <style>
        /* Estilos adicionais para melhorar a UX */
        .form-control.error {
            border-color: #e74c3c;
            box-shadow: 0 0 0 2px rgba(231, 76, 60, 0.2);
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }

        .loading-spinner {
            background: white;
            padding: 20px 30px;
            border-radius: 8px;
            color: #2c3e50;
            font-size: 16px;
        }

        .loading-spinner i {
            margin-right: 10px;
            font-size: 18px;
            color: #1abc9c;
        }

        /* Melhorias nos botões */
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .btn-group {
            display: inline-flex;
            gap: 5px;
        }

        /* Melhorias nas tabelas */
        .table-responsive {
            overflow-x: auto;
        }

        .table .btn {
            padding: 5px 10px;
            font-size: 12px;
        }

        /* Status badges */
        .badge {
            display: inline-block;
            padding: 4px 8px;
            font-size: 11px;
            font-weight: 600;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: 4px;
        }

        .badge-success {
            color: #fff;
            background-color: #27ae60;
        }

        .badge-danger {
            color: #fff;
            background-color: #e74c3c;
        }

        .badge-warning {
            color: #fff;
            background-color: #f39c12;
        }

        .badge-info {
            color: #fff;
            background-color: #3498db;
        }
    </style>
</body>
</html>