<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($titulo) ? $titulo : 'SIMAE - Painel Administrativo'; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0fdf4',
                            100: '#dcfce7',
                            200: '#bbf7d0',
                            300: '#86efac',
                            400: '#4ade80',
                            500: '#22c55e',
                            600: '#16a34a',
                            700: '#15803d',
                            800: '#166534',
                            900: '#14532d',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); }
        .sidebar-transition { transition: transform 0.3s ease; }
        .nav-item-hover { transition: all 0.2s ease; }
        .nav-item-hover:hover { transform: translateX(4px); }
    </style>
</head>
<body class="gradient-bg min-h-screen">
    <div class="flex">
        <!-- Sidebar -->
        <nav class="bg-white shadow-lg w-64 min-h-screen sidebar-transition">
            <!-- Header do Sidebar -->
            <div class="bg-gradient-to-r from-primary-600 to-primary-700 p-6 text-white">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-white bg-opacity-20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-shield-alt text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold">SIMAE</h3>
                        <p class="text-sm text-primary-100">Painel Administrativo</p>
                    </div>
                </div>
            </div>
            
            <!-- Navegação -->
            <ul class="py-6">
                <li class="px-6 mb-2">
                    <a href="/simae/admin/dashboard" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover <?php echo (strpos($_SERVER['REQUEST_URI'], 'dashboard') !== false) ? 'bg-primary-50 text-primary-700 border-r-4 border-primary-500' : 'text-gray-700 hover:bg-gray-50'; ?>">
                        <i class="fas fa-tachometer-alt w-5"></i>
                        <span class="font-medium">Dashboard</span>
                    </a>
                </li>
                
                <li class="px-6 mb-2">
                    <a href="/simae/admin/usuarios" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover <?php echo (strpos($_SERVER['REQUEST_URI'], 'usuarios') !== false) ? 'bg-primary-50 text-primary-700 border-r-4 border-primary-500' : 'text-gray-700 hover:bg-gray-50'; ?>">
                        <i class="fas fa-users w-5"></i>
                        <span class="font-medium">Usuários</span>
                    </a>
                </li>
                
                <li class="px-6 mb-2">
                    <a href="/simae/admin/relatorios" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover <?php echo (strpos($_SERVER['REQUEST_URI'], 'relatorios') !== false) ? 'bg-primary-50 text-primary-700 border-r-4 border-primary-500' : 'text-gray-700 hover:bg-gray-50'; ?>">
                        <i class="fas fa-chart-bar w-5"></i>
                        <span class="font-medium">Relatórios</span>
                    </a>
                </li>
                
                <li class="px-6 mb-2">
                    <a href="/simae/admin/sistema" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover <?php echo (strpos($_SERVER['REQUEST_URI'], 'sistema') !== false) ? 'bg-primary-50 text-primary-700 border-r-4 border-primary-500' : 'text-gray-700 hover:bg-gray-50'; ?>">
                        <i class="fas fa-server w-5"></i>
                        <span class="font-medium">Sistema</span>
                    </a>
                </li>
                
                <li class="px-6 mb-2">
                    <a href="/simae/admin/configuracoes" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover <?php echo (strpos($_SERVER['REQUEST_URI'], 'configuracoes') !== false) ? 'bg-primary-50 text-primary-700 border-r-4 border-primary-500' : 'text-gray-700 hover:bg-gray-50'; ?>">
                        <i class="fas fa-cog w-5"></i>
                        <span class="font-medium">Configurações</span>
                    </a>
                </li>
                
                <!-- Separador -->
                <li class="mx-6 my-4 border-t border-gray-200"></li>
                
                <!-- Links úteis -->
                <li class="px-6 mb-2">
                    <a href="/simae/verificar.php" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover text-gray-700 hover:bg-gray-50">
                        <i class="fas fa-check-circle w-5"></i>
                        <span class="font-medium">Verificar Sistema</span>
                    </a>
                </li>
                
                <li class="px-6 mb-2">
                    <a href="/simae/" 
                       class="flex items-center space-x-3 p-3 rounded-lg nav-item-hover text-gray-700 hover:bg-gray-50">
                        <i class="fas fa-home w-5"></i>
                        <span class="font-medium">Página Inicial</span>
                    </a>
                </li>
            </ul>
            
            <!-- Footer do Sidebar -->
            <div class="absolute bottom-0 w-64 p-6 border-t border-gray-200 bg-white">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-primary-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-user text-primary-600 text-sm"></i>
                        </div>
                        <div class="text-sm">
                            <p class="font-semibold text-gray-800">Admin</p>
                            <p class="text-gray-500 text-xs">Online</p>
                        </div>
                    </div>
                    <a href="/simae/admin/logout" 
                       onclick="return confirm('Tem certeza que deseja sair?')"
                       class="text-gray-400 hover:text-red-500 transition-colors duration-200">
                        <i class="fas fa-sign-out-alt"></i>
                    </a>
                </div>
            </div>
        </nav>

        <!-- Conteúdo Principal -->
        <main class="flex-1 min-h-screen">
            <!-- Header Superior -->
            <header class="bg-white shadow-sm border-b border-gray-200 px-6 py-4">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-800"><?php echo isset($titulo) ? $titulo : 'Dashboard'; ?></h1>
                        <p class="text-gray-600"><?php echo isset($subtitulo) ? $subtitulo : 'Painel de controle administrativo'; ?></p>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <!-- Notificações -->
                        <button class="relative p-2 text-gray-400 hover:text-gray-600 transition-colors duration-200">
                            <i class="fas fa-bell text-lg"></i>
                            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center">3</span>
                        </button>
                        
                        <!-- Perfil -->
                        <div class="flex items-center space-x-3">
                            <div class="text-right">
                                <p class="text-sm font-semibold text-gray-800"><?php echo isset($_SESSION['user_nome']) ? $_SESSION['user_nome'] : 'Administrador'; ?></p>
                                <p class="text-xs text-gray-500"><?php echo isset($_SESSION['user_email']) ? $_SESSION['user_email'] : 'admin@simae.com'; ?></p>
                            </div>
                            <div class="w-10 h-10 bg-gradient-to-r from-primary-500 to-primary-600 rounded-lg flex items-center justify-center">
                                <i class="fas fa-user text-white"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Área de conteúdo -->
            <div class="p-6">
                <?php if (isset($mensagem_sucesso)): ?>
                    <div class="bg-primary-50 border border-primary-200 text-primary-800 px-4 py-3 rounded-lg mb-6 flex items-center">
                        <i class="fas fa-check-circle mr-3"></i>
                        <?php echo $mensagem_sucesso; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($mensagem_erro)): ?>
                    <div class="bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg mb-6 flex items-center">
                        <i class="fas fa-exclamation-circle mr-3"></i>
                        <?php echo $mensagem_erro; ?>
                    </div>
                <?php endif; ?>
                
                <li>
                    <a href="<?php echo site_url('admin/sistema'); ?>"
                       class="<?php echo (strpos(uri_string(), 'admin/sistema') === 0) ? 'active' : ''; ?>">
                        <i class="fas fa-server"></i>
                        Sistema
                    </a>
                </li>
                
                <li style="border-top: 1px solid #34495e; margin-top: 20px;">
                    <a href="<?php echo site_url('admin/logout'); ?>">
                        <i class="fas fa-sign-out-alt"></i>
                        Sair
                    </a>
                </li>
            </ul>
        </nav>

        <!-- Conteúdo Principal -->
        <main class="main-content">
            <!-- Header do Conteúdo -->
            <div class="content-header clearfix">
                <div>
                    <h1><?php echo str_replace(' - Painel Administrativo SIMAE', '', $titulo); ?></h1>
                    <div class="breadcrumb">
                        <?php 
                        $segments = $this->uri->segment_array();
                        $breadcrumbs = array();
                        $url = '';
                        
                        foreach ($segments as $segment) {
                            $url .= '/' . $segment;
                            $breadcrumbs[] = '<a href="' . site_url($url) . '">' . ucfirst($segment) . '</a>';
                        }
                        
                        echo 'Você está em: ' . implode(' > ', $breadcrumbs);
                        ?>
                    </div>
                </div>
                
                <div class="user-info">
                    <div class="dropdown">
                        <button class="dropdown-toggle">
                            <i class="fas fa-user"></i>
                            <?php echo $usuario_logado->nome; ?>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="dropdown-menu">
                            <a href="#"><i class="fas fa-user-edit"></i> Meu Perfil</a>
                            <a href="#"><i class="fas fa-key"></i> Alterar Senha</a>
                            <a href="<?php echo site_url('admin/logout'); ?>">
                                <i class="fas fa-sign-out-alt"></i> Sair
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Corpo do Conteúdo -->
            <div class="content-body">