<div class="card">
    <div class="card-header">
        <i class="fas fa-chart-bar"></i> Relatórios do Sistema
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            
            <!-- Relatório de Usuários -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-users"></i> Relatório de Usuários
                </div>
                <div class="card-body">
                    <p style="color: #666; margin-bottom: 15px;">
                        Gere relatórios detalhados sobre os usuários do sistema.
                    </p>
                    <div class="btn-group" style="width: 100%;">
                        <button class="btn btn-primary btn-sm" onclick="gerarRelatorio('usuarios')">
                            <i class="fas fa-file-pdf"></i> PDF
                        </button>
                        <button class="btn btn-success btn-sm" onclick="gerarRelatorio('usuarios', 'excel')">
                            <i class="fas fa-file-excel"></i> Excel
                        </button>
                    </div>
                </div>
            </div>

            <!-- Relatório de Atividades -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-history"></i> Relatório de Atividades
                </div>
                <div class="card-body">
                    <p style="color: #666; margin-bottom: 15px;">
                        Acompanhe as atividades e logs do sistema.
                    </p>
                    <div class="btn-group" style="width: 100%;">
                        <button class="btn btn-primary btn-sm" onclick="gerarRelatorio('atividades')">
                            <i class="fas fa-file-pdf"></i> PDF
                        </button>
                        <button class="btn btn-success btn-sm" onclick="gerarRelatorio('atividades', 'excel')">
                            <i class="fas fa-file-excel"></i> Excel
                        </button>
                    </div>
                </div>
            </div>

            <!-- Relatório de Login -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-sign-in-alt"></i> Relatório de Logins
                </div>
                <div class="card-body">
                    <p style="color: #666; margin-bottom: 15px;">
                        Controle de acessos e histórico de logins.
                    </p>
                    <div class="btn-group" style="width: 100%;">
                        <button class="btn btn-primary btn-sm" onclick="gerarRelatorio('logins')">
                            <i class="fas fa-file-pdf"></i> PDF
                        </button>
                        <button class="btn btn-success btn-sm" onclick="gerarRelatorio('logins', 'excel')">
                            <i class="fas fa-file-excel"></i> Excel
                        </button>
                    </div>
                </div>
            </div>

            <!-- Relatório do Sistema -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-server"></i> Relatório do Sistema
                </div>
                <div class="card-body">
                    <p style="color: #666; margin-bottom: 15px;">
                        Informações técnicas e estatísticas do sistema.
                    </p>
                    <div class="btn-group" style="width: 100%;">
                        <button class="btn btn-primary btn-sm" onclick="gerarRelatorio('sistema')">
                            <i class="fas fa-file-pdf"></i> PDF
                        </button>
                        <button class="btn btn-success btn-sm" onclick="gerarRelatorio('sistema', 'excel')">
                            <i class="fas fa-file-excel"></i> Excel
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filtros de Relatório -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-filter"></i> Filtros para Relatórios
    </div>
    <div class="card-body">
        <form id="filtrosRelatorio">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
                <div class="form-group">
                    <label for="data_inicio">Data Início</label>
                    <input type="date" id="data_inicio" name="data_inicio" class="form-control">
                </div>
                
                <div class="form-group">
                    <label for="data_fim">Data Fim</label>
                    <input type="date" id="data_fim" name="data_fim" class="form-control">
                </div>
                
                <div class="form-group">
                    <label for="usuario_filtro">Usuário</label>
                    <select id="usuario_filtro" name="usuario_filtro" class="form-control">
                        <option value="">Todos os usuários</option>
                        <!-- Opções seriam carregadas via AJAX -->
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="status_filtro">Status</label>
                    <select id="status_filtro" name="status_filtro" class="form-control">
                        <option value="">Todos</option>
                        <option value="ativo">Ativos</option>
                        <option value="inativo">Inativos</option>
                    </select>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Estatísticas Rápidas -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-chart-pie"></i> Estatísticas Rápidas
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
            
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <h3 style="color: #1abc9c; margin-bottom: 10px;">
                    <i class="fas fa-users"></i> 0
                </h3>
                <p>Total de Usuários</p>
            </div>
            
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <h3 style="color: #3498db; margin-bottom: 10px;">
                    <i class="fas fa-sign-in-alt"></i> 0
                </h3>
                <p>Logins Hoje</p>
            </div>
            
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <h3 style="color: #f39c12; margin-bottom: 10px;">
                    <i class="fas fa-clock"></i> 0
                </h3>
                <p>Sessões Ativas</p>
            </div>
            
            <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                <h3 style="color: #e74c3c; margin-bottom: 10px;">
                    <i class="fas fa-exclamation-triangle"></i> 0
                </h3>
                <p>Erros Recentes</p>
            </div>
        </div>
    </div>
</div>

<script>
function gerarRelatorio(tipo, formato = 'pdf') {
    // Captura os filtros
    const filtros = {
        data_inicio: document.getElementById('data_inicio').value,
        data_fim: document.getElementById('data_fim').value,
        usuario_filtro: document.getElementById('usuario_filtro').value,
        status_filtro: document.getElementById('status_filtro').value
    };
    
    // Monta a URL do relatório
    let url = '<?php echo site_url("admin/relatorios/gerar/"); ?>' + tipo + '/' + formato;
    
    // Adiciona os filtros como parâmetros GET
    const params = new URLSearchParams(filtros);
    url += '?' + params.toString();
    
    // Abre o relatório em nova janela
    window.open(url, '_blank');
    
    // Ou pode fazer download direto
    // window.location.href = url;
}

// Configura as datas padrão (último mês)
document.addEventListener('DOMContentLoaded', function() {
    const hoje = new Date();
    const mesPassado = new Date();
    mesPassado.setMonth(hoje.getMonth() - 1);
    
    document.getElementById('data_inicio').value = mesPassado.toISOString().split('T')[0];
    document.getElementById('data_fim').value = hoje.toISOString().split('T')[0];
});
</script>