<div class="card">
    <div class="card-header">
        <i class="fas fa-server"></i> Informações do Sistema
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            
            <!-- Informações do Servidor -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-desktop"></i> Servidor
                </div>
                <div class="card-body">
                    <table style="width: 100%; font-size: 14px;">
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Sistema Operacional:</td>
                            <td style="padding: 8px 0;"><?php echo PHP_OS; ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Servidor Web:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['servidor']; ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Versão PHP:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['versao_php']; ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Limite de Memória:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['memoria_limite']; ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Tempo Execução:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['tempo_execucao']; ?>s</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Upload Máximo:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['upload_max']; ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Fuso Horário:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['timezone']; ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Informações do Sistema -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-info-circle"></i> Sistema SIMAE
                </div>
                <div class="card-body">
                    <table style="width: 100%; font-size: 14px;">
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Versão:</td>
                            <td style="padding: 8px 0;"><?php echo $info_sistema['versao_sistema']; ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">CodeIgniter:</td>
                            <td style="padding: 8px 0;">3.1.13</td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Instalação:</td>
                            <td style="padding: 8px 0;"><?php echo date('d/m/Y'); ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Última Atualização:</td>
                            <td style="padding: 8px 0;"><?php echo date('d/m/Y'); ?></td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Ambiente:</td>
                            <td style="padding: 8px 0;">
                                <span class="badge badge-warning"><?php echo ENVIRONMENT; ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 8px 0; font-weight: 600;">Debug:</td>
                            <td style="padding: 8px 0;">
                                <?php if (ENVIRONMENT == 'development'): ?>
                                    <span class="badge badge-danger">Ativado</span>
                                <?php else: ?>
                                    <span class="badge badge-success">Desativado</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <!-- Status dos Serviços -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-heartbeat"></i> Status dos Serviços
                </div>
                <div class="card-body">
                    <div class="servico-status" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span><i class="fas fa-database"></i> Banco de Dados</span>
                            <span class="badge badge-success">Online</span>
                        </div>
                    </div>
                    
                    <div class="servico-status" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span><i class="fas fa-envelope"></i> Servidor E-mail</span>
                            <span class="badge badge-warning">Não configurado</span>
                        </div>
                    </div>
                    
                    <div class="servico-status" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span><i class="fas fa-memory"></i> Cache</span>
                            <span class="badge badge-success">Ativo</span>
                        </div>
                    </div>
                    
                    <div class="servico-status" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span><i class="fas fa-shield-alt"></i> SSL/HTTPS</span>
                            <span class="badge badge-danger">Inativo</span>
                        </div>
                    </div>
                    
                    <div class="servico-status">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span><i class="fas fa-clock"></i> Backup</span>
                            <span class="badge badge-success">Agendado</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recursos do Sistema -->
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-chart-pie"></i> Uso de Recursos
                </div>
                <div class="card-body">
                    <div class="recurso-item" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span>Uso de Memória</span>
                            <span>25%</span>
                        </div>
                        <div style="background: #ecf0f1; height: 8px; border-radius: 4px;">
                            <div style="background: #3498db; height: 100%; width: 25%; border-radius: 4px;"></div>
                        </div>
                    </div>
                    
                    <div class="recurso-item" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span>Uso de CPU</span>
                            <span>15%</span>
                        </div>
                        <div style="background: #ecf0f1; height: 8px; border-radius: 4px;">
                            <div style="background: #27ae60; height: 100%; width: 15%; border-radius: 4px;"></div>
                        </div>
                    </div>
                    
                    <div class="recurso-item" style="margin-bottom: 15px;">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span>Espaço em Disco</span>
                            <span>60%</span>
                        </div>
                        <div style="background: #ecf0f1; height: 8px; border-radius: 4px;">
                            <div style="background: #f39c12; height: 100%; width: 60%; border-radius: 4px;"></div>
                        </div>
                    </div>
                    
                    <div class="recurso-item">
                        <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                            <span>Banco de Dados</span>
                            <span>12MB</span>
                        </div>
                        <div style="background: #ecf0f1; height: 8px; border-radius: 4px;">
                            <div style="background: #1abc9c; height: 100%; width: 5%; border-radius: 4px;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ferramentas do Sistema -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-tools"></i> Ferramentas do Sistema
    </div>
    <div class="card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px;">
            
            <button class="btn btn-info" onclick="verificarAtualizacoes()">
                <i class="fas fa-sync-alt"></i> Verificar Atualizações
            </button>
            
            <button class="btn btn-secondary" onclick="gerarRelatorioSistema()">
                <i class="fas fa-file-medical"></i> Diagnóstico
            </button>
            
            <button class="btn btn-warning" onclick="limparCacheSistema()">
                <i class="fas fa-broom"></i> Limpar Cache
            </button>
            
            <button class="btn btn-success" onclick="exportarConfiguracoes()">
                <i class="fas fa-download"></i> Exportar Config
            </button>
            
            <button class="btn btn-primary" onclick="importarConfiguracoes()">
                <i class="fas fa-upload"></i> Importar Config
            </button>
            
            <button class="btn btn-danger" onclick="reiniciarSistema()">
                <i class="fas fa-power-off"></i> Reiniciar
            </button>
        </div>
    </div>
</div>

<!-- Logs do Sistema -->
<div class="card">
    <div class="card-header">
        <i class="fas fa-file-alt"></i> Logs Recentes do Sistema
    </div>
    <div class="card-body">
        <div class="logs-container" style="background: #2c3e50; color: #ecf0f1; padding: 20px; border-radius: 4px; font-family: monospace; font-size: 12px; max-height: 300px; overflow-y: auto;">
            <div class="log-line">[<?php echo date('Y-m-d H:i:s'); ?>] INFO: Sistema iniciado com sucesso</div>
            <div class="log-line">[<?php echo date('Y-m-d H:i:s', strtotime('-5 minutes')); ?>] INFO: Usuário admin fez login</div>
            <div class="log-line">[<?php echo date('Y-m-d H:i:s', strtotime('-10 minutes')); ?>] INFO: Backup automático executado</div>
            <div class="log-line">[<?php echo date('Y-m-d H:i:s', strtotime('-1 hour')); ?>] WARNING: Tentativa de login falhada para usuario@teste.com</div>
            <div class="log-line">[<?php echo date('Y-m-d H:i:s', strtotime('-2 hours')); ?>] INFO: Cache limpo automaticamente</div>
            <div class="log-line">[<?php echo date('Y-m-d H:i:s', strtotime('-3 hours')); ?>] INFO: Configurações atualizadas</div>
        </div>
        
        <div style="margin-top: 15px; text-align: right;">
            <button class="btn btn-sm btn-secondary" onclick="carregarMaisLogs()">
                <i class="fas fa-plus"></i> Carregar mais logs
            </button>
            <button class="btn btn-sm btn-primary" onclick="baixarLogs()">
                <i class="fas fa-download"></i> Baixar logs
            </button>
        </div>
    </div>
</div>

<script>
function verificarAtualizacoes() {
    showLoading();
    
    setTimeout(function() {
        hideLoading();
        showSuccess('Sistema está atualizado! Versão mais recente instalada.');
    }, 2000);
}

function gerarRelatorioSistema() {
    showLoading();
    
    setTimeout(function() {
        hideLoading();
        showSuccess('Relatório de diagnóstico gerado com sucesso!');
        // Aqui você abriria o relatório ou faria download
    }, 3000);
}

function limparCacheSistema() {
    if (confirm('Deseja limpar todo o cache do sistema?')) {
        showLoading();
        
        setTimeout(function() {
            hideLoading();
            showSuccess('Cache do sistema limpo com sucesso!');
        }, 1500);
    }
}

function exportarConfiguracoes() {
    showLoading();
    
    setTimeout(function() {
        hideLoading();
        showSuccess('Configurações exportadas com sucesso!');
        // Aqui iniciaria o download do arquivo
    }, 1000);
}

function importarConfiguracoes() {
    // Criar input file dinamicamente
    const input = document.createElement('input');
    input.type = 'file';
    input.accept = '.json,.sql';
    input.onchange = function(e) {
        const file = e.target.files[0];
        if (file) {
            showLoading();
            setTimeout(function() {
                hideLoading();
                showSuccess('Configurações importadas com sucesso!');
            }, 2000);
        }
    };
    input.click();
}

function reiniciarSistema() {
    if (confirm('Deseja reiniciar o sistema? Todos os usuários serão desconectados.')) {
        showLoading();
        
        setTimeout(function() {
            hideLoading();
            showSuccess('Sistema reiniciado com sucesso!');
            // Aqui você redirecionaria ou recarregaria a página
        }, 3000);
    }
}

function carregarMaisLogs() {
    const container = document.querySelector('.logs-container');
    const novasLinhas = [
        '[' + new Date(Date.now() - 4*3600000).toISOString().slice(0, 19).replace('T', ' ') + '] INFO: Manutenção programada executada',
        '[' + new Date(Date.now() - 5*3600000).toISOString().slice(0, 19).replace('T', ' ') + '] INFO: Sistema de backup verificado',
        '[' + new Date(Date.now() - 6*3600000).toISOString().slice(0, 19).replace('T', ' ') + '] WARNING: Uso de memória alto detectado'
    ];
    
    novasLinhas.forEach(linha => {
        const div = document.createElement('div');
        div.className = 'log-line';
        div.textContent = linha;
        container.appendChild(div);
    });
    
    container.scrollTop = container.scrollHeight;
}

function baixarLogs() {
    // Simular download dos logs
    showLoading();
    
    setTimeout(function() {
        hideLoading();
        showSuccess('Download dos logs iniciado!');
    }, 1000);
}

// Atualizar recursos em tempo real (simulação)
setInterval(function() {
    // Simular mudanças nos recursos
    const recursos = document.querySelectorAll('.recurso-item div div div');
    recursos.forEach((recurso, index) => {
        const valores = [25, 15, 60, 5];
        const variacao = Math.random() * 10 - 5; // -5 a +5
        const novoValor = Math.max(0, Math.min(100, valores[index] + variacao));
        recurso.style.width = novoValor + '%';
        
        // Atualizar texto também
        const texto = recurso.parentElement.previousElementSibling.lastElementChild;
        if (index < 3) {
            texto.textContent = Math.round(novoValor) + '%';
        }
    });
}, 5000);
</script>