<?php if ($erro): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-triangle"></i> <?php echo $erro; ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <i class="fas fa-user-edit"></i> 
        <?php echo isset($usuario) ? 'Editar Usuário' : 'Novo Usuário'; ?>
    </div>
    <div class="card-body">
        <?php 
        $action = isset($usuario) ? 'admin/usuarios/editar/' . $usuario->id : 'admin/usuarios/novo';
        echo form_open($action);
        ?>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <div>
                <div class="form-group">
                    <label for="nome">
                        <i class="fas fa-user"></i> Nome Completo *
                    </label>
                    <input type="text" 
                           id="nome" 
                           name="nome" 
                           class="form-control" 
                           placeholder="Digite o nome completo"
                           value="<?php echo isset($usuario) ? $usuario->nome : set_value('nome'); ?>"
                           required>
                </div>

                <div class="form-group">
                    <label for="email">
                        <i class="fas fa-envelope"></i> E-mail *
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-control" 
                           placeholder="Digite o e-mail"
                           value="<?php echo isset($usuario) ? $usuario->email : set_value('email'); ?>"
                           required>
                </div>

                <div class="form-group">
                    <label for="senha">
                        <i class="fas fa-lock"></i> Senha 
                        <?php echo isset($usuario) ? '(deixe em branco para manter a atual)' : '*'; ?>
                    </label>
                    <input type="password" 
                           id="senha" 
                           name="senha" 
                           class="form-control" 
                           placeholder="Digite a senha"
                           <?php echo !isset($usuario) ? 'required' : ''; ?>>
                    <?php if (!isset($usuario)): ?>
                        <small style="color: #666;">A senha deve ter pelo menos 6 caracteres.</small>
                    <?php endif; ?>
                </div>
            </div>

            <div>
                <div class="form-group">
                    <label for="nivel">
                        <i class="fas fa-shield-alt"></i> Nível de Acesso *
                    </label>
                    <select id="nivel" name="nivel" class="form-control" required>
                        <option value="">Selecione o nível</option>
                        <option value="1" <?php echo (isset($usuario) && $usuario->nivel == 1) || set_value('nivel') == '1' ? 'selected' : ''; ?>>
                            Usuário - Acesso básico
                        </option>
                        <option value="5" <?php echo (isset($usuario) && $usuario->nivel == 5) || set_value('nivel') == '5' ? 'selected' : ''; ?>>
                            Supervisor - Acesso a relatórios
                        </option>
                        <option value="9" <?php echo (isset($usuario) && $usuario->nivel == 9) || set_value('nivel') == '9' ? 'selected' : ''; ?>>
                            Administrador - Acesso total
                        </option>
                    </select>
                </div>

                <?php if (isset($usuario)): ?>
                    <div class="form-group">
                        <label for="ativo">
                            <i class="fas fa-toggle-on"></i> Status
                        </label>
                        <select id="ativo" name="ativo" class="form-control">
                            <option value="1" <?php echo $usuario->ativo ? 'selected' : ''; ?>>
                                Ativo
                            </option>
                            <option value="0" <?php echo !$usuario->ativo ? 'selected' : ''; ?>>
                                Inativo
                            </option>
                        </select>
                    </div>
                <?php endif; ?>

                <div class="form-group">
                    <label>
                        <i class="fas fa-info-circle"></i> Informações
                    </label>
                    <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; border-left: 4px solid #1abc9c;">
                        <p style="margin: 0; font-size: 14px; color: #666;">
                            <strong>Níveis de acesso:</strong><br>
                            • <strong>Usuário (1):</strong> Acesso básico ao sistema<br>
                            • <strong>Supervisor (5):</strong> Acesso a relatórios e supervisão<br>
                            • <strong>Administrador (9):</strong> Acesso total ao sistema
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div style="border-top: 1px solid #dee2e6; padding-top: 20px; margin-top: 20px;">
            <div class="btn-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> 
                    <?php echo isset($usuario) ? 'Atualizar Usuário' : 'Criar Usuário'; ?>
                </button>
                
                <a href="<?php echo site_url('admin/usuarios'); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <?php echo form_close(); ?>
    </div>
</div>

<?php if (isset($usuario)): ?>
    <!-- Informações adicionais do usuário -->
    <div class="card">
        <div class="card-header">
            <i class="fas fa-info"></i> Informações Adicionais
        </div>
        <div class="card-body">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                <div>
                    <strong>Criado em:</strong><br>
                    <span style="color: #666;">
                        <?php echo date('d/m/Y H:i:s', strtotime($usuario->criado_em)); ?>
                    </span>
                </div>
                
                <?php if (isset($usuario->atualizado_em) && $usuario->atualizado_em): ?>
                    <div>
                        <strong>Última atualização:</strong><br>
                        <span style="color: #666;">
                            <?php echo date('d/m/Y H:i:s', strtotime($usuario->atualizado_em)); ?>
                        </span>
                    </div>
                <?php endif; ?>
                
                <div>
                    <strong>Último login:</strong><br>
                    <span style="color: #666;">
                        <?php echo $usuario->ultimo_login ? date('d/m/Y H:i:s', strtotime($usuario->ultimo_login)) : 'Nunca fez login'; ?>
                    </span>
                </div>
                
                <div>
                    <strong>Status:</strong><br>
                    <?php if ($usuario->ativo): ?>
                        <span class="badge badge-success">Ativo</span>
                    <?php else: ?>
                        <span class="badge badge-danger">Inativo</span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<script>
    // Validação adicional do formulário
    document.querySelector('form').addEventListener('submit', function(e) {
        const senha = document.getElementById('senha').value;
        const isEditing = <?php echo isset($usuario) ? 'true' : 'false'; ?>;
        
        if (!isEditing && senha.length < 6) {
            e.preventDefault();
            alert('A senha deve ter pelo menos 6 caracteres.');
            document.getElementById('senha').focus();
            return false;
        }
        
        if (isEditing && senha && senha.length < 6) {
            e.preventDefault();
            alert('Se informada, a nova senha deve ter pelo menos 6 caracteres.');
            document.getElementById('senha').focus();
            return false;
        }
    });

    // Mostrar força da senha
    document.getElementById('senha').addEventListener('input', function() {
        const senha = this.value;
        const forcaDiv = document.getElementById('senha-forca');
        
        if (!forcaDiv) {
            const div = document.createElement('div');
            div.id = 'senha-forca';
            div.style.marginTop = '5px';
            this.parentNode.appendChild(div);
        }
        
        if (senha.length === 0) {
            document.getElementById('senha-forca').innerHTML = '';
            return;
        }
        
        let forca = 0;
        let texto = '';
        let cor = '';
        
        if (senha.length >= 6) forca++;
        if (/[a-z]/.test(senha)) forca++;
        if (/[A-Z]/.test(senha)) forca++;
        if (/[0-9]/.test(senha)) forca++;
        if (/[^A-Za-z0-9]/.test(senha)) forca++;
        
        switch (forca) {
            case 0:
            case 1:
                texto = 'Muito fraca';
                cor = '#e74c3c';
                break;
            case 2:
                texto = 'Fraca';
                cor = '#f39c12';
                break;
            case 3:
                texto = 'Média';
                cor = '#f1c40f';
                break;
            case 4:
                texto = 'Forte';
                cor = '#27ae60';
                break;
            case 5:
                texto = 'Muito forte';
                cor = '#1abc9c';
                break;
        }
        
        document.getElementById('senha-forca').innerHTML = 
            '<small style="color: ' + cor + ';"><i class="fas fa-shield-alt"></i> Força da senha: ' + texto + '</small>';
    });
</script>