<?php if ($sucesso): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i> <?php echo $sucesso; ?>
    </div>
<?php endif; ?>

<?php if ($erro): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-triangle"></i> <?php echo $erro; ?>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
        <span><i class="fas fa-users"></i> Lista de Usuários</span>
        <a href="<?php echo site_url('admin/usuarios/novo'); ?>" class="btn btn-primary btn-sm">
            <i class="fas fa-plus"></i> Novo Usuário
        </a>
    </div>
    <div class="card-body">
        <?php if (!empty($usuarios)): ?>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nome</th>
                            <th>E-mail</th>
                            <th>Nível</th>
                            <th>Status</th>
                            <th>Criado em</th>
                            <th>Último Login</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($usuarios as $usuario): ?>
                            <tr>
                                <td><?php echo $usuario->id; ?></td>
                                <td>
                                    <strong><?php echo $usuario->nome; ?></strong>
                                </td>
                                <td><?php echo $usuario->email; ?></td>
                                <td>
                                    <?php
                                    switch ($usuario->nivel) {
                                        case 9:
                                            echo '<span class="badge badge-danger">Administrador</span>';
                                            break;
                                        case 5:
                                            echo '<span class="badge badge-warning">Supervisor</span>';
                                            break;
                                        case 1:
                                            echo '<span class="badge badge-info">Usuário</span>';
                                            break;
                                        default:
                                            echo '<span class="badge badge-secondary">Indefinido</span>';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php if ($usuario->ativo): ?>
                                        <span class="badge badge-success">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo date('d/m/Y H:i', strtotime($usuario->criado_em)); ?>
                                </td>
                                <td>
                                    <?php if ($usuario->ultimo_login): ?>
                                        <?php echo date('d/m/Y H:i', strtotime($usuario->ultimo_login)); ?>
                                    <?php else: ?>
                                        <span style="color: #999;">Nunca</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="<?php echo site_url('admin/usuarios/editar/' . $usuario->id); ?>" 
                                           class="btn btn-sm btn-secondary" 
                                           title="Editar usuário">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        
                                        <?php if ($usuario->id != $usuario_logado->id): ?>
                                            <a href="<?php echo site_url('admin/usuarios/remover/' . $usuario->id); ?>" 
                                               class="btn btn-sm btn-danger" 
                                               title="Remover usuário"
                                               onclick="return confirm('Tem certeza que deseja remover este usuário?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div style="text-align: center; padding: 40px; color: #666;">
                <i class="fas fa-users" style="font-size: 48px; margin-bottom: 15px;"></i>
                <h3>Nenhum usuário encontrado</h3>
                <p>Clique no botão "Novo Usuário" para adicionar o primeiro usuário.</p>
                <a href="<?php echo site_url('admin/usuarios/novo'); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Criar Primeiro Usuário
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Estatísticas dos usuários -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
    <div class="card">
        <div class="card-body" style="text-align: center;">
            <h3 style="color: #27ae60; margin-bottom: 10px;">
                <?php echo count(array_filter($usuarios, function($u) { return $u->ativo; })); ?>
            </h3>
            <p><i class="fas fa-user-check"></i> Usuários Ativos</p>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body" style="text-align: center;">
            <h3 style="color: #e74c3c; margin-bottom: 10px;">
                <?php echo count(array_filter($usuarios, function($u) { return !$u->ativo; })); ?>
            </h3>
            <p><i class="fas fa-user-times"></i> Usuários Inativos</p>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body" style="text-align: center;">
            <h3 style="color: #f39c12; margin-bottom: 10px;">
                <?php echo count(array_filter($usuarios, function($u) { return $u->nivel == 9; })); ?>
            </h3>
            <p><i class="fas fa-user-shield"></i> Administradores</p>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body" style="text-align: center;">
            <h3 style="color: #3498db; margin-bottom: 10px;">
                <?php echo count(array_filter($usuarios, function($u) { return $u->ultimo_login && strtotime($u->ultimo_login) > strtotime('-7 days'); })); ?>
            </h3>
            <p><i class="fas fa-sign-in-alt"></i> Logins Recentes</p>
        </div>
    </div>
</div>