-- phpMyAdmin SQL Dump
-- version 5.0.4
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Tempo de geração: 22/10/2025 às 16:26
-- Versão do servidor: 10.4.17-MariaDB
-- Versão do PHP: 7.2.34

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Banco de dados: `hajatech_siame.hajatech.com.br`
--
CREATE DATABASE IF NOT EXISTS `hajatech_siame.hajatech.com.br` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `hajatech_siame.hajatech.com.br`;

DELIMITER $$
--
-- Procedimentos
--
DROP PROCEDURE IF EXISTS `LimparLogsAntigos`$$
CREATE PROCEDURE `LimparLogsAntigos` (IN `dias_manter` INT)  BEGIN
    DELETE FROM logs_sistema 
    WHERE criado_em < DATE_SUB(NOW(), INTERVAL dias_manter DAY);
    
    SELECT ROW_COUNT() as logs_removidos;
END$$

--
-- Funções
--
DROP FUNCTION IF EXISTS `VerificarForcaSenha`$$
CREATE FUNCTION `VerificarForcaSenha` (`senha` VARCHAR(255)) RETURNS INT(11) READS SQL DATA
    DETERMINISTIC
BEGIN
    DECLARE forca INT DEFAULT 0;
    
    -- Comprimento mínimo
    IF LENGTH(senha) >= 8 THEN
        SET forca = forca + 1;
    END IF;
    
    -- Contém letras minúsculas
    IF senha REGEXP '[a-z]' THEN
        SET forca = forca + 1;
    END IF;
    
    -- Contém letras maiúsculas
    IF senha REGEXP '[A-Z]' THEN
        SET forca = forca + 1;
    END IF;
    
    -- Contém números
    IF senha REGEXP '[0-9]' THEN
        SET forca = forca + 1;
    END IF;
    
    -- Contém caracteres especiais
    IF senha REGEXP '[^a-zA-Z0-9]' THEN
        SET forca = forca + 1;
    END IF;
    
    RETURN forca;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_leitura_finais`
--

CREATE TABLE `condensado_leitura_finais` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `serie_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `alunos_necessidades_especiais` int(11) DEFAULT 0,
  `le_fluente` int(11) DEFAULT 0,
  `le_pausando` int(11) DEFAULT 0,
  `le_silabando` int(11) DEFAULT 0,
  `le_palavras` int(11) DEFAULT 0,
  `le_silabas` int(11) DEFAULT 0,
  `identifica_letras` int(11) DEFAULT 0,
  `nao_identifica_letras` int(11) DEFAULT 0,
  `utiliza_paragrafos` int(11) DEFAULT 0,
  `utiliza_pontuacao` int(11) DEFAULT 0,
  `sequencia_logica` int(11) DEFAULT 0,
  `utiliza_titulo` int(11) DEFAULT 0,
  `escrita_ortografico` int(11) DEFAULT 0,
  `escrita_alfabetico` int(11) DEFAULT 0,
  `escrita_silabico_alfabetico` int(11) DEFAULT 0,
  `escrita_silabico` int(11) DEFAULT 0,
  `escrita_pre_silabico` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_leitura_finais`
--

INSERT INTO `condensado_leitura_finais` (`id`, `escola_id`, `serie_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `alunos_necessidades_especiais`, `le_fluente`, `le_pausando`, `le_silabando`, `le_palavras`, `le_silabas`, `identifica_letras`, `nao_identifica_letras`, `utiliza_paragrafos`, `utiliza_pontuacao`, `sequencia_logica`, `utiliza_titulo`, `escrita_ortografico`, `escrita_alfabetico`, `escrita_silabico_alfabetico`, `escrita_silabico`, `escrita_pre_silabico`, `created_at`, `updated_at`) VALUES
(1, 10, 27, 46, 2025, 1, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:43:18', '2025-10-22 13:43:18'),
(2, 10, 27, 46, 2025, 2, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:43:23', '2025-10-22 13:43:23');

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_leitura_turma`
--

CREATE TABLE `condensado_leitura_turma` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `serie_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `necessidades_especiais` int(11) DEFAULT 0,
  `le_fluente` int(11) DEFAULT 0,
  `le_pausando` int(11) DEFAULT 0,
  `le_silabando` int(11) DEFAULT 0,
  `le_palavras` int(11) DEFAULT 0,
  `le_silabas` int(11) DEFAULT 0,
  `le_identifica_letras` int(11) DEFAULT 0,
  `le_nao_identifica_letras` int(11) DEFAULT 0,
  `escrita_ortografico` int(11) DEFAULT 0,
  `escrita_alfabetico` int(11) DEFAULT 0,
  `escrita_silabico_alfabetico` int(11) DEFAULT 0,
  `escrita_silabico` int(11) DEFAULT 0,
  `escrita_pre_silabico` int(11) DEFAULT 0,
  `utiliza_paragrafos` int(11) DEFAULT 0,
  `utiliza_pontuacao` int(11) DEFAULT 0,
  `sequencia_logica` int(11) DEFAULT 0,
  `utiliza_titulo` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_leitura_turma`
--

INSERT INTO `condensado_leitura_turma` (`id`, `escola_id`, `serie_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `necessidades_especiais`, `le_fluente`, `le_pausando`, `le_silabando`, `le_palavras`, `le_silabas`, `le_identifica_letras`, `le_nao_identifica_letras`, `escrita_ortografico`, `escrita_alfabetico`, `escrita_silabico_alfabetico`, `escrita_silabico`, `escrita_pre_silabico`, `utiliza_paragrafos`, `utiliza_pontuacao`, `sequencia_logica`, `utiliza_titulo`, `created_at`, `updated_at`) VALUES
(1, 15, 55, 85, 2025, 1, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 12:55:26', '2025-10-22 13:33:49'),
(2, 15, 55, 86, 2025, 1, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:18:49', '2025-10-22 13:18:49'),
(4, 15, 55, 85, 2025, 2, 11, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:33:53', '2025-10-22 13:41:24'),
(5, 15, 55, 85, 2025, 3, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:34:00', '2025-10-22 13:34:00');

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_matematica_finais`
--

CREATE TABLE `condensado_matematica_finais` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `serie_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `alunos_necessidades_especiais` int(11) DEFAULT 0,
  `le_registra_numeros` int(11) DEFAULT 0,
  `interpreta_quantidades` int(11) DEFAULT 0,
  `compara_estabelece_relacoes` int(11) DEFAULT 0,
  `calculo_adicao` int(11) DEFAULT 0,
  `calculo_subtracao` int(11) DEFAULT 0,
  `calculo_multiplicacao` int(11) DEFAULT 0,
  `calculo_divisao` int(11) DEFAULT 0,
  `calculo_potenciacao` int(11) DEFAULT 0,
  `calculo_radiciacao` int(11) DEFAULT 0,
  `resolve_problemas_simples` int(11) DEFAULT 0,
  `resolve_problemas_complexos` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_matematica_finais`
--

INSERT INTO `condensado_matematica_finais` (`id`, `escola_id`, `serie_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `alunos_necessidades_especiais`, `le_registra_numeros`, `interpreta_quantidades`, `compara_estabelece_relacoes`, `calculo_adicao`, `calculo_subtracao`, `calculo_multiplicacao`, `calculo_divisao`, `calculo_potenciacao`, `calculo_radiciacao`, `resolve_problemas_simples`, `resolve_problemas_complexos`, `created_at`, `updated_at`) VALUES
(1, 10, 28, 48, 2025, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, '2025-10-22 12:19:37', '2025-10-22 12:19:37'),
(2, 10, 27, 46, 2025, 1, 10, 0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, '2025-10-22 13:56:27', '2025-10-22 13:56:56'),
(3, 10, 27, 47, 2025, 1, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:56:33', '2025-10-22 13:56:33');

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_matematica_turma`
--

CREATE TABLE `condensado_matematica_turma` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `serie_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `necessidades_especiais` int(11) DEFAULT 0,
  `le_registra_numeros` int(11) DEFAULT 0,
  `interpreta_quantidades` int(11) DEFAULT 0,
  `compara_estabelece_relacoes` int(11) DEFAULT 0,
  `reconhece_numeros` int(11) DEFAULT 0,
  `sequencia_numerica` int(11) DEFAULT 0,
  `realiza_adicao` int(11) DEFAULT 0,
  `realiza_subtracao` int(11) DEFAULT 0,
  `realiza_multiplicacao` int(11) DEFAULT 0,
  `realiza_divisao` int(11) DEFAULT 0,
  `resolve_problemas_simples` int(11) DEFAULT 0,
  `resolve_problemas_complexos` int(11) DEFAULT 0,
  `resolve_problemas` int(11) DEFAULT 0,
  `raciocinio_logico` int(11) DEFAULT 0,
  `nivel_avancado` int(11) DEFAULT 0,
  `nivel_adequado` int(11) DEFAULT 0,
  `nivel_desenvolvimento` int(11) DEFAULT 0,
  `nivel_inicial` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_matematica_turma`
--

INSERT INTO `condensado_matematica_turma` (`id`, `escola_id`, `serie_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `necessidades_especiais`, `le_registra_numeros`, `interpreta_quantidades`, `compara_estabelece_relacoes`, `reconhece_numeros`, `sequencia_numerica`, `realiza_adicao`, `realiza_subtracao`, `realiza_multiplicacao`, `realiza_divisao`, `resolve_problemas_simples`, `resolve_problemas_complexos`, `resolve_problemas`, `raciocinio_logico`, `nivel_avancado`, `nivel_adequado`, `nivel_desenvolvimento`, `nivel_inicial`, `created_at`, `updated_at`) VALUES
(1, 8, 15, 28, 2025, 1, 10, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, '2025-10-22 02:35:13', '2025-10-22 02:35:13'),
(3, 15, 55, 85, 2025, 1, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:43:37', '2025-10-22 13:43:37'),
(4, 15, 55, 85, 2025, 2, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:43:41', '2025-10-22 13:43:41');

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_redacao_finais`
--

CREATE TABLE `condensado_redacao_finais` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `serie_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `alunos_necessidades_especiais` int(11) DEFAULT 0,
  `fluencia_compreensao` int(11) DEFAULT 0,
  `fluencia_interpretacao` int(11) DEFAULT 0,
  `fluencia_oralidade` int(11) DEFAULT 0,
  `producao_ortografia` int(11) DEFAULT 0,
  `producao_pontuacao` int(11) DEFAULT 0,
  `producao_concordancia` int(11) DEFAULT 0,
  `textual_coesao` int(11) DEFAULT 0,
  `textual_coerencia` int(11) DEFAULT 0,
  `textual_genero_tema` int(11) DEFAULT 0,
  `textual_segmentacao` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_redacao_finais`
--

INSERT INTO `condensado_redacao_finais` (`id`, `escola_id`, `serie_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `alunos_necessidades_especiais`, `fluencia_compreensao`, `fluencia_interpretacao`, `fluencia_oralidade`, `producao_ortografia`, `producao_pontuacao`, `producao_concordancia`, `textual_coesao`, `textual_coerencia`, `textual_genero_tema`, `textual_segmentacao`, `created_at`, `updated_at`) VALUES
(1, 10, 27, 46, 2025, 1, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:54:46', '2025-10-22 13:54:46'),
(2, 10, 27, 46, 2025, 2, 20, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:54:50', '2025-10-22 13:57:28');

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_supervisor_1periodo`
--

CREATE TABLE `condensado_supervisor_1periodo` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `alunos_com_laudo` int(11) DEFAULT 0,
  `realiza_pseudoleitura` int(11) DEFAULT 0,
  `reconta_historias` int(11) DEFAULT 0,
  `reconhece_ideia_principal` int(11) DEFAULT 0,
  `le_textos_nao_verbais` int(11) DEFAULT 0,
  `conta_historias` int(11) DEFAULT 0,
  `reconhece_dois_generos` int(11) DEFAULT 0,
  `diferencia_letras_numeros` int(11) DEFAULT 0,
  `nomeia_letras_alfabeto` int(11) DEFAULT 0,
  `reconhece_palavras_mesmo_som` int(11) DEFAULT 0,
  `realiza_copia_textos` int(11) DEFAULT 0,
  `escreve_nome_completo_ficha` int(11) DEFAULT 0,
  `escrita_nivel_silabico` int(11) DEFAULT 0,
  `reconhece_formas_geometricas` int(11) DEFAULT 0,
  `classificacao_tres_criterios` int(11) DEFAULT 0,
  `realiza_seriacao` int(11) DEFAULT 0,
  `contagem_oral_ate_20` int(11) DEFAULT 0,
  `registra_sequencia_ate_10` int(11) DEFAULT 0,
  `representa_quantidades_ate_10` int(11) DEFAULT 0,
  `resolve_problemas_concretos` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_supervisor_1periodo`
--

INSERT INTO `condensado_supervisor_1periodo` (`id`, `escola_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `alunos_com_laudo`, `realiza_pseudoleitura`, `reconta_historias`, `reconhece_ideia_principal`, `le_textos_nao_verbais`, `conta_historias`, `reconhece_dois_generos`, `diferencia_letras_numeros`, `nomeia_letras_alfabeto`, `reconhece_palavras_mesmo_som`, `realiza_copia_textos`, `escreve_nome_completo_ficha`, `escrita_nivel_silabico`, `reconhece_formas_geometricas`, `classificacao_tres_criterios`, `realiza_seriacao`, `contagem_oral_ate_20`, `registra_sequencia_ate_10`, `representa_quantidades_ate_10`, `resolve_problemas_concretos`, `created_at`, `updated_at`) VALUES
(1, 7, 25, 2025, 1, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:50:41', '2025-10-22 14:20:09'),
(2, 7, 25, 2025, 2, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 13:50:46', '2025-10-22 13:50:46');

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_supervisor_2periodo`
--

CREATE TABLE `condensado_supervisor_2periodo` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `alunos_com_laudo` int(11) DEFAULT 0,
  `reconta_historias_completas` int(11) DEFAULT 0,
  `produz_textos_escriba` int(11) DEFAULT 0,
  `reconhece_tres_generos` int(11) DEFAULT 0,
  `reconhece_ideia_principal` int(11) DEFAULT 0,
  `le_textos_nao_verbais` int(11) DEFAULT 0,
  `nomeia_letras_alfabeto` int(11) DEFAULT 0,
  `diferencia_letras_numeros` int(11) DEFAULT 0,
  `escreve_alfabeto_sem_copia` int(11) DEFAULT 0,
  `escreve_nome_sem_ficha` int(11) DEFAULT 0,
  `escrita_silabico_alfabetico` int(11) DEFAULT 0,
  `reconhece_palavras_mesmo_som` int(11) DEFAULT 0,
  `realiza_copia_textos` int(11) DEFAULT 0,
  `utiliza_conservacao` int(11) DEFAULT 0,
  `utiliza_seriacao` int(11) DEFAULT 0,
  `utiliza_classificacao` int(11) DEFAULT 0,
  `registra_sequencia_ate_20` int(11) DEFAULT 0,
  `contagem_oral_ate_30` int(11) DEFAULT 0,
  `identifica_antes_depois_entre` int(11) DEFAULT 0,
  `representa_quantidades_ate_20` int(11) DEFAULT 0,
  `resolve_problemas_adicao` int(11) DEFAULT 0,
  `resolve_problemas_subtracao` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Estrutura para tabela `condensado_supervisor_maternal`
--

CREATE TABLE `condensado_supervisor_maternal` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `turma_id` int(11) NOT NULL,
  `ano_letivo` int(11) NOT NULL,
  `bimestre` int(11) DEFAULT 1,
  `total_alunos` int(11) DEFAULT 0,
  `alunos_com_laudo` int(11) DEFAULT 0,
  `realiza_pseudoleitura` int(11) DEFAULT 0,
  `relata_experiencias` int(11) DEFAULT 0,
  `relata_historias_ouvidas` int(11) DEFAULT 0,
  `representa_historias_pictoricas` int(11) DEFAULT 0,
  `diferencia_letra_desenho` int(11) DEFAULT 0,
  `manuseia_instrumentos_escrita` int(11) DEFAULT 0,
  `identifica_10_letras` int(11) DEFAULT 0,
  `escreve_primeiro_nome` int(11) DEFAULT 0,
  `reconhece_formas_geometricas` int(11) DEFAULT 0,
  `contagem_ate_10` int(11) DEFAULT 0,
  `representa_quantidades_ate_3` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `condensado_supervisor_maternal`
--

INSERT INTO `condensado_supervisor_maternal` (`id`, `escola_id`, `turma_id`, `ano_letivo`, `bimestre`, `total_alunos`, `alunos_com_laudo`, `realiza_pseudoleitura`, `relata_experiencias`, `relata_historias_ouvidas`, `representa_historias_pictoricas`, `diferencia_letra_desenho`, `manuseia_instrumentos_escrita`, `identifica_10_letras`, `escreve_primeiro_nome`, `reconhece_formas_geometricas`, `contagem_ate_10`, `representa_quantidades_ate_3`, `created_at`, `updated_at`) VALUES
(1, 4, 2, 2025, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '2025-10-22 03:26:10', '2025-10-22 03:26:10');

-- --------------------------------------------------------

--
-- Estrutura para tabela `configuracoes`
--

CREATE TABLE `configuracoes` (
  `id` int(11) NOT NULL,
  `titulo_site` varchar(255) DEFAULT 'SIMAE Admin',
  `descricao_site` text DEFAULT 'Sistema de AdministraþÒo',
  `logo_url` varchar(500) DEFAULT NULL,
  `favicon_url` varchar(500) DEFAULT NULL,
  `cor_primaria` varchar(7) DEFAULT '#3b82f6',
  `cor_secundaria` varchar(7) DEFAULT '#10b981',
  `cor_texto` varchar(7) DEFAULT '#374151',
  `cor_fundo` varchar(7) DEFAULT '#f9fafb',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Despejando dados para a tabela `configuracoes`
--

INSERT INTO `configuracoes` (`id`, `titulo_site`, `descricao_site`, `logo_url`, `favicon_url`, `cor_primaria`, `cor_secundaria`, `cor_texto`, `cor_fundo`, `created_at`) VALUES
(1, 'SIMAE', 'Sistema de AdministraþÒo', '../uploads/system/logo_1761009300_favicon_1761009260_logo_1761007964_logo.png', '../uploads/system/favicon_1761009300_favicon_1761009260_logo_1761007964_logo.png', '#3b82f6', '#10b981', '#374151', '#f9fafb', '2025-10-21 01:04:56');

-- --------------------------------------------------------

--
-- Estrutura para tabela `escolas`
--

CREATE TABLE `escolas` (
  `id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `codigo` varchar(50) DEFAULT NULL,
  `endereco` text DEFAULT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `diretor` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Despejando dados para a tabela `escolas`
--

INSERT INTO `escolas` (`id`, `nome`, `codigo`, `endereco`, `telefone`, `email`, `diretor`, `created_at`) VALUES
(4, 'CEMEI TIA FIA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:49:11'),
(5, 'CEMEI RICARDO ROCHA VIANA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:49:11'),
(6, 'CEMEI MARIA SILVESTRE DE SOUZA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:49:11'),
(7, 'CEMEI ANA DE LOURDES NUNES', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:49:11'),
(8, 'CEMEI CRISTOVÃO RODRIGUES CARLOS', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:49:11'),
(9, 'ESCOLA MUNICIPAL JUCA DA ROCHA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(10, 'ESCOLA MUNICIPAL JACINTO SILVEIRA NETO', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(11, 'ESCOLA MUNICIPAL NOSSA SENHORA DA GUIA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(12, 'ESCOLA MUNICIPAL ILDA FERNANDES DE OLIVEIRA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(13, 'ESCOLA MUNICIPAL MESTRE JOSÉ DE MELO', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(14, 'ESCOLA MUNICIPAL SILVÉRIO ROCHA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(15, 'ESCOLA MUNICIPAL ADOLFO FERREIRA DE BARROS', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(16, 'ESCOLA MUNICIPAL VIRGÍLIO MEDEIROS DE BRITO', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18'),
(17, 'ESCOLA MUNICIPAL JOSÉ PATRÍCIO DA SILVEIRA', NULL, NULL, NULL, NULL, NULL, '2025-10-22 01:53:18');

-- --------------------------------------------------------

--
-- Estrutura para tabela `escola_series`
--

CREATE TABLE `escola_series` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `nome_serie` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `escola_series`
--

INSERT INTO `escola_series` (`id`, `escola_id`, `nome_serie`, `created_at`) VALUES
(1, 4, 'MATERNAL', '2025-10-22 01:49:11'),
(2, 4, '1º PERÍODO', '2025-10-22 01:49:11'),
(3, 4, '2º PERÍODO', '2025-10-22 01:49:11'),
(4, 5, 'MATERNAL', '2025-10-22 01:49:11'),
(5, 5, '1º PERÍODO', '2025-10-22 01:49:11'),
(6, 5, '2º PERÍODO', '2025-10-22 01:49:11'),
(7, 6, 'MATERNAL', '2025-10-22 01:49:11'),
(8, 6, '1º PERÍODO', '2025-10-22 01:49:11'),
(9, 6, '2º PERÍODO', '2025-10-22 01:49:11'),
(10, 6, '2ª PERÍODO', '2025-10-22 01:49:11'),
(11, 7, 'MATERNAL', '2025-10-22 01:49:11'),
(12, 7, '1º PERÍODO', '2025-10-22 01:49:11'),
(13, 7, '2º PERÍODO', '2025-10-22 01:49:11'),
(14, 8, 'MATERNAL', '2025-10-22 01:49:11'),
(15, 8, '1º PERÍODO', '2025-10-22 01:49:11'),
(16, 8, '2º PERÍODO', '2025-10-22 01:49:11'),
(17, 9, '1º ANO', '2025-10-22 01:53:18'),
(18, 9, '2º ANO', '2025-10-22 01:53:18'),
(19, 9, '3º ANO', '2025-10-22 01:53:18'),
(20, 9, '4º ANO', '2025-10-22 01:53:18'),
(21, 9, '5º ANO', '2025-10-22 01:53:18'),
(22, 10, '1º ANO', '2025-10-22 01:53:18'),
(23, 10, '2º ANO', '2025-10-22 01:53:18'),
(24, 10, '3º ANO', '2025-10-22 01:53:18'),
(25, 10, '4º ANO', '2025-10-22 01:53:18'),
(26, 10, '5º ANO', '2025-10-22 01:53:18'),
(27, 10, '6º ANO', '2025-10-22 01:53:18'),
(28, 10, '7º ANO', '2025-10-22 01:53:18'),
(29, 10, '8º ANO', '2025-10-22 01:53:18'),
(30, 10, '9º ANO', '2025-10-22 01:53:18'),
(31, 11, '1º ANO', '2025-10-22 01:53:18'),
(32, 11, '2º ANO', '2025-10-22 01:53:18'),
(33, 11, '3º ANO', '2025-10-22 01:53:18'),
(34, 11, '4º ANO', '2025-10-22 01:53:18'),
(35, 11, '5º ANO', '2025-10-22 01:53:18'),
(36, 12, '1º ANO', '2025-10-22 01:53:18'),
(37, 12, '2º ANO', '2025-10-22 01:53:18'),
(38, 12, '3º ANO', '2025-10-22 01:53:18'),
(39, 12, '4º ANO', '2025-10-22 01:53:18'),
(40, 12, '5º ANO', '2025-10-22 01:53:18'),
(41, 13, '1º ANO', '2025-10-22 01:53:18'),
(42, 13, '2º ANO', '2025-10-22 01:53:18'),
(43, 13, '3º ANO', '2025-10-22 01:53:18'),
(44, 13, '4º ANO', '2025-10-22 01:53:18'),
(45, 13, '5º ANO', '2025-10-22 01:53:18'),
(46, 13, '6º ANO', '2025-10-22 01:53:18'),
(47, 13, '7º ANO', '2025-10-22 01:53:18'),
(48, 13, '8º ANO', '2025-10-22 01:53:18'),
(49, 13, '9º ANO', '2025-10-22 01:53:18'),
(50, 14, '1º ANO', '2025-10-22 01:53:18'),
(51, 14, '2º ANO', '2025-10-22 01:53:18'),
(52, 14, '3º ANO', '2025-10-22 01:53:18'),
(53, 14, '4º ANO', '2025-10-22 01:53:18'),
(54, 14, '5º ANO', '2025-10-22 01:53:18'),
(55, 15, '1º ANO', '2025-10-22 01:53:18'),
(56, 15, '2º ANO', '2025-10-22 01:53:18'),
(57, 15, '3º ANO', '2025-10-22 01:53:18'),
(58, 15, '4º ANO', '2025-10-22 01:53:18'),
(59, 15, '5º ANO', '2025-10-22 01:53:18'),
(60, 16, '1º ANO', '2025-10-22 01:53:18'),
(61, 16, '2º ANO', '2025-10-22 01:53:18'),
(62, 16, '3º ANO', '2025-10-22 01:53:18'),
(63, 16, '4º ANO', '2025-10-22 01:53:18'),
(64, 16, '5º ANO', '2025-10-22 01:53:18'),
(65, 17, '1º ANO', '2025-10-22 01:53:18'),
(66, 17, '2º ANO', '2025-10-22 01:53:18'),
(67, 17, '3º ANO', '2025-10-22 01:53:18'),
(68, 17, '4º ANO', '2025-10-22 01:53:18'),
(69, 17, '5º ANO', '2025-10-22 01:53:18');

-- --------------------------------------------------------

--
-- Estrutura para tabela `logs_sistema`
--

CREATE TABLE `logs_sistema` (
  `id` int(11) NOT NULL,
  `usuario_id` int(11) DEFAULT NULL,
  `acao` varchar(255) NOT NULL,
  `descricao` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `criado_em` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Registro de todas as atividades do sistema';

--
-- Despejando dados para a tabela `logs_sistema`
--

INSERT INTO `logs_sistema` (`id`, `usuario_id`, `acao`, `descricao`, `ip_address`, `user_agent`, `criado_em`) VALUES
(1, 4, 'usuario_criado', 'Usuário criado: harley rodrigues (harley@harley.com.br)', NULL, NULL, '2025-10-21 01:22:28');

-- --------------------------------------------------------

--
-- Estrutura para tabela `permissoes`
--

CREATE TABLE `permissoes` (
  `id` int(11) NOT NULL,
  `nome` varchar(100) NOT NULL,
  `descricao` text DEFAULT NULL,
  `modulo` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Despejando dados para a tabela `permissoes`
--

INSERT INTO `permissoes` (`id`, `nome`, `descricao`, `modulo`, `created_at`) VALUES
(116, 'Gerenciar Usuários', 'Criar, editar e excluir usuários', 'usuarios', '2025-10-21 01:18:03'),
(117, 'Visualizar Usuários', 'Apenas visualizar lista de usuários', 'usuarios', '2025-10-21 01:18:03'),
(118, 'Gerenciar Configurações', 'Alterar configurações do sistema', 'configuracoes', '2025-10-21 01:18:03'),
(119, 'Visualizar Relatórios', 'Acesso aos relatórios do sistema', 'relatorios', '2025-10-21 01:18:03'),
(120, 'Administrador Total', 'Acesso completo ao sistema', 'sistema', '2025-10-21 01:18:03'),
(121, 'Gerenciar Condensados', 'Gerenciar condensados educacionais de leitura/escrita e matemßtica', 'condensados', '2025-10-21 01:27:39');

-- --------------------------------------------------------

--
-- Estrutura para tabela `sessoes`
--

CREATE TABLE `sessoes` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  `usuario_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Controle de sessões ativas dos usuários';

-- --------------------------------------------------------

--
-- Estrutura para tabela `turmas`
--

CREATE TABLE `turmas` (
  `id` int(11) NOT NULL,
  `escola_id` int(11) NOT NULL,
  `serie_id` int(11) NOT NULL,
  `nome_turma` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Despejando dados para a tabela `turmas`
--

INSERT INTO `turmas` (`id`, `escola_id`, `serie_id`, `nome_turma`, `created_at`) VALUES
(1, 4, 1, '1', '2025-10-22 01:49:11'),
(2, 4, 1, '2', '2025-10-22 01:49:11'),
(3, 4, 1, '3', '2025-10-22 01:49:11'),
(4, 4, 1, '4', '2025-10-22 01:49:11'),
(5, 4, 2, '1', '2025-10-22 01:49:11'),
(6, 4, 2, '2', '2025-10-22 01:49:11'),
(7, 4, 2, '3', '2025-10-22 01:49:11'),
(8, 4, 3, '1', '2025-10-22 01:49:11'),
(9, 4, 3, '2', '2025-10-22 01:49:11'),
(10, 4, 3, '3', '2025-10-22 01:49:11'),
(11, 5, 4, '1', '2025-10-22 01:49:11'),
(12, 5, 4, '2', '2025-10-22 01:49:11'),
(13, 5, 4, '3', '2025-10-22 01:49:11'),
(14, 5, 5, '1', '2025-10-22 01:49:11'),
(15, 5, 5, '2', '2025-10-22 01:49:11'),
(16, 5, 5, '3', '2025-10-22 01:49:11'),
(17, 5, 6, '1', '2025-10-22 01:49:11'),
(18, 5, 6, '2', '2025-10-22 01:49:11'),
(19, 6, 7, '1', '2025-10-22 01:49:11'),
(20, 6, 7, '2', '2025-10-22 01:49:11'),
(21, 6, 8, '1', '2025-10-22 01:49:11'),
(22, 6, 9, '1', '2025-10-22 01:49:11'),
(23, 6, 10, '2', '2025-10-22 01:49:11'),
(24, 7, 11, '1', '2025-10-22 01:49:11'),
(25, 7, 12, '1', '2025-10-22 01:49:11'),
(26, 7, 13, '1', '2025-10-22 01:49:11'),
(27, 8, 14, '1', '2025-10-22 01:49:11'),
(28, 8, 15, '1', '2025-10-22 01:49:11'),
(29, 8, 16, '1', '2025-10-22 01:49:11'),
(30, 9, 17, '1', '2025-10-22 01:53:18'),
(31, 9, 17, '2', '2025-10-22 01:53:18'),
(32, 9, 18, '1', '2025-10-22 01:53:18'),
(33, 9, 18, '2', '2025-10-22 01:53:18'),
(34, 9, 18, '3', '2025-10-22 01:53:18'),
(35, 9, 19, '1', '2025-10-22 01:53:18'),
(36, 9, 19, '2', '2025-10-22 01:53:18'),
(37, 9, 20, '1', '2025-10-22 01:53:18'),
(38, 9, 20, '2', '2025-10-22 01:53:18'),
(39, 9, 21, '1', '2025-10-22 01:53:18'),
(40, 9, 21, '2', '2025-10-22 01:53:18'),
(41, 10, 22, '1', '2025-10-22 01:53:18'),
(42, 10, 23, '1', '2025-10-22 01:53:18'),
(43, 10, 24, '1', '2025-10-22 01:53:18'),
(44, 10, 25, '1', '2025-10-22 01:53:18'),
(45, 10, 26, '1', '2025-10-22 01:53:18'),
(46, 10, 27, '1', '2025-10-22 01:53:18'),
(47, 10, 27, '2', '2025-10-22 01:53:18'),
(48, 10, 28, '1', '2025-10-22 01:53:18'),
(49, 10, 28, '2', '2025-10-22 01:53:18'),
(50, 10, 29, '1', '2025-10-22 01:53:18'),
(51, 10, 29, '2', '2025-10-22 01:53:18'),
(52, 10, 30, '1', '2025-10-22 01:53:18'),
(53, 10, 30, '2', '2025-10-22 01:53:18'),
(54, 11, 31, '1', '2025-10-22 01:53:18'),
(55, 11, 31, '2', '2025-10-22 01:53:18'),
(56, 11, 32, '1', '2025-10-22 01:53:18'),
(57, 11, 32, '2', '2025-10-22 01:53:18'),
(58, 11, 33, '1', '2025-10-22 01:53:18'),
(59, 11, 33, '2', '2025-10-22 01:53:18'),
(60, 11, 34, '1', '2025-10-22 01:53:18'),
(61, 11, 34, '2', '2025-10-22 01:53:18'),
(62, 11, 35, '1', '2025-10-22 01:53:18'),
(63, 11, 35, '2', '2025-10-22 01:53:18'),
(64, 11, 35, '3', '2025-10-22 01:53:18'),
(65, 12, 36, '1', '2025-10-22 01:53:18'),
(66, 12, 37, '1', '2025-10-22 01:53:18'),
(67, 12, 38, '1', '2025-10-22 01:53:18'),
(68, 12, 38, '2', '2025-10-22 01:53:18'),
(69, 12, 39, '1', '2025-10-22 01:53:18'),
(70, 12, 40, '1', '2025-10-22 01:53:18'),
(71, 13, 41, '1', '2025-10-22 01:53:18'),
(72, 13, 42, '1', '2025-10-22 01:53:18'),
(73, 13, 43, '1', '2025-10-22 01:53:18'),
(74, 13, 44, '1', '2025-10-22 01:53:18'),
(75, 13, 45, '1', '2025-10-22 01:53:18'),
(76, 13, 46, '1', '2025-10-22 01:53:18'),
(77, 13, 47, '1', '2025-10-22 01:53:18'),
(78, 13, 48, '1', '2025-10-22 01:53:18'),
(79, 13, 49, '1', '2025-10-22 01:53:18'),
(80, 14, 50, '1', '2025-10-22 01:53:18'),
(81, 14, 51, '1', '2025-10-22 01:53:18'),
(82, 14, 52, '1', '2025-10-22 01:53:18'),
(83, 14, 53, '1', '2025-10-22 01:53:18'),
(84, 14, 54, '1', '2025-10-22 01:53:18'),
(85, 15, 55, '1', '2025-10-22 01:53:18'),
(86, 15, 56, '1', '2025-10-22 01:53:18'),
(87, 15, 57, '1', '2025-10-22 01:53:18'),
(88, 15, 58, '1', '2025-10-22 01:53:18'),
(89, 15, 59, '1', '2025-10-22 01:53:18'),
(90, 16, 60, '1', '2025-10-22 01:53:18'),
(91, 16, 61, '1', '2025-10-22 01:53:18'),
(92, 16, 62, '1', '2025-10-22 01:53:18'),
(93, 16, 63, '1', '2025-10-22 01:53:18'),
(94, 16, 64, '1', '2025-10-22 01:53:18'),
(95, 17, 65, '1', '2025-10-22 01:53:18'),
(96, 17, 66, '1', '2025-10-22 01:53:18'),
(97, 17, 67, '1', '2025-10-22 01:53:18'),
(98, 17, 68, '1', '2025-10-22 01:53:18'),
(99, 17, 69, '1', '2025-10-22 01:53:18');

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nome` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `nivel` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=Usuário, 5=Supervisor, 9=Administrador',
  `ativo` tinyint(1) NOT NULL DEFAULT 1 COMMENT '1=Ativo, 0=Inativo',
  `criado_em` timestamp NOT NULL DEFAULT current_timestamp(),
  `atualizado_em` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `ultimo_login` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabela principal de usuários do sistema administrativo';

--
-- Despejando dados para a tabela `usuarios`
--

INSERT INTO `usuarios` (`id`, `nome`, `email`, `senha`, `nivel`, `ativo`, `criado_em`, `atualizado_em`, `ultimo_login`) VALUES
(1, 'Administrador', 'admin@simae.com', '$2y$10$e1jGuTDHu5jdWJom6yvLBeFftF0jVCUHISMvWUFT5VhfEj59Sw4rS', 9, 1, '2025-10-21 00:27:28', '2025-10-22 12:40:09', '2025-10-22 12:40:09'),
(2, 'Supervisor Teste', 'supervisor@simae.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 5, 1, '2025-10-21 00:27:28', NULL, NULL),
(3, 'Usuário Teste', 'usuario@simae.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 1, 1, '2025-10-21 00:27:28', NULL, NULL),
(4, 'harley rodrigues', 'harley@harley.com.br', '$2y$10$k1smGlIDhzFeAZ7vr16aGeQUcD10T.KVVhglfOiWSkEg18PsS4hxO', 1, 1, '2025-10-21 01:22:28', NULL, NULL);

--
-- Gatilhos `usuarios`
--
DELIMITER $$
DROP TRIGGER IF EXISTS `log_usuarios_insert`$$
CREATE TRIGGER `log_usuarios_insert` AFTER INSERT ON `usuarios` FOR EACH ROW BEGIN
    INSERT INTO logs_sistema (usuario_id, acao, descricao) 
    VALUES (NEW.id, 'usuario_criado', 
            CONCAT('Usuário criado: ', NEW.nome, ' (', NEW.email, ')'));
END
$$
DELIMITER ;
DELIMITER $$
DROP TRIGGER IF EXISTS `log_usuarios_update`$$
CREATE TRIGGER `log_usuarios_update` AFTER UPDATE ON `usuarios` FOR EACH ROW BEGIN
    IF OLD.ativo != NEW.ativo THEN
        INSERT INTO logs_sistema (usuario_id, acao, descricao) 
        VALUES (NEW.id, 'usuario_status_alterado', 
                CONCAT('Status alterado de ', IF(OLD.ativo, 'Ativo', 'Inativo'), 
                       ' para ', IF(NEW.ativo, 'Ativo', 'Inativo')));
    END IF;
    
    IF OLD.nivel != NEW.nivel THEN
        INSERT INTO logs_sistema (usuario_id, acao, descricao) 
        VALUES (NEW.id, 'usuario_nivel_alterado', 
                CONCAT('Nível alterado de ', OLD.nivel, ' para ', NEW.nivel));
    END IF;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuario_permissoes`
--

CREATE TABLE `usuario_permissoes` (
  `usuario_id` int(11) NOT NULL,
  `permissao_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Despejando dados para a tabela `usuario_permissoes`
--

INSERT INTO `usuario_permissoes` (`usuario_id`, `permissao_id`) VALUES
(1, 116),
(1, 117),
(1, 118),
(1, 119),
(1, 120),
(1, 121);

-- --------------------------------------------------------

--
-- Estrutura stand-in para view `view_estatisticas_usuarios`
-- (Veja abaixo para a visão atual)
--
CREATE TABLE `view_estatisticas_usuarios` (
`total_usuarios` bigint(21)
,`usuarios_ativos` bigint(21)
,`usuarios_inativos` bigint(21)
,`administradores` bigint(21)
,`supervisores` bigint(21)
,`usuarios_basicos` bigint(21)
,`logins_recentes` bigint(21)
);

-- --------------------------------------------------------

--
-- Estrutura para view `view_estatisticas_usuarios`
--
DROP TABLE IF EXISTS `view_estatisticas_usuarios`;

CREATE VIEW `view_estatisticas_usuarios` AS SELECT count(0) AS `total_usuarios`, count(case when `usuarios`.`ativo` = 1 then 1 end) AS `usuarios_ativos`, count(case when `usuarios`.`ativo` = 0 then 1 end) AS `usuarios_inativos`, count(case when `usuarios`.`nivel` = 9 then 1 end) AS `administradores`, count(case when `usuarios`.`nivel` = 5 then 1 end) AS `supervisores`, count(case when `usuarios`.`nivel` = 1 then 1 end) AS `usuarios_basicos`, count(case when `usuarios`.`ultimo_login` >= current_timestamp() - interval 7 day then 1 end) AS `logins_recentes` FROM `usuarios` ;

--
-- Índices para tabelas despejadas
--

--
-- Índices de tabela `condensado_leitura_finais`
--
ALTER TABLE `condensado_leitura_finais`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`serie_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_leitura_turma`
--
ALTER TABLE `condensado_leitura_turma`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`serie_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_matematica_finais`
--
ALTER TABLE `condensado_matematica_finais`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`serie_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_matematica_turma`
--
ALTER TABLE `condensado_matematica_turma`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`serie_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_redacao_finais`
--
ALTER TABLE `condensado_redacao_finais`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`serie_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_supervisor_1periodo`
--
ALTER TABLE `condensado_supervisor_1periodo`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_supervisor_2periodo`
--
ALTER TABLE `condensado_supervisor_2periodo`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `condensado_supervisor_maternal`
--
ALTER TABLE `condensado_supervisor_maternal`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma_ano_bimestre` (`escola_id`,`turma_id`,`ano_letivo`,`bimestre`);

--
-- Índices de tabela `configuracoes`
--
ALTER TABLE `configuracoes`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `escolas`
--
ALTER TABLE `escolas`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `escola_series`
--
ALTER TABLE `escola_series`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_escola_serie` (`escola_id`,`nome_serie`),
  ADD KEY `idx_escola` (`escola_id`);

--
-- Índices de tabela `logs_sistema`
--
ALTER TABLE `logs_sistema`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_usuario_id` (`usuario_id`),
  ADD KEY `idx_acao` (`acao`),
  ADD KEY `idx_criado_em` (`criado_em`),
  ADD KEY `idx_logs_sistema_criado_em` (`criado_em`),
  ADD KEY `idx_logs_sistema_acao_criado` (`acao`,`criado_em`);

--
-- Índices de tabela `permissoes`
--
ALTER TABLE `permissoes`
  ADD PRIMARY KEY (`id`);

--
-- Índices de tabela `sessoes`
--
ALTER TABLE `sessoes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_timestamp` (`timestamp`),
  ADD KEY `idx_usuario_id` (`usuario_id`);

--
-- Índices de tabela `turmas`
--
ALTER TABLE `turmas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_turma` (`escola_id`,`serie_id`,`nome_turma`),
  ADD KEY `idx_escola` (`escola_id`),
  ADD KEY `idx_serie` (`serie_id`);

--
-- Índices de tabela `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `idx_email` (`email`),
  ADD KEY `idx_nivel` (`nivel`),
  ADD KEY `idx_ativo` (`ativo`),
  ADD KEY `idx_ultimo_login` (`ultimo_login`);

--
-- Índices de tabela `usuario_permissoes`
--
ALTER TABLE `usuario_permissoes`
  ADD PRIMARY KEY (`usuario_id`,`permissao_id`),
  ADD KEY `permissao_id` (`permissao_id`);

--
-- AUTO_INCREMENT para tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `condensado_leitura_finais`
--
ALTER TABLE `condensado_leitura_finais`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `condensado_leitura_turma`
--
ALTER TABLE `condensado_leitura_turma`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de tabela `condensado_matematica_finais`
--
ALTER TABLE `condensado_matematica_finais`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT de tabela `condensado_matematica_turma`
--
ALTER TABLE `condensado_matematica_turma`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de tabela `condensado_redacao_finais`
--
ALTER TABLE `condensado_redacao_finais`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `condensado_supervisor_1periodo`
--
ALTER TABLE `condensado_supervisor_1periodo`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `condensado_supervisor_2periodo`
--
ALTER TABLE `condensado_supervisor_2periodo`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT de tabela `condensado_supervisor_maternal`
--
ALTER TABLE `condensado_supervisor_maternal`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `configuracoes`
--
ALTER TABLE `configuracoes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `escolas`
--
ALTER TABLE `escolas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT de tabela `escola_series`
--
ALTER TABLE `escola_series`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=70;

--
-- AUTO_INCREMENT de tabela `logs_sistema`
--
ALTER TABLE `logs_sistema`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT de tabela `permissoes`
--
ALTER TABLE `permissoes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=122;

--
-- AUTO_INCREMENT de tabela `turmas`
--
ALTER TABLE `turmas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=100;

--
-- AUTO_INCREMENT de tabela `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- Restrições para tabelas despejadas
--

--
-- Restrições para tabelas `logs_sistema`
--
ALTER TABLE `logs_sistema`
  ADD CONSTRAINT `logs_sistema_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Restrições para tabelas `sessoes`
--
ALTER TABLE `sessoes`
  ADD CONSTRAINT `sessoes_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `usuario_permissoes`
--
ALTER TABLE `usuario_permissoes`
  ADD CONSTRAINT `usuario_permissoes_ibfk_1` FOREIGN KEY (`usuario_id`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `usuario_permissoes_ibfk_2` FOREIGN KEY (`permissao_id`) REFERENCES `permissoes` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
