<?php
// Define a pasta base do sistema
define('BASEPATH', __DIR__ . '/system/');

// Carrega configurações de banco de dados
require_once __DIR__ . '/admin/config/database.php';

// Mostra erros em desenvolvimento
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Inicia a sessão
if (!session_id()) {
    session_start();
}

// Define constantes úteis
define('APPPATH', __DIR__ . '/application/');
define('VIEWPATH', APPPATH . 'views/');

// Buscar configurações do sistema
$config = [];
try {
    $pdo = getDBConnection();
    $stmt = $pdo->query("SELECT * FROM configuracoes WHERE id = 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Se não encontrar configuração, usar valores padrão
    if (!$config) {
        $config = [
            'titulo_site' => 'SIMAE',
            'descricao_site' => 'Sistema de Administração',
            'logo_url' => '',
            'cor_primaria' => '#22c55e'
        ];
    }
} catch (Exception $e) {
    $config = [
        'titulo_site' => 'SIMAE',
        'descricao_site' => 'Sistema de Administração',
        'logo_url' => '',
        'cor_primaria' => '#22c55e'
    ];
}

// Pega a URL atual
$url = $_SERVER['REQUEST_URI'];
$path = str_replace('/simae/', '', $url);
$path = trim($path, '/');

// Se vazio, mostrar página inicial
if (empty($path)) {
    echo "<!DOCTYPE html>
<html lang='pt-BR'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>" . htmlspecialchars($config['titulo_site']) . " - Sistema de Administração</title>
    <script src='https://cdn.tailwindcss.com'></script>
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css'>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0fdf4',
                            100: '#dcfce7',
                            200: '#bbf7d0',
                            300: '#86efac',
                            400: '#4ade80',
                            500: '" . ($config['cor_primaria'] ?? '#22c55e') . "',
                            600: '#16a34a',
                            700: '#15803d',
                            800: '#166534',
                            900: '#14532d',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 50%, #bbf7d0 100%); }
        .gradient-text { background: linear-gradient(135deg, #15803d, #22c55e); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; }
        .animate-float { animation: float 6s ease-in-out infinite; }
        @keyframes float { 0%, 100% { transform: translateY(0px); } 50% { transform: translateY(-20px); } }
        .glass-effect { backdrop-filter: blur(16px); background: rgba(255, 255, 255, 0.9); }
    </style>
</head>
<body class='gradient-bg min-h-screen'>
    <!-- Elementos decorativos -->
    <div class='absolute inset-0 overflow-hidden'>
        <div class='absolute top-1/4 left-1/4 w-64 h-64 bg-primary-200 opacity-30 rounded-full animate-float'></div>
        <div class='absolute top-3/4 right-1/4 w-80 h-80 bg-primary-300 opacity-20 rounded-full animate-float' style='animation-delay: -3s;'></div>
        <div class='absolute bottom-1/4 left-1/3 w-48 h-48 bg-primary-400 opacity-25 rounded-full animate-float' style='animation-delay: -1.5s;'></div>
    </div>

    <!-- Conteúdo principal -->
    <div class='relative min-h-screen flex items-center justify-center p-4'>
        <div class='glass-effect rounded-3xl shadow-2xl border border-white border-opacity-20 overflow-hidden max-w-2xl w-full'>
            <!-- Header -->
            <div class='bg-gradient-to-r from-primary-600 to-primary-700 px-8 py-16 text-center text-white relative'>
                <div class='absolute inset-0 bg-black bg-opacity-10'></div>
                <div class='relative z-10'>
                    <div class='inline-flex items-center justify-center w-24 h-24 bg-white bg-opacity-20 rounded-3xl mb-8 animate-float'>
                        " . (!empty($config['logo_url']) ? 
                            "<img src='" . htmlspecialchars($config['logo_url']) . "' alt='Logo' class='w-16 h-16 object-contain'>" : 
                            "<i class='fas fa-shield-alt text-4xl'></i>"
                        ) . "
                    </div>
                    <h1 class='text-5xl font-bold mb-4'>" . htmlspecialchars($config['titulo_site']) . "</h1>
                    <p class='text-xl text-primary-100 mb-8'>" . htmlspecialchars($config['descricao_site']) . "</p>
                    <div class='inline-flex items-center bg-white bg-opacity-20 rounded-full px-4 py-2'>
                        <div class='w-2 h-2 bg-primary-300 rounded-full mr-2 animate-pulse'></div>
                        <span class='text-sm font-medium'>Sistema Online</span>
                    </div>
                </div>
            </div>

            <!-- Corpo -->
            <div class='p-8 lg:p-12'>
                <!-- Descrição -->
                <div class='text-center mb-12'>
                    <h2 class='text-3xl font-bold gradient-text mb-4'>Bem-vindo ao " . htmlspecialchars($config['titulo_site']) . "</h2>
                    <p class='text-gray-600 text-lg leading-relaxed'>
                        " . htmlspecialchars($config['descricao_site']) . " - Acesse o painel administrativo para gerenciar usuários, configurações e visualizar relatórios do sistema.
                    </p>
                </div>

                <!-- Botão de ação -->
                <div class='space-y-4 mb-8'>
                    <a href='admin/login.php' class='w-full bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 text-white font-semibold py-4 px-8 rounded-xl transition-all duration-300 transform hover:scale-[1.02] hover:shadow-lg flex items-center justify-center space-x-3'>
                        <i class='fas fa-sign-in-alt text-xl'></i>
                        <span class='text-lg'>Entrar no Sistema</span>
                    </a>
                </div>
            </div>

            <!-- Footer -->
            <div class='bg-gray-50 px-8 py-6 text-center border-t border-gray-200'>
                <p class='text-gray-500 text-sm'>
                    © 2025 SIMAE - Sistema de Administração com Tailwind CSS
                </p>
            </div>
        </div>
    </div>

    <script>
        // Animações de entrada
        document.addEventListener('DOMContentLoaded', function() {
            // Fade in do conteúdo
            document.body.style.opacity = '0';
            document.body.style.transition = 'opacity 0.8s ease';
            setTimeout(() => {
                document.body.style.opacity = '1';
            }, 100);
        });

        // Efeito de partículas no hover dos botões
        document.querySelectorAll('a').forEach(button => {
            button.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
            });
            button.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    </script>
</body>
</html>";
    exit;
}

// Se for admin/login
if ($path === 'admin/login') {
    // Carrega configuração centralizada
    require_once __DIR__ . '/admin/config/database.php';
    
    // Configuração do banco
    $db_config = array(
        'hostname' => DB_HOST,
        'username' => DB_USER,
        'password' => DB_PASS,
        'database' => DB_NAME
    );
    
    // Verificar se é POST (login)
    if ($_POST) {
        $email = $_POST['email'] ?? '';
        $senha = $_POST['senha'] ?? '';
        
        if ($email && $senha) {
            // Conectar ao banco
            $conn = new mysqli($db_config['hostname'], $db_config['username'], $db_config['password'], $db_config['database']);
            
            if (!$conn->connect_error) {
                // Verificar usuário
                $stmt = $conn->prepare("SELECT id, nome, email, senha FROM usuarios WHERE email = ? AND ativo = 1");
                $stmt->bind_param("s", $email);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($user = $result->fetch_assoc()) {
                    if (password_verify($senha, $user['senha'])) {
                        // Login válido
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['user_nome'] = $user['nome'];
                        $_SESSION['user_email'] = $user['email'];
                        $_SESSION['logged_in'] = true;
                        
                        header("Location: /simae/admin/dashboard");
                        exit;
                    }
                }
                
                $erro = "Email ou senha incorretos!";
                $conn->close();
            } else {
                $erro = "Erro de conexão com banco de dados!";
            }
        } else {
            $erro = "Preencha todos os campos!";
        }
    }
    
    // Mostrar formulário de login
    include 'application/views/admin/login.php';
    exit;
}

// Se for admin/dashboard
if ($path === 'admin/dashboard') {
    // Verificar se está logado
    if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
        header("Location: /simae/admin/login");
        exit;
    }
    
    // Carregar dashboard
    include 'application/views/admin/dashboard.php';
    exit;
}

// Se for logout
if ($path === 'admin/logout') {
    session_destroy();
    header("Location: /simae/admin/login");
    exit;
}

// Página não encontrada
echo "<!DOCTYPE html>
<html>
<head>
    <title>Página não encontrada</title>
    <style>
        body { font-family: Arial; margin: 50px; text-align: center; background: #f8f9fa; }
        .container { max-width: 400px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; }
        h1 { color: #e74c3c; }
        .button { background: #3498db; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>404 - Página não encontrada</h1>
        <p>A página que você procura não existe.</p>
        <a href='/simae/' class='button'>🏠 Voltar ao Início</a>
    </div>
</body>
</html>";
?>