<?php
/**
 * CodeIgniter Core Bootstrap File
 * Versão simplificada para o SIMAE
 */

defined('BASEPATH') OR exit('No direct script access allowed');

// Carregamento básico das classes essenciais
class CI_Controller {
    private static $instance;
    
    public function __construct() {
        self::$instance =& $this;
        log_message('info', 'Controller Class Initialized');
        $this->load =& load_class('Loader', 'core');
        $this->input =& load_class('Input', 'core');
        $this->output =& load_class('Output', 'core');
        $this->uri =& load_class('URI', 'core');
        $this->router =& load_class('Router', 'core');
    }
    
    public static function &get_instance() {
        return self::$instance;
    }
    
    public function __get($key) {
        return get_instance()->$key;
    }
}

function &get_instance() {
    return CI_Controller::get_instance();
}

// Carregar configurações
require_once(APPPATH.'config/config.php');
require_once(APPPATH.'config/autoload.php');
require_once(APPPATH.'config/database.php');
require_once(APPPATH.'config/routes.php');

// Função para carregar classes
function &load_class($class, $directory = 'libraries', $param = NULL) {
    static $_classes = array();
    
    if (isset($_classes[$class])) {
        return $_classes[$class];
    }
    
    $name = FALSE;
    
    // Look for the class first in the local application/libraries folder
    // then in the native system/libraries folder
    foreach (array(APPPATH, BASEPATH) as $path) {
        if (file_exists($path.$directory.'/'.$class.'.php')) {
            $name = 'CI_'.$class;
            
            if (class_exists($name, FALSE) === FALSE) {
                require_once($path.$directory.'/'.$class.'.php');
            }
            
            break;
        }
    }
    
    // Fallback para classes simplificadas
    if ($name === FALSE) {
        switch ($class) {
            case 'Loader':
                $name = 'CI_Loader';
                $_classes[$class] = new CI_Loader();
                break;
            case 'Input':
                $name = 'CI_Input';
                $_classes[$class] = new CI_Input();
                break;
            case 'Output':
                $name = 'CI_Output';
                $_classes[$class] = new CI_Output();
                break;
            case 'URI':
                $name = 'CI_URI';
                $_classes[$class] = new CI_URI();
                break;
            case 'Router':
                $name = 'CI_Router';
                $_classes[$class] = new CI_Router();
                break;
            default:
                $_classes[$class] = new stdClass();
        }
    } else {
        $_classes[$class] = isset($param) ? new $name($param) : new $name();
    }
    
    return $_classes[$class];
}

// Classes básicas simplificadas
class CI_Loader {
    public function __construct() {}
    
    public function library($library) {
        $CI =& get_instance();
        if (!isset($CI->$library)) {
            if (file_exists(APPPATH.'libraries/'.ucfirst($library).'.php')) {
                require_once(APPPATH.'libraries/'.ucfirst($library).'.php');
                $CI->$library = new $library();
            } else {
                // Bibliotecas básicas
                switch (strtolower($library)) {
                    case 'session':
                        if (!isset($_SESSION)) session_start();
                        $CI->session = new CI_Session();
                        break;
                    case 'database':
                        $CI->db = new CI_DB();
                        break;
                    case 'form_validation':
                        $CI->form_validation = new CI_Form_validation();
                        break;
                }
            }
        }
    }
    
    public function model($model) {
        $CI =& get_instance();
        $model_name = basename($model, '.php');
        if (!isset($CI->$model_name)) {
            require_once(APPPATH.'models/'.$model.'.php');
            $CI->$model_name = new $model_name();
        }
    }
    
    public function view($view, $vars = array(), $return = FALSE) {
        extract($vars);
        
        if ($return) {
            ob_start();
            include(APPPATH.'views/'.$view.'.php');
            return ob_get_clean();
        } else {
            include(APPPATH.'views/'.$view.'.php');
        }
    }
    
    public function helper($helper) {
        if (is_array($helper)) {
            foreach ($helper as $h) {
                $this->helper($h);
            }
            return;
        }
        
        if (file_exists(APPPATH.'helpers/'.$helper.'_helper.php')) {
            include_once(APPPATH.'helpers/'.$helper.'_helper.php');
        }
    }
}

class CI_Input {
    public function post($index = NULL, $xss_clean = NULL) {
        if ($index === NULL) {
            return $_POST;
        }
        return isset($_POST[$index]) ? $_POST[$index] : NULL;
    }
    
    public function get($index = NULL, $xss_clean = NULL) {
        if ($index === NULL) {
            return $_GET;
        }
        return isset($_GET[$index]) ? $_GET[$index] : NULL;
    }
}

class CI_Output {
    private $final_output = '';
    
    public function set_output($output) {
        $this->final_output = $output;
        return $this;
    }
    
    public function _display() {
        echo $this->final_output;
    }
}

class CI_URI {
    public $segments = array();
    
    public function __construct() {
        $this->_fetch_uri_string();
    }
    
    private function _fetch_uri_string() {
        $uri = $_SERVER['REQUEST_URI'];
        $uri = str_replace('/simae/index.php', '', $uri);
        $uri = str_replace('/simae/', '', $uri);
        $uri = trim($uri, '/');
        
        if (!empty($uri)) {
            $this->segments = explode('/', $uri);
        }
    }
    
    public function segment($n) {
        return isset($this->segments[$n-1]) ? $this->segments[$n-1] : NULL;
    }
    
    public function segment_array() {
        return $this->segments;
    }
}

class CI_Router {
    public function __construct() {
        global $route;
        $this->routes = $route;
    }
}

class CI_Session {
    public function __construct() {
        if (!isset($_SESSION)) {
            session_start();
        }
    }
    
    public function userdata($item) {
        return isset($_SESSION[$item]) ? $_SESSION[$item] : NULL;
    }
    
    public function set_userdata($data) {
        if (is_array($data)) {
            foreach ($data as $key => $val) {
                $_SESSION[$key] = $val;
            }
        }
    }
    
    public function unset_userdata($key) {
        unset($_SESSION[$key]);
    }
    
    public function sess_destroy() {
        session_destroy();
    }
    
    public function flashdata($key) {
        $value = isset($_SESSION['_flash_'.$key]) ? $_SESSION['_flash_'.$key] : NULL;
        unset($_SESSION['_flash_'.$key]);
        return $value;
    }
    
    public function set_flashdata($key, $value) {
        $_SESSION['_flash_'.$key] = $value;
    }
}

class CI_DB {
    private $conn;
    private $last_query;
    
    public function __construct() {
        global $db;
        $config = $db['default'];
        
        $this->conn = new mysqli(
            $config['hostname'],
            $config['username'],
            $config['password'],
            $config['database']
        );
        
        if ($this->conn->connect_error) {
            show_error('Database connection failed: ' . $this->conn->connect_error);
        }
        
        $this->conn->set_charset($config['char_set']);
    }
    
    public function query($sql) {
        $this->last_query = $sql;
        $result = $this->conn->query($sql);
        
        if ($result === false) {
            show_error('Database Error: ' . $this->conn->error . '<br>Query: ' . $sql);
        }
        
        return new CI_DB_result($result);
    }
    
    public function get($table) {
        $sql = "SELECT * FROM `$table`";
        return $this->query($sql);
    }
    
    public function where($key, $value) {
        // Implementação básica - em produção seria mais robusta
        return $this;
    }
    
    public function insert($table, $data) {
        $fields = implode('`, `', array_keys($data));
        $values = "'" . implode("', '", array_values($data)) . "'";
        $sql = "INSERT INTO `$table` (`$fields`) VALUES ($values)";
        
        return $this->conn->query($sql);
    }
    
    public function update($table, $data) {
        $set = array();
        foreach ($data as $key => $value) {
            $set[] = "`$key` = '$value'";
        }
        $sql = "UPDATE `$table` SET " . implode(', ', $set);
        
        return $this->conn->query($sql);
    }
    
    public function count_all($table) {
        $result = $this->query("SELECT COUNT(*) as count FROM `$table`");
        $row = $result->row();
        return $row->count;
    }
}

class CI_DB_result {
    private $result;
    
    public function __construct($result) {
        $this->result = $result;
    }
    
    public function row() {
        return $this->result->fetch_object();
    }
    
    public function result() {
        $rows = array();
        while ($row = $this->result->fetch_object()) {
            $rows[] = $row;
        }
        return $rows;
    }
    
    public function num_rows() {
        return $this->result->num_rows;
    }
}

class CI_Form_validation {
    private $rules = array();
    private $errors = array();
    
    public function set_rules($field, $label, $rules) {
        $this->rules[] = array(
            'field' => $field,
            'label' => $label,
            'rules' => $rules
        );
    }
    
    public function run() {
        $CI =& get_instance();
        
        foreach ($this->rules as $rule) {
            $value = $CI->input->post($rule['field']);
            $rules = explode('|', $rule['rules']);
            
            foreach ($rules as $r) {
                if ($r == 'required' && empty($value)) {
                    $this->errors[] = $rule['label'] . ' é obrigatório.';
                } elseif ($r == 'valid_email' && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
                    $this->errors[] = $rule['label'] . ' deve ser um email válido.';
                } elseif (strpos($r, 'min_length') === 0) {
                    $min = str_replace('min_length[', '', str_replace(']', '', $r));
                    if (strlen($value) < $min) {
                        $this->errors[] = $rule['label'] . ' deve ter pelo menos ' . $min . ' caracteres.';
                    }
                }
            }
        }
        
        return empty($this->errors);
    }
}

// Funções auxiliares
function show_error($message, $status_code = 500) {
    http_response_code($status_code);
    echo "<h1>Erro $status_code</h1><p>$message</p>";
    exit;
}

function show_404() {
    show_error('Página não encontrada', 404);
}

function redirect($uri = '', $method = 'auto', $code = NULL) {
    if (!preg_match('#^(\w+:)?//#i', $uri)) {
        $uri = site_url($uri);
    }
    
    header("Location: $uri", TRUE, $code ?: 302);
    exit;
}

function site_url($uri = '') {
    global $config;
    return $config['base_url'] . $uri;
}

function base_url($uri = '') {
    global $config;
    return $config['base_url'] . $uri;
}

function uri_string() {
    $CI =& get_instance();
    return implode('/', $CI->uri->segment_array());
}

function log_message($level, $message) {
    // Log básico - em produção seria mais robusto
    error_log("[$level] $message");
}

function set_value($field, $default = '') {
    $CI =& get_instance();
    return $CI->input->post($field) ?: $default;
}

function validation_errors() {
    $CI =& get_instance();
    return isset($CI->form_validation) ? implode('<br>', $CI->form_validation->errors) : '';
}

// Helpers de formulário
function form_open($action = '', $attributes = '') {
    return '<form action="' . site_url($action) . '" method="post">';
}

function form_close() {
    return '</form>';
}

// Carregar o controller apropriado
$RTR =& load_class('Router', 'core');
$URI =& load_class('URI', 'core');

// Determinar o controller
$directory = '';
$controller = 'Login';
$method = 'index';

if ($URI->segment(1) == 'admin') {
    $directory = 'admin/';
    
    if ($URI->segment(2)) {
        $controller = ucfirst($URI->segment(2));
    }
    
    if ($URI->segment(3)) {
        $method = $URI->segment(3);
    }
}

// Carregar o controller
$controller_path = APPPATH . 'controllers/' . $directory . $controller . '.php';

if (file_exists($controller_path)) {
    require_once($controller_path);
    $class = new $controller();
    
    if (method_exists($class, $method)) {
        $class->$method($URI->segment(4), $URI->segment(5));
    } else {
        show_404();
    }
} else {
    show_404();
}